package com.ejianc.business.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;

/**
 * <p>
 * 其他费用
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@TableName("ejc_equipment_purchase_settlement_fee")
public class PurchaseSettlementFeeEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    @TableField("settlement_id")
    private Long settlementId;

    /**
     * 费用类型
     */
    @TableField("fee_type")
    private String feeType;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    /**
     * 税率
     */
    @TableField("free_tax_rate")
    private BigDecimal freeTaxRate;

    /**
     * 金额（含税）
     */
    @TableField("tax_money")
    private BigDecimal taxMoney;

    public BigDecimal getFreeTaxRate() {
        return freeTaxRate;
    }

    public void setFreeTaxRate(BigDecimal freeTaxRate) {
        this.freeTaxRate = freeTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }
    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
