package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

/**
 * <p>
 * 设备明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_equipment_rent_settlement_detail")
public class RentSettlementDetailEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 结算表主键
     */
    @TableField("settlement_id")
    private Long settlementId;

    /**
     * 设备档案主键
     */
    @TableField("equipment_id")
    private Long equipmentId;

    /**
     * 合同明细主键
     */
    @TableField("contract_detail_id")
    private Long contractDetailId;

    /**
     * 合同使用记录主键
     */
    @TableField("use_id")
    private Long useId;

    /**
     * 合同使用记录子表主键
     */
    @TableField("use_detail_id")
    private Long useDetailId;

    /**
     * 使用记录编码
     */
    @TableField("use_code")
    private String useCode;

    /**
     * 来源类型,0-设备档案,1-设备使用记录,2-设备租赁合同
     */
    @TableField("source")
    private Integer source;
    /**
     * 来源名称
     */
    @TableField("source_name")
    private String sourceName;
    /**
     * 设备编码
     */
    @TableField("code")
    private String code;

    /**
     * 设备名称
     */
    @TableField("name")
    private String name;

    /**
     * 规格型号
     */
    @TableField("spec")
    private String spec;

    /**
     * 计量单位名称
     */
    @TableField("unit_name")
    private String unitName;

    /**
     * 单价
     */
    @TableField("price")
    private BigDecimal price;

    /**
     * 数量
     */
    @TableField("num")
    private BigDecimal num;

    /**
     * 金额
     */
    @TableField("money")
    private BigDecimal money;

    /**
     * 本期结算金额
     */
    @TableField("settlement_mny")
    private BigDecimal settlementMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 起租日期
     */
    @TableField("start_date")
    private Date startDate;

    /**
     * 停租日期
     */
    @TableField("end_date")
    private Date endDate;
    /**
     * 租期
     */
    @TableField("rent_term")
    private String rentTerm;
    /**
     * 成本科目主键
     */
    @TableField(value = "subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    /**
     * 单价(含税)
     */
    @TableField("tax_price")
    private BigDecimal taxPrice;

    /**
     * 税率
     */
    @TableField("detai_tax_rate")
    private BigDecimal detaiTaxRate;

    /**
     * 金额（含税）
     */
    @TableField("tax_money")
    private BigDecimal taxMoney;

    /**
     * 税额
     */
    @TableField("tax")
    private BigDecimal tax;

    /**
     * 本期结算金额
     */
    @TableField("settlement_tax_mny")
    private BigDecimal settlementTaxMny;

    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getDetaiTaxRate() {
        return detaiTaxRate;
    }

    public void setDetaiTaxRate(BigDecimal detaiTaxRate) {
        this.detaiTaxRate = detaiTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getRentTerm() {
        return rentTerm;
    }

    public void setRentTerm(String rentTerm) {
        this.rentTerm = rentTerm;
    }

    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public Long getEquipmentId() {
        return equipmentId;
    }

    public void setEquipmentId(Long equipmentId) {
        this.equipmentId = equipmentId;
    }
    public Long getContractDetailId() {
        return contractDetailId;
    }

    public void setContractDetailId(Long contractDetailId) {
        this.contractDetailId = contractDetailId;
    }
    public Long getUseId() {
        return useId;
    }

    public void setUseId(Long useId) {
        this.useId = useId;
    }
    public Long getUseDetailId() {
        return useDetailId;
    }

    public void setUseDetailId(Long useDetailId) {
        this.useDetailId = useDetailId;
    }

    public String getUseCode() {
        return useCode;
    }

    public void setUseCode(String useCode) {
        this.useCode = useCode;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public BigDecimal getMoney() {
        return money;
    }

    public void setMoney(BigDecimal money) {
        this.money = money;
    }
    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }


}
