package com.ejianc.business.equipment.bean;

import java.math.BigDecimal;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;

/**
 * <p>
 * 其他费用
 * </p>
 *
 * @author yqls
 * @since 2020-06-10
 */
@TableName("ejc_equipment_rent_settlement_fee")
public class RentSettlementFeeEntity extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /**
     * 结算主键
     */
    @TableField("settlement_id")
    private Long settlementId;

    /**
     * 费用类型
     */
    @TableField("fee_type")
    private String feeType;

    /**
     * 金额
     */
    @TableField("feemoney")
    private BigDecimal feemoney;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;
    /**
     * 成本科目主键
     */
    @TableField("subject_id")
    private Long subjectId;
    /**
     * 成本科目名称
     */
    @TableField("subject_name")
    private String subjectName;

    /**
     * 税率
     */
    @TableField("free_tax_rate")
    private BigDecimal freeTaxRate;

    /**
     * 金额（含税）
     */
    @TableField("tax_money")
    private BigDecimal taxMoney;

    /**
     * 核算对象主键
     */
    @TableField(value="accounting_id")
    private java.lang.Long accountingId; // 核算对象主键

    /**
     * 核算对象名称
     */
    @TableField(value="accounting_name")
    private java.lang.String accountingName; // 核算对象名称

    /**
     * 集团成本科目主键
     */
    @TableField(value="org_subject_id")
    private java.lang.Long orgSubjectId;

    /**
     * 集团核算对象主键
     */
    @TableField(value="org_accounting_id")
    private java.lang.Long orgAccountingId;

    public BigDecimal getFreeTaxRate() {
        return freeTaxRate;
    }

    public void setFreeTaxRate(BigDecimal freeTaxRate) {
        this.freeTaxRate = freeTaxRate;
    }

    public BigDecimal getTaxMoney() {
        return taxMoney;
    }

    public void setTaxMoney(BigDecimal taxMoney) {
        this.taxMoney = taxMoney;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public BigDecimal getFeemoney() {
        return feemoney;
    }

    public void setFeemoney(BigDecimal feemoney) {
        this.feemoney = feemoney;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 核算对象主键
     */
    public Long getAccountingId() {
        return accountingId;
    }

    /**
     * 核算对象主键
     */
    public void setAccountingId(Long accountingId) {
        this.accountingId = accountingId;
    }

    /**
     * 核算对象名称
     */
    public String getAccountingName() {
        return accountingName;
    }

    /**
     * 核算对象名称
     */
    public void setAccountingName(String accountingName) {
        this.accountingName = accountingName;
    }

    /**
     * 集团成本科目主键
     */
    public Long getOrgSubjectId() {
        return orgSubjectId;
    }

    /**
     * 集团成本科目主键
     */
    public void setOrgSubjectId(Long orgSubjectId) {
        this.orgSubjectId = orgSubjectId;
    }

    /**
     * 集团核算对象主键
     */
    public Long getOrgAccountingId() {
        return orgAccountingId;
    }

    /**
     * 集团核算对象主键
     */
    public void setOrgAccountingId(Long orgAccountingId) {
        this.orgAccountingId = orgAccountingId;
    }
}
