package com.ejianc.business.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备合同结算表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@TableName("ejc_equipment_purchase_settlement")
public class PurchaseSettlementEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 采购类型 1-自采，2-集采
     */
    @TableField("purchase_type")
    private String purchaseType;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 总包
     */
    @TableField("customer_id")
    private Long customerId;

    /**
     * 总包名称
     */
    @TableField("customer_name")
    private String customerName;

    /**
     * 设备供应商
     */
    @TableField("supplier_id")
    private Long supplierId;

    /**
     * 供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 结算日期
     */
    @TableField("settlement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date settlementDate;

    /**
     * 设备合同金额(不含税)
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 设备合同金额
     */
    @TableField("contract_tax_mny")
    private BigDecimal contractTaxMny;

    /**
     * 合同税率
     */
    @TableField("tax_rate")
    private BigDecimal taxRate;

    /**
     * 本期结算金额(不含税)
     */
    @TableField("settlement_mny")
    private BigDecimal settlementMny;

    /**
     * 本期结算金额(含税)
     */
    @TableField("settlement_tax_mny")
    private BigDecimal settlementTaxMny;

    /**
     * 税金
     */
    @TableField("tax_mny")
    private BigDecimal taxMny;

    /**
     * 本次冲抵金额
     */
    @TableField("offset_mny")
    private BigDecimal offsetMny;

    /**
     * 累计预付款金额
     */
    @TableField("sum_prepay_mny")
    private BigDecimal sumPrepayMny;

    /**
     * 累计付款金额
     */
    @TableField("sum_pay_mny")
    private BigDecimal sumPayMny;

    /**
     * 累计冲抵金额
     */
    @TableField("sum_offset_mny")
    private BigDecimal sumOffsetMny;

    /**
     * 累计结算金额(不含税)
     */
    @TableField("sum_settlement_mny")
    private BigDecimal sumSettlementMny;

    /**
     * 累计结算金额
     */
    @TableField("sum_settlement_tax_mny")
    private BigDecimal sumSettlementTaxMny;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 合同结算编码
     */
    @TableField("bill_code")
    private String billCode;

    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="PurchaseSettlementDetailService",pidName = "settlementId")
    private List<PurchaseSettlementDetailEntity> purchasedetail = new ArrayList<>();

    // 其他费用子表
    @TableField(exist = false)
    @SubEntity(serviceName="PurchaseSettlementFeeService",pidName = "settlementId")
    private List<PurchaseSettlementFeeEntity> purchasefee = new ArrayList<>();

    /**
     * 累计已申请金额
     */
    @TableField("sum_apply_mny")
    private BigDecimal sumApplyMny;

    /**
     * 剩余可申请金额
     */
    @TableField("surplus_apply_mny")
    private BigDecimal surplusApplyMny;
    /**
     * 关联状态(1:是，0：否)
     */
    @TableField("relation_flag")
    private String relationFlag;
    /**
     * 分摊状态(1:是，0：否)
     */
    @TableField("proportion_flag")
    private String proportionFlag;

    /**
     * 结算类型(0:过程结算，1:最终结算)
     */
    @TableField("settlement_type")
    private Integer settlementType;

    /**
     * 项目结算:0-否，1-是
     */
    @TableField("project_settle_flag")
    private String projectSettleFlag;

    public String getProjectSettleFlag() {
        return projectSettleFlag;
    }

    public void setProjectSettleFlag(String projectSettleFlag) {
        this.projectSettleFlag = projectSettleFlag;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }
    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }

    public List<PurchaseSettlementDetailEntity> getPurchasedetail() {
        return purchasedetail;
    }

    public void setPurchasedetail(List<PurchaseSettlementDetailEntity> purchasedetail) {
        this.purchasedetail = purchasedetail;
    }

    public List<PurchaseSettlementFeeEntity> getPurchasefee() {
        return purchasefee;
    }

    public void setPurchasefee(List<PurchaseSettlementFeeEntity> purchasefee) {
        this.purchasefee = purchasefee;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSettlementDate() {
        return settlementDate;
    }

    public void setSettlementDate(Date settlementDate) {
        this.settlementDate = settlementDate;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getSettlementMny() {
        return settlementMny;
    }

    public void setSettlementMny(BigDecimal settlementMny) {
        this.settlementMny = settlementMny;
    }

    public BigDecimal getSettlementTaxMny() {
        return settlementTaxMny;
    }

    public void setSettlementTaxMny(BigDecimal settlementTaxMny) {
        this.settlementTaxMny = settlementTaxMny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getOffsetMny() {
        return offsetMny;
    }

    public void setOffsetMny(BigDecimal offsetMny) {
        this.offsetMny = offsetMny;
    }

    public BigDecimal getSumPrepayMny() {
        return sumPrepayMny;
    }

    public void setSumPrepayMny(BigDecimal sumPrepayMny) {
        this.sumPrepayMny = sumPrepayMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumOffsetMny() {
        return sumOffsetMny;
    }

    public void setSumOffsetMny(BigDecimal sumOffsetMny) {
        this.sumOffsetMny = sumOffsetMny;
    }

    public BigDecimal getSumSettlementMny() {
        return sumSettlementMny;
    }

    public void setSumSettlementMny(BigDecimal sumSettlementMny) {
        this.sumSettlementMny = sumSettlementMny;
    }

    public BigDecimal getSumSettlementTaxMny() {
        return sumSettlementTaxMny;
    }

    public void setSumSettlementTaxMny(BigDecimal sumSettlementTaxMny) {
        this.sumSettlementTaxMny = sumSettlementTaxMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
