package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.equipment.bean.PurchaseContractClauseEntity;
import com.ejianc.business.equipment.bean.PurchaseContractFeeEntity;
import com.ejianc.business.equipment.mapper.PurchaseContractClauseMapper;
import com.ejianc.business.equipment.mapper.PurchaseContractFeeMapper;
import com.ejianc.business.equipment.service.IPurchaseContractClauseService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("PurchaseContractClauseService")
public class PurchaseContractClauseServiceImpl extends BaseServiceImpl<PurchaseContractClauseMapper, PurchaseContractClauseEntity> implements IPurchaseContractClauseService {

    @Autowired
    private PurchaseContractClauseMapper purchaseCostMapper;
    @Override
    public void deleteByContractId(Long id) {
        QueryWrapper<PurchaseContractClauseEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.eq("contract_id", id);
        purchaseCostMapper.delete(deleteWrapper);
    }
}