package com.ejianc.business.equipment.controller;


import com.ejianc.business.equipment.service.IPurchaseRecordService;
import com.ejianc.business.equipment.service.IRentRecordService;
import com.ejianc.business.equipment.vo.PurchaseRecordVO;
import com.ejianc.business.equipment.vo.RentRecordVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 设备合同表 前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-09
 */
@RestController
@RequestMapping("rentRecord")
public class RentRecordController {
    @Autowired
    private IRentRecordService rentRecordService;
    /**
     * 根据主键ID查询详情
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentRecordVO> queryDetail(@RequestParam Long id) {
        RentRecordVO rentRecordVO = rentRecordService.queryDetail(id);
        return CommonResponse.success(rentRecordVO);
    }

}
