package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.mapper.PurchaseSettlementMapper;
import com.ejianc.business.equipment.service.IPurchaseChangeService;
import com.ejianc.business.equipment.service.IPurchaseContractService;
import com.ejianc.business.equipment.service.IPurchaseSettlementService;
import com.ejianc.business.equipment.vo.PurchaseSettlementRecordVO;
import com.ejianc.business.equipment.vo.PurchaseSettlementVO;
import com.ejianc.business.finance.api.IPayContractApi;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import static java.math.BigDecimal.ROUND_HALF_DOWN;

/**
 * <p>
 * 设备合同结算表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("PurchaseSettlementService")
public class PurchaseSettlementServiceImpl extends BaseServiceImpl<PurchaseSettlementMapper, PurchaseSettlementEntity> implements IPurchaseSettlementService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String PURCHASE_SETTLEMENT_BILL_CODE = "EQUIPMENT_SETTLEMENT";
    private static final String EQUIPMENT_PURCHASE_SETTLE = "EQUIPMENT_PURCHASE_SETTLE";
    private static final String EQUIPMENT_PURCHASE_SETTLE_DETAIL = "EQUIPMENT_PURCHASE_SETTLE_DETAIL";
    private static final String EQUIPMENT_PURCHASE_SETTLE_FEE = "EQUIPMENT_PURCHASE_SETTLE_FEE";
    private static final String CHECK_PARAM_CODE = "P-ogZh3516";

    @Autowired
    private IPurchaseContractService purchaseContractService;


    @Autowired
    private IPurchaseChangeService purchaseChangeService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IPayContractApi payContractApi;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public CommonResponse<PurchaseSettlementVO> saveOrUpdate(PurchaseSettlementVO purchaseSettlementVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseSettlementEntity entity = null;
        //合同只能存在一条未生效的
        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange.eq(PurchaseSettlementEntity::getTenantId, tenantId);
        lambdachange.eq(PurchaseSettlementEntity::getContractId,purchaseSettlementVo.getContractId());
        lambdachange.eq(PurchaseSettlementEntity::getOrgId,purchaseSettlementVo.getOrgId());
        if(null!=purchaseSettlementVo.getId()&&purchaseSettlementVo.getId()>0){
            lambdachange.ne(PurchaseSettlementEntity::getId,purchaseSettlementVo.getId());
        }
        lambdachange.ne(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
        lambdachange.ne(PurchaseSettlementEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
        int num = super.count(lambdachange);
        if(num>0){
            throw new BusinessException("该合同该组织下已存在未生效的结算单!");
        }
        if(1==purchaseSettlementVo.getSettlementType()){
            LambdaQueryWrapper<PurchaseContractEntity> lambdachange2 = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambdachange2.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambdachange2.eq(PurchaseContractEntity::getMainContractId,purchaseSettlementVo.getContractId());
            lambdachange2.ne(PurchaseContractEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdachange2.ne(PurchaseContractEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
            int nums= purchaseContractService.count(lambdachange2);
            if(nums>0){
                throw new BusinessException("该合同存在未生效的合同补充协议，不允许做最终结算");
            }

            LambdaQueryWrapper<PurchaseChangeEntity> lambdachange3 = Wrappers.<PurchaseChangeEntity>lambdaQuery();
            lambdachange3.eq(PurchaseChangeEntity::getTenantId, tenantId);
            lambdachange3.eq(PurchaseChangeEntity::getContractId,purchaseSettlementVo.getContractId());
            lambdachange3.ne(PurchaseChangeEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode());
            lambdachange3.ne(PurchaseChangeEntity::getBillState,BillStateEnum.COMMITED_STATE.getBillStateCode());
            int numc= purchaseChangeService.count(lambdachange3);
            if(numc>0){
                throw new BusinessException("该合同存在未生效的变更单，不允许做最终结算");
            }
        }
        //保存时校验合同version是否一致
        if(purchaseSettlementVo.getContractVersion()!=null&&purchaseSettlementVo.getContractVersion()!=0){
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try{
                locked = RedisTool.tryLock(jedis, String.valueOf(purchaseSettlementVo.getContractId()), "saveOrUpdate", 1000);
                logger.info("判断单据单据锁结果------"+locked);
                if(locked){
                    PurchaseContractEntity contractEntity = purchaseContractService.selectById(purchaseSettlementVo.getContractId());
                    Integer version = contractEntity.getVersion()==null?0:contractEntity.getVersion();
                    Integer conVersion = purchaseSettlementVo.getContractVersion();
                    if(!version.equals(conVersion)){
                        return CommonResponse.error("该合同已被更新，请刷新后重做！");
                    }
                }else{
                    return CommonResponse.error("出现并发操作,请稍后重试！");
                }
            }catch (Exception e) {
                e.printStackTrace();
            } finally {
                if(locked) {
                    RedisTool.releaseLock(jedis, String.valueOf(purchaseSettlementVo.getContractId()), "saveOrUpdate");
                }
                jedis.close();
            }

        }

        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange2.eq(PurchaseSettlementEntity::getTenantId, tenantId);
        lambdachange2.eq(PurchaseSettlementEntity::getContractId,purchaseSettlementVo.getContractId());
        lambdachange2.eq(PurchaseSettlementEntity::getOrgId,purchaseSettlementVo.getOrgId());
        if(null!=purchaseSettlementVo.getId()&&purchaseSettlementVo.getId()>0){
            lambdachange2.ne(PurchaseSettlementEntity::getId,purchaseSettlementVo.getId());
        }
        lambdachange2.in(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambdachange2.gt(PurchaseSettlementEntity ::getSettlementDate,purchaseSettlementVo.getSettlementDate());
        int num2 = super.count(lambdachange2);
        if(num2>0){
            throw new BusinessException("结算日期必须大于等于该合同对应最新结算日期!");
        }
        BigDecimal settlementTaxMny = purchaseSettlementVo.getSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSettlementTaxMny();
        BigDecimal offsetMny = purchaseSettlementVo.getOffsetMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getOffsetMny();//本次冲抵金额
        BigDecimal syMny = purchaseSettlementVo.getSymny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSymny();//剩余冲抵金额
        if(offsetMny.compareTo(syMny)>0){
            throw new BusinessException("本次冲抵金额不允许大于剩余可冲抵金额!");
        }
        if(offsetMny.compareTo(settlementTaxMny)>0&& settlementTaxMny.compareTo(BigDecimal.ZERO)>=0){
            throw new BusinessException("本次冲抵金额不允许大于本期结算金额");
        }
        if(StringUtils.isEmpty(purchaseSettlementVo.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(PURCHASE_SETTLEMENT_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                purchaseSettlementVo.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //成本改造
        //设置是否关联
        purchaseSettlementVo.setRelationFlag("0");
        purchaseSettlementVo.setProportionFlag("0");
        entity = BeanMapper.map(purchaseSettlementVo, PurchaseSettlementEntity.class);
        super.saveOrUpdate(entity,false);
        PurchaseSettlementVO vo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            vo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        vo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        /** 如果是最终结算，需回写合同 */
        if(1==purchaseSettlementVo.getSettlementType()){
            PurchaseContractEntity contractEntity = purchaseContractService.selectById(purchaseSettlementVo.getContractId());
            contractEntity.setSettlementType(1);//最终结算
            purchaseContractService.updateById(contractEntity);
        }
        return CommonResponse.success(vo);
    }
    
    @Override
    public PurchaseSettlementVO queryDetail(Long id) {
        PurchaseSettlementEntity entity = super.selectById(id);
        PurchaseSettlementVO purchaseSettlementVo = BeanMapper.map(entity, PurchaseSettlementVO.class);
        BigDecimal c = purchaseSettlementVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVo.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            purchaseSettlementVo.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        /** 剩余冲抵金额 = 累计预付款 - 累计已冲抵 */
        BigDecimal sumPrePayMny =entity.getSumPrepayMny()==null?BigDecimal.ZERO:entity.getSumPrepayMny();
        BigDecimal sumOffsetMny =entity.getSumOffsetMny()==null?BigDecimal.ZERO:entity.getSumOffsetMny();
        purchaseSettlementVo.setSymny(sumPrePayMny.subtract(sumOffsetMny));
        return purchaseSettlementVo;
    }
    @Override
    public PurchaseSettlementVO queryDetails(Long id) {
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        PurchaseSettlementVO purchaseSettlementVO = BeanMapper.map(entity, PurchaseSettlementVO.class);
        //新增逻辑处理
        purchaseSettlementVO.setContractId(purchaseSettlementVO.getId());
        //新增即点变更按钮穿透过来，此时ID为合同id
        purchaseSettlementVO.setId(null);
        purchaseSettlementVO.setBillCode(null);
        purchaseSettlementVO.setBillState(null);
        purchaseSettlementVO.setCreateUserCode(null);
        purchaseSettlementVO.setCreateTime(null);
        purchaseSettlementVO.setSettlementDate(new Date());
        purchaseSettlementVO.setUpdateUserCode(null);
        purchaseSettlementVO.setUpdateTime(null);
        purchaseSettlementVO.setPurchasedetail(null);
        purchaseSettlementVO.setPurchasefee(null);
        purchaseSettlementVO.setTaxMny(BigDecimal.ZERO);
        purchaseSettlementVO.setContractVersion(entity.getVersion());

        CommonResponse<SumPayMnyVO> sumPayMnyVO = payContractApi.getSumPayMny(id,entity.getOrgId());
        if(!sumPayMnyVO.isSuccess()) {
            throw new BusinessException("获取付款信息失败，请刷新后再试！");
        }
        BigDecimal sumPayMny = sumPayMnyVO.getData().getSumPayMny();
        BigDecimal sumPrePayMny = sumPayMnyVO.getData().getSumPrePayMny();
        purchaseSettlementVO.setSumPayMny(sumPayMny==null?BigDecimal.ZERO:sumPayMny);
        purchaseSettlementVO.setSumPrepayMny(sumPrePayMny==null?BigDecimal.ZERO:sumPrePayMny);
        LambdaQueryWrapper<PurchaseSettlementEntity> lambdachange = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambdachange.eq(PurchaseSettlementEntity::getTenantId, InvocationInfoProxy.getTenantid());
        lambdachange.eq(PurchaseSettlementEntity::getContractId,id);
        lambdachange.eq(PurchaseSettlementEntity::getOrgId,entity.getOrgId());
        lambdachange.in(PurchaseSettlementEntity::getBillState,BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<PurchaseSettlementEntity> list = super.list(lambdachange);
        if(CollectionUtils.isNotEmpty(list)){
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP),new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            list.forEach(e-> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
                settlementMoney[1] = settlementMoney[1].add(e.getOffsetMny()==null? BigDecimal.ZERO:e.getOffsetMny());
            });
            //累计结算金额
            purchaseSettlementVO.setSumSettlementTaxMny(settlementMoney[0]);
            //累计冲抵金额
            purchaseSettlementVO.setSumOffsetMny(settlementMoney[1]);
        }
        BigDecimal sumOffsetMnys = purchaseSettlementVO.getSumOffsetMny()==null?BigDecimal.ZERO:purchaseSettlementVO.getSumOffsetMny();
        if(purchaseSettlementVO.getSumPrepayMny().compareTo(BigDecimal.ZERO)>=0&&sumOffsetMnys.compareTo(BigDecimal.ZERO)>=0){
            purchaseSettlementVO.setSymny(purchaseSettlementVO.getSumPrepayMny().subtract(sumOffsetMnys));
        }

        BigDecimal c = purchaseSettlementVO.getContractTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVO.getContractTaxMny();
        BigDecimal cc = purchaseSettlementVO.getSumSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementVO.getSumSettlementTaxMny();
        if(c.compareTo(BigDecimal.ZERO)>0&&cc.compareTo(BigDecimal.ZERO)>0){
            purchaseSettlementVO.setLjjsbl(new BigDecimal(100).multiply(cc.divide(c,8,ROUND_HALF_DOWN)));
        }
        return purchaseSettlementVO;
    }
    @Override
    public void deletePurchaseSettlement(List<PurchaseSettlementVO> vos) {
        if(CollectionUtils.isNotEmpty(vos)){
            List<PurchaseContractEntity> list = new ArrayList<>();
            vos.forEach(e->{
                /** 如果是最终结算，需回写合同 */
                PurchaseSettlementEntity purchaseSettlementEntity = baseMapper.selectById(e.getId());
                if(1==purchaseSettlementEntity.getSettlementType()){
                    PurchaseContractEntity contractEntity = purchaseContractService.selectById(purchaseSettlementEntity.getContractId());
                    contractEntity.setSettlementType(0);//还原为过程结算
                    list.add(contractEntity);
                }
            });
            if(CollectionUtils.isNotEmpty(list)){
                purchaseContractService.updateBatchById(list);
            }
        }
        super.removeByIds(vos.stream().map(PurchaseSettlementVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public CommonResponse<PurchaseSettlementVO> pushCost(PurchaseSettlementVO purchaseSettlementVO) {
        PurchaseSettlementEntity purchaseSettlementEntity = baseMapper.selectById(purchaseSettlementVO.getId());
        if (ListUtil.isNotEmpty(purchaseSettlementVO.getPurchasedetail())){
            List<PurchaseSettlementDetailEntity> purchaseSettleDetail = BeanMapper.mapList(purchaseSettlementVO.getPurchasedetail(), PurchaseSettlementDetailEntity.class);
            purchaseSettlementEntity.setPurchasedetail(purchaseSettleDetail);
        }
        if (ListUtil.isNotEmpty(purchaseSettlementVO.getPurchasefee())){
            List<PurchaseSettlementFeeEntity> purchaseSettleFee = BeanMapper.mapList(purchaseSettlementVO.getPurchasefee(), PurchaseSettlementFeeEntity.class);
            purchaseSettlementEntity.setPurchasefee(purchaseSettleFee);
        }
        super.saveOrUpdate(purchaseSettlementEntity,false);
        //推送数据
        if(purchaseSettlementEntity.getBillState()==BillStateEnum.COMMITED_STATE.getBillStateCode()||purchaseSettlementEntity.getBillState()==BillStateEnum.PASSED_STATE.getBillStateCode()){
            costPush(purchaseSettlementEntity);
        }
        return CommonResponse.success(BeanMapper.map(purchaseSettlementEntity, PurchaseSettlementVO.class));
    }
    @Override
    public void costPush(PurchaseSettlementEntity settlementEntity) {
        //1.判断结算单所有子表是否全部关联科目
        List<PurchaseSettlementDetailEntity> purchasedetail = settlementEntity.getPurchasedetail();
        boolean newRelationFlag = true;
        if (ListUtil.isNotEmpty(purchasedetail)){
            for (PurchaseSettlementDetailEntity purchaseSettlementDetailEntity : purchasedetail){
                if (null == purchaseSettlementDetailEntity.getSubjectId() || null == purchaseSettlementDetailEntity.getAccountingId()){
                    newRelationFlag = false;
                    break;
                }
            }
        }
        //查询费用表是否全部关联费用科目
        List<PurchaseSettlementFeeEntity> purchasefee = settlementEntity.getPurchasefee();
        if (ListUtil.isNotEmpty(purchasefee) && newRelationFlag){
            for (PurchaseSettlementFeeEntity purchaseSettlementFeeEntity : purchasefee){
                if (null == purchaseSettlementFeeEntity.getFeeSubjectId() || null == purchaseSettlementFeeEntity.getFeeAccountingId()){
                    newRelationFlag = false;
                    break;
                }
            }
        }
        /*if (ListUtil.isEmpty(purchasedetail) && ListUtil.isEmpty(purchasefee)){
            newRelationFlag = false;
        }*/

        //更新是否关联
        LambdaUpdateWrapper<PurchaseSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PurchaseSettlementEntity::getId, settlementEntity.getId());
        updateWrapper.set(PurchaseSettlementEntity::getRelationFlag, newRelationFlag ? "1":"0");//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = settlementEntity.getRelationFlag();
        //之前已关联
        if (oldRelationFlag.equals("1")){
            if (newRelationFlag){
                saveCost(settlementEntity);
            }
            if (!newRelationFlag){
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(settlementEntity.getId());
            }
        }
        //之前未关联
        if (oldRelationFlag.equals("0")){
            if (newRelationFlag){
                //税率
                saveCost(settlementEntity);
            }
        }
    }
    @Override
    public PurchaseSettlementRecordVO querySettlementRecord(Long id) {
        PurchaseSettlementRecordVO vo = new PurchaseSettlementRecordVO();
        PurchaseContractEntity entity = purchaseContractService.selectById(id);
        BigDecimal contractTaxMny = entity.getContractTaxMny()==null?BigDecimal.ZERO:entity.getContractTaxMny();//合同金额
        vo.setContractTaxMny(contractTaxMny);
        vo.setContractId(id);
        vo.setSettlementType(entity.getSettlementType());
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
            throw new BusinessException("表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        LambdaQueryWrapper<PurchaseSettlementEntity> lambda = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda.eq(PurchaseSettlementEntity::getContractId,id);
        lambda.in(PurchaseSettlementEntity::getOrgId,commonOrgIds);
        lambda.in(PurchaseSettlementEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(),BillStateEnum.COMMITED_STATE.getBillStateCode());
        lambda.orderByDesc(PurchaseSettlementEntity::getCreateTime);
        List<PurchaseSettlementEntity> entities = super.list(lambda);
        if(CollectionUtils.isNotEmpty(entities)){
            final BigDecimal[] settlementMoney = {new BigDecimal("0.00").setScale(2, BigDecimal.ROUND_HALF_UP)};
            entities.forEach(e-> {
                settlementMoney[0] = settlementMoney[0].add(e.getSettlementTaxMny()==null? BigDecimal.ZERO:e.getSettlementTaxMny());
            });
            //累计结算金额
            vo.setSumSettlementTaxMny(settlementMoney[0]);
            BigDecimal sumSettlementTaxMny = vo.getSumSettlementTaxMny()==null?BigDecimal.ZERO:vo.getSumSettlementTaxMny();//累计结算金额
            if(sumSettlementTaxMny.compareTo(BigDecimal.ZERO)!=0&&contractTaxMny.compareTo(BigDecimal.ZERO)>0){
                vo.setSumScale(new BigDecimal(100).multiply(sumSettlementTaxMny.divide(contractTaxMny,8,ROUND_HALF_DOWN)));
            }else{
                vo.setSumScale(BigDecimal.ZERO);
            }
            vo.setSettlementRecord(BeanMapper.mapList(entities, PurchaseSettlementVO.class));
        }
        return vo;
    }
    private void saveCost(PurchaseSettlementEntity settlementEntity) {
        //税率
        BigDecimal rate = settlementEntity.getTaxRate() == null ? BigDecimal.ZERO : settlementEntity.getTaxRate();
        BigDecimal taxRate = rate.divide(new BigDecimal(100));
        BigDecimal number = taxRate.add(new BigDecimal(1));
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<PurchaseSettlementDetailEntity> pushPurchaseDetail = settlementEntity.getPurchasedetail();
        if (ListUtil.isNotEmpty(pushPurchaseDetail)){
            for (PurchaseSettlementDetailEntity purchaseSettlementDetailEntity : pushPurchaseDetail){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(purchaseSettlementDetailEntity.getSubjectId());
                costDetailVO.setOrgSubjectId(purchaseSettlementDetailEntity.getOrgSubjectId());
                costDetailVO.setAccountingId(purchaseSettlementDetailEntity.getAccountingId());
                costDetailVO.setOrgAccountingId(purchaseSettlementDetailEntity.getOrgAccountingId());
                costDetailVO.setSourceId(purchaseSettlementDetailEntity.getSettlementId());
                costDetailVO.setSourceDetailId(purchaseSettlementDetailEntity.getId());
                costDetailVO.setHappenTaxMny(purchaseSettlementDetailEntity.getSettlementTaxMny()==null?BigDecimal.ZERO:purchaseSettlementDetailEntity.getSettlementTaxMny());
                costDetailVO.setHappenMny(purchaseSettlementDetailEntity.getSettlementMny()==null?BigDecimal.ZERO:purchaseSettlementDetailEntity.getSettlementMny());
                costDetailVO.setHappenDate(settlementEntity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_PURCHASE_SETTLE_DETAIL);
                costDetailVO.setProjectId(settlementEntity.getProjectId());
                costDetailVOList.add(costDetailVO);

            }
        }
        //费用
        List<PurchaseSettlementFeeEntity> pushPurchaseFee = settlementEntity.getPurchasefee();
        if (ListUtil.isNotEmpty(pushPurchaseFee)){
            for (PurchaseSettlementFeeEntity purchaseSettlementFeeEntity : pushPurchaseFee){
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(purchaseSettlementFeeEntity.getFeeSubjectId());
                costDetailVO.setOrgSubjectId(purchaseSettlementFeeEntity.getFeeOrgSubjectId());
                costDetailVO.setAccountingId(purchaseSettlementFeeEntity.getFeeAccountingId());
                costDetailVO.setOrgAccountingId(purchaseSettlementFeeEntity.getFeeOrgAccountingId());
                costDetailVO.setSourceId(purchaseSettlementFeeEntity.getSettlementId());
                costDetailVO.setSourceDetailId(purchaseSettlementFeeEntity.getId());
                costDetailVO.setHappenTaxMny(purchaseSettlementFeeEntity.getTaxMoney()==null?BigDecimal.ZERO:purchaseSettlementFeeEntity.getTaxMoney());
                costDetailVO.setHappenMny(purchaseSettlementFeeEntity.getMoney()==null?BigDecimal.ZERO:purchaseSettlementFeeEntity.getMoney());
                costDetailVO.setHappenDate(settlementEntity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(EQUIPMENT_PURCHASE_SETTLE);
                costDetailVO.setSourceTabType(EQUIPMENT_PURCHASE_SETTLE_FEE);
                costDetailVO.setProjectId(settlementEntity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)){
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()){
            }else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    //成本改造
    @Override
    public void pullCost(Long id) {
        ////更新关联状态为未关联
        LambdaUpdateWrapper<PurchaseSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(PurchaseSettlementEntity::getId, id);
        updateWrapper.set(PurchaseSettlementEntity::getRelationFlag, "0");//(1:是，0：否)
        super.update(updateWrapper);
        //删除成本中心数据
        costDetailApi.deleteSubject(id);
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny) {
        String[] paramsArray = {"none", "warn", "alert"};
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PARAM_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            BillParamVO billParamVO = billParamByCode.getData();
            BigDecimal roleValue = billParamVO.getRoleValue();
            BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
            BigDecimal comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100)));
            if(2 == purchaseType){//集采合同直接赋值为不控制
                paramsCheckVO.setWarnType(paramsArray[0]);
                return  paramsCheckVO;
            }else{
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if(sumPayWithThisMny.compareTo(comMny) > 0){
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("合同超结");
                paramsCheckDsVO.setWarnName("结算金额大于合同金额");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("本次结算金额：").append(payMny.toString()).append("元，合同金额*").append(roleValue).append("%:").append(comMny).append("元。超出金额：").append(sumPayWithThisMny.subtract(comMny)).append("元");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                checkDsVOS.add(paramsCheckDsVO);
            }
            paramsCheckVO.setDataSource(checkDsVOS);
        }else{
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }

        return paramsCheckVO;
    }
}
