package com.ejianc.business.equipment.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 设备使用申请表
 * </p>
 *
 * @author yqls
 * @since 2020-06-06
 */
@TableName("ejc_equipment_apply")
public class ApplyEntity extends BaseEntity {

    private static final long serialVersionUID = 2779265683222439571L;

    /**
     * 申请单编码
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 计划日期
     */
    @TableField("plan_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 单据状态（审批必须字段）
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 机械设备名称合集
     */
    @TableField("equipment_name")
    private String equipmentName;
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="ApplyDetailService",pidName = "applyId")
    private List<ApplyDetailEntity> applyDetail = new ArrayList<>();
    
    /**
     * 预计工作内容
     */
    @TableField("plan_work")
    private String planWork;
    
    /**
     * 到场时间
     */
    @TableField("arrival_date")
    private String arrivalDate;
    
    /**
     * 联系人
     */
    @TableField("contacts")
    private String contacts;
    
    /**
     * 联系人电话
     */
    @TableField("contact_num")
    private String contactNum;
    

    public String getPlanWork() {
		return planWork;
	}

	public void setPlanWork(String planWork) {
		this.planWork = planWork;
	}

	public String getArrivalDate() {
		return arrivalDate;
	}

	public void setArrivalDate(String arrivalDate) {
		this.arrivalDate = arrivalDate;
	}

	public String getContacts() {
		return contacts;
	}

	public void setContacts(String contacts) {
		this.contacts = contacts;
	}

	public String getContactNum() {
		return contactNum;
	}

	public void setContactNum(String contactNum) {
		this.contactNum = contactNum;
	}

	public List<ApplyDetailEntity> getApplyDetail() {
        return applyDetail;
    }

    public void setApplyDetail(List<ApplyDetailEntity> applyDetail) {
        this.applyDetail = applyDetail;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEquipmentName() {
        return equipmentName;
    }

    public void setEquipmentName(String equipmentName) {
        this.equipmentName = equipmentName;
    }

}
