package com.ejianc.business.equipment.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.bean.*;
import com.ejianc.business.equipment.controller.SqlParam;
import com.ejianc.business.equipment.mapper.PurchaseContractMapper;
import com.ejianc.business.equipment.service.*;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.equipment.vo.PurchaseContractDetailVO;
import com.ejianc.business.equipment.vo.PurchaseContractVO;
import com.ejianc.business.equipment.vo.warn.EquipmentWarnVo;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("PurchaseContractService")
public class PurchaseContractServiceImpl extends BaseServiceImpl<PurchaseContractMapper, PurchaseContractEntity> implements IPurchaseContractService {

    private static final String PURCHASE_CONTRACT_BILL_CODE = "EQUIPMENT_PURCHASE";

    @Autowired
    private IPurchaseChangeService purchaseChangeService;


    @Autowired
    private IPurchaseContractDetailService purchaseContractDetailService;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPurchaseSettlementService purchaseSettlementService;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IRentSettlementService settlementService;
    @Autowired
    private CommonBillCodeService commonBillCodeService;
    @Autowired
    private ISupplementPurchaseContractService supplementPurchaseContractService;
    @Override
    public CommonResponse<PurchaseContractVO> saveOrUpdate(PurchaseContractVO purchaseContractVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        PurchaseContractEntity entity = BeanMapper.map(purchaseContractVo, PurchaseContractEntity.class);
        String operateType = null;
        List<PurchaseContractEntity> entities = null;
        List<PurchaseChangeEntity> entitiesc = null;
        if(StringUtils.isEmpty(purchaseContractVo.getBillCode())){
            String code = commonBillCodeService.getCodeByOrgId(purchaseContractVo.getOrgId(), PURCHASE_CONTRACT_BILL_CODE, purchaseContractVo);
            entity.setBillCode(code);
        }
        if(purchaseContractVo.getId() != null && purchaseContractVo.getId() > 0) {
            //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.ne(PurchaseContractEntity::getId, purchaseContractVo.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseContractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE,purchaseContractVo.getId()));
            entitiesc = purchaseChangeService.queryList(queryParam,false);
        }else{
            //校验合同编号是否重复
            LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
            lambda.eq(PurchaseContractEntity::getTenantId, tenantId);
            lambda.eq(PurchaseContractEntity::getBillCode, purchaseContractVo.getBillCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ,tenantId));
            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("bill_code", new Parameter(QueryParam.EQ,purchaseContractVo.getBillCode()));
            entitiesc = purchaseChangeService.queryList(queryParam,false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(1);
            entity.setIsSupplement("0");
        }
        if(entities != null && entities.size() > 0  && entitiesc != null && entitiesc.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setBaseMoney(purchaseContractVo.getContractMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractMny());
        entity.setBaseTaxMoney(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
        entity.setBeforeChangeMny(purchaseContractVo.getContractMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractMny());
        entity.setBeforeChangeTaxMny(purchaseContractVo.getContractTaxMny()==null?BigDecimal.ZERO:purchaseContractVo.getContractTaxMny());
//        entity.setDr(0);
        super.saveOrUpdate(entity,false);

        return CommonResponse.success(BeanMapper.map(entity, PurchaseContractVO.class));
    }

    @Override
    public PurchaseContractVO queryDetail(Long id) {
        PurchaseContractEntity entity = super.selectById(id);
        //先请客详情表
        entity.setPurchasedetail(null);
        PurchaseContractVO purchaseContractVo = BeanMapper.map(entity, PurchaseContractVO.class);
        List<PurchaseContractDetailEntity> details = null;
        LambdaQueryWrapper<PurchaseContractDetailEntity> lambda = Wrappers.<PurchaseContractDetailEntity>lambdaQuery();
        lambda.eq(PurchaseContractDetailEntity::getContractId,id);
        lambda.ne(PurchaseContractDetailEntity::getChangeType,"3");
        details = purchaseContractDetailService.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            purchaseContractVo.setPurchasedetail(BeanMapper.mapList(details,PurchaseContractDetailVO.class));
        }
        return purchaseContractVo;
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        wrapper.select("sum(base_tax_money) as originalAmount, sum(contract_tax_mny) as curAmount");
        resp = super.getMap(wrapper);
//
        return resp;
    }
    @Override
    public void deletePurchaseContract(List<PurchaseContractVO> vos) {
        super.removeByIds(vos.stream().map(PurchaseContractVO::getId).collect(Collectors.toList()),false);
    }

    @Override
    public List<Map<String, Object>> querySettleWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.querySettleWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryPayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPayWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> queryPrePayWarnContract(List<SqlParam> sqlParamList) {
        return baseMapper.queryPrePayWarnContract(sqlParamList);
    }
    @Override
    public List<Map<String, Object>> invoicePayMnyWarn(List<SqlParam> sqlParamList) {
        return baseMapper.invoicePayMnyWarn(sqlParamList);
    }

    @Override
    public List<EquipmentWarnVo> equipmentProjectOutMny(List<Long> tenantIds) {
        return baseMapper.equipmentProjectOutMny(tenantIds);
    }

    @Override
    public List<EquipmentReportVo> getMonthEquipmentMny(Long projectId, Integer lastDay) {
        return baseMapper.getMonthEquipmentMny(projectId,lastDay);
    }

    @Override
    public List<EquipmentReportVo> getEquipment(Long projectId) {
        BigDecimal cgmny = BigDecimal.ZERO;//采购
        BigDecimal cgsettleMny = BigDecimal.ZERO;//采购结算
        List<Integer> billStatus = new ArrayList<>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper<PurchaseContractEntity> lambda = Wrappers.<PurchaseContractEntity>lambdaQuery();
        lambda.eq(PurchaseContractEntity::getProjectId, projectId);
        lambda.eq(PurchaseContractEntity::getDr, 0);
        lambda.eq(PurchaseContractEntity::getSupplementFlag, 0);
        lambda.in(PurchaseContractEntity::getBillState, billStatus);
        List<PurchaseContractEntity> quoteEntities = super.list(lambda);
        for (PurchaseContractEntity ce : quoteEntities) {
            cgmny = MathUtil.safeAdd(cgmny, ce.getContractTaxMny());
        }
        LambdaQueryWrapper<PurchaseSettlementEntity> lambda2 = Wrappers.<PurchaseSettlementEntity>lambdaQuery();
        lambda2.eq(PurchaseSettlementEntity::getProjectId, projectId);
        lambda2.eq(PurchaseSettlementEntity::getDr, 0);
        lambda2.in(PurchaseSettlementEntity::getBillState, billStatus);
        List<PurchaseSettlementEntity> purchaseSettlementEntities = purchaseSettlementService.list(lambda2);
        for (PurchaseSettlementEntity ce : purchaseSettlementEntities) {
            cgsettleMny = MathUtil.safeAdd(cgsettleMny, ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo =new EquipmentReportVo();
        vo.setMny(cgmny);
        vo.setNum(quoteEntities.size());
        vo.setSettleMny(cgsettleMny);

        BigDecimal zlmny = BigDecimal.ZERO;//租赁
        BigDecimal zlsettleMny = BigDecimal.ZERO;//租赁结算
        LambdaQueryWrapper<RentContractEntity> lambda3 = Wrappers.<RentContractEntity>lambdaQuery();
        lambda3.eq(RentContractEntity::getProjectId, projectId);
        lambda3.eq(RentContractEntity::getDr, 0);
        lambda3.eq(RentContractEntity::getSupplementFlag, 0);
        lambda3.in(RentContractEntity::getBillState, billStatus);
        List<RentContractEntity> rentContractEntities = rentContractService.list(lambda3);
        for (RentContractEntity ce : rentContractEntities) {
            zlmny = MathUtil.safeAdd(zlmny, ce.getContractTaxMny());
        }
        LambdaQueryWrapper<RentSettlementEntity> lambda4 = Wrappers.<RentSettlementEntity>lambdaQuery();
        lambda4.eq(RentSettlementEntity::getProjectId, projectId);
        lambda4.eq(RentSettlementEntity::getDr, 0);
        lambda4.in(RentSettlementEntity::getBillState, billStatus);
        List<RentSettlementEntity> rentSettlementEntities = settlementService.list(lambda4);
        for (RentSettlementEntity ce : rentSettlementEntities) {
            zlsettleMny = MathUtil.safeAdd(zlsettleMny, ce.getSettlementTaxMny());
        }
        EquipmentReportVo vo2 =new EquipmentReportVo();
        vo2.setMny(zlmny);
        vo2.setNum(rentContractEntities.size());
        vo2.setSettleMny(zlsettleMny);
        List<EquipmentReportVo> list=new ArrayList<>();
        list.add(vo);
        list.add(vo2);
        return list;
    }
    
	@Override
	public void updateContractIsSupplementFlag(Long id) {
		PurchaseContractEntity contractEntity = baseMapper.selectById(id);
        LambdaQueryWrapper<SupplementPurchaseContractEntity> lambda = Wrappers.<SupplementPurchaseContractEntity>lambdaQuery();
        lambda.eq(SupplementPurchaseContractEntity::getMainContractId, id);
        lambda.orderByDesc(SupplementPurchaseContractEntity::getSignDate);
        List<SupplementPurchaseContractEntity> entities = supplementPurchaseContractService.list(lambda);
        if(entities.size()>0) {
        	contractEntity.setIsSupplement("1");
        }else {
        	contractEntity.setIsSupplement("0");
        }
        baseMapper.updateById(contractEntity);
	}
}