package com.ejianc.foundation.file.util;

import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.StreamOpenOfficeDocumentConverter;
import com.ejianc.foundation.file.config.OfficeServerConfiguration;
import com.sun.star.document.UpdateDocMode;

/**
 * 创建文件转换器
 *
 * @date 2017/11/13
 */
@Component
public class ConverterUtils {

	@Autowired
	private OfficeServerConfiguration officeServerConfiguration;

	public Map<String, Object> getDocumentConverter() {
		Map<String, Object> resultMap = new HashMap<>();
		String officeService = officeServerConfiguration.getOfficeService();
		System.out.println("================" + officeService);
		OpenOfficeConnection openOfficeConnection = new SocketOpenOfficeConnection(officeService, 8100);
		try {
			openOfficeConnection.connect();
			StreamOpenOfficeDocumentConverter converter = new StreamOpenOfficeDocumentConverter(openOfficeConnection);
			converter.setDefaultLoadProperty("Hidden", true);
			converter.setDefaultLoadProperty("ReadOnly", true);
			converter.setDefaultLoadProperty("UpdateDocMode", UpdateDocMode.QUIET_UPDATE);
			converter.setDefaultLoadProperty("CharacterSet", Charset.forName("UTF-8").name());

			resultMap.put("openOfficeConnection", openOfficeConnection);
			resultMap.put("converter", converter);
		} catch (ConnectException e) {
			e.printStackTrace();
		}
		return resultMap;
	}

}
