package com.ejianc.foundation.file.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.NetStoreCategoryEntity;
import com.ejianc.foundation.file.mapper.NetStoreCategoryMapper;
import com.ejianc.foundation.file.service.INetStoreCategoryService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

@Service
public class NetStoreCategoryServiceImpl extends BaseServiceImpl<NetStoreCategoryMapper, NetStoreCategoryEntity> implements INetStoreCategoryService {

	@Autowired
	private NetStoreCategoryMapper netStoreCategoryMapper;
	
	@Override
	public List<NetStoreCategoryEntity> queryStoreCategoryList(Long tenantId) {
		QueryWrapper<NetStoreCategoryEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("tenant_id", tenantId);
		List<NetStoreCategoryEntity> categoryEntities = netStoreCategoryMapper.selectList(queryWrapper);
		return categoryEntities;
	}

}
