package com.ejianc.foundation.file.util;

import com.aspose.words.IWarningCallback;
import com.aspose.words.WarningInfo;
import com.aspose.words.WarningType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @author CJ
 * @Description:
 * @date 2023/10/17 9:12
 */
@Component
public class HandleDocumentWarnings implements IWarningCallback {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public ArrayList listOfFonts = new ArrayList();

    @Override
    public void warning(WarningInfo info) {
        if (info.getWarningType() == WarningType.FONT_SUBSTITUTION) {
            if (!listOfFonts.contains(info.getDescription())) {
                listOfFonts.add(info.getDescription());
            }
        }
    }

    public void printMissingFontDetails() {
        for (int i = 0; i < listOfFonts.size(); i++) {
            logger.info("缺失字体 {}: {}", i, listOfFonts.get(i).toString());
        }
    }
}
