package com.ejianc.foundation.file.util;

import org.apache.commons.io.IOUtils;

import java.io.*;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCompress {

    private OutputStream outputStream;

    public ZipCompress(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void compress(Map<String, byte[]> fileBytes) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
        	if (fileBytes != null) {
        		for (Map.Entry<String, byte[]> entry : fileBytes.entrySet()) {
        			byte[] bytes = entry.getValue();
        			String fileName = entry.getKey();
        			
        			zipOutputStream.putNextEntry(new ZipEntry(fileName));
        			
        			byteArrayInputStream = new ByteArrayInputStream(bytes);
        			IOUtils.copy(byteArrayInputStream, zipOutputStream);
        		}
        	}
        }catch(Exception e) {
        	e.printStackTrace();
        }finally {
        	if(zipOutputStream != null) {
        		zipOutputStream.closeEntry();
        		zipOutputStream.close();
        	}
        	if(outputStream != null) {
        		outputStream.close();
        	}
        	if(byteArrayInputStream != null) {
        		byteArrayInputStream.close();
        	}
        }

    }
}
