/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.define;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

public class BASE64MultipartFile
implements MultipartFile {
    private final byte[] imgContent;
    private final String header;
    private final String name;

    public BASE64MultipartFile(String fileStr) throws IOException {
        String[] baseStrs = fileStr.split(",");
        String base64 = baseStrs[1].split("&")[0];
        String name = baseStrs[1].split("&")[1];
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] b = decoder.decodeBuffer(base64);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        this.imgContent = b;
        this.header = baseStrs[0];
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.name;
    }

    public String getContentType() {
        return this.header.split(":")[1];
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() throws IOException {
        return this.imgContent;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        new FileOutputStream(dest).write(this.imgContent);
    }
}

