/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.util;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.StreamOpenOfficeDocumentConverter;
import com.ejianc.foundation.file.config.OfficeServerConfiguration;
import java.net.ConnectException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConverterUtils {
    @Autowired
    private OfficeServerConfiguration officeServerConfiguration;

    public Map<String, Object> getDocumentConverter() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String officeService = this.officeServerConfiguration.getOfficeService();
        System.out.println("================" + officeService);
        SocketOpenOfficeConnection openOfficeConnection = new SocketOpenOfficeConnection(officeService, 8100);
        try {
            openOfficeConnection.connect();
            StreamOpenOfficeDocumentConverter converter = new StreamOpenOfficeDocumentConverter((OpenOfficeConnection)openOfficeConnection);
            converter.setDefaultLoadProperty("Hidden", (Object)true);
            converter.setDefaultLoadProperty("ReadOnly", (Object)true);
            converter.setDefaultLoadProperty("UpdateDocMode", (Object)1);
            converter.setDefaultLoadProperty("CharacterSet", (Object)Charset.forName("UTF-8").name());
            resultMap.put("openOfficeConnection", openOfficeConnection);
            resultMap.put("converter", converter);
        }
        catch (ConnectException e) {
            e.printStackTrace();
        }
        return resultMap;
    }
}

