/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class PicRotateUtils {
    public static BufferedImage Rotate(Image src, int angel) {
        int src_width = src.getWidth(null);
        int src_height = src.getHeight(null);
        Rectangle rect_des = PicRotateUtils.CalcRotatedSize(new Rectangle(new Dimension(src_width, src_height)), angel);
        BufferedImage res = null;
        res = new BufferedImage(rect_des.width, rect_des.height, 2);
        Graphics2D g2 = res.createGraphics();
        g2.translate((rect_des.width - src_width) / 2, (rect_des.height - src_height) / 2);
        g2.rotate(Math.toRadians(angel), src_width / 2, src_height / 2);
        g2.drawImage(src, 0, 0, Color.WHITE, null);
        return res;
    }

    public static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }
}

