/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.define.BaseState;
import com.ejianc.foundation.file.define.MultiState;
import com.ejianc.foundation.file.define.State;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RequestMapping(value={"file"})
@Controller
public class FileBaiduController {
    static Logger logger = LoggerFactory.getLogger(FileBaiduController.class);
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Resource
    private IAttachmentService attachmentService;
    @Value(value="${common.env.base-host}")
    private String fileServer;
    @Value(value="${blackFileExtList}")
    private String blackFileExtList;

    @RequestMapping(value={"/config"})
    @ResponseBody
    public Object config(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="action") String action) throws Exception {
        request.setCharacterEncoding("utf-8");
        response.setHeader("Content-Type", "text/html");
        String callback = request.getParameter("callback");
        if ("config".equals(action)) {
            if (callback != null) {
                return callback + "(" + this.getConfig() + ");";
            }
            return this.getConfig();
        }
        if ("uploadvideo".equals(action)) {
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
                MultipartFile multipartFile = multipartHttpServletRequest.getFile("upfile");
                if (multipartFile == null) {
                    return "\u6587\u4ef6\u4e3a\u7a7a";
                }
                return this.images(multipartFile, request);
            }
            return "\u6587\u4ef6\u4e3a\u7a7a";
        }
        if ("uploadimage".equals(action)) {
            if (request instanceof MultipartHttpServletRequest) {
                MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
                MultipartFile multipartFile = multipartHttpServletRequest.getFile("upfile");
                if (multipartFile == null) {
                    return "\u6587\u4ef6\u4e3a\u7a7a";
                }
                return this.images(multipartFile, request);
            }
            return "\u6587\u4ef6\u4e3a\u7a7a";
        }
        if ("listimage".equals(action)) {
            Integer start = Integer.parseInt(request.getParameter("start"));
            Integer size = Integer.parseInt(request.getParameter("size"));
            if (callback != null) {
                return callback + "(" + this.listimg(start, size) + ");";
            }
            return this.listimg(start, size);
        }
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            MultipartFile multipartFile = multipartHttpServletRequest.getFile("upfile");
            if (multipartFile == null) {
                return "\u6587\u4ef6\u4e3a\u7a7a";
            }
            return this.images(multipartFile, request);
        }
        return "\u6587\u4ef6\u4e3a\u7a7a";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String images(MultipartFile upfile, HttpServletRequest request) {
        BaseState state = null;
        InputStream upfileInputStream = null;
        try {
            if (upfile.getSize() == 0L) {
                logger.error(upfile.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new RuntimeException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            String extName1 = com.ejianc.foundation.file.util.FileUtils.getFileExt(upfile.getOriginalFilename(), false);
            if (this.fileExtInBlackList(extName1)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName1 + "\u683c\u5f0f\u6587\u4ef6");
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName1 + "\u683c\u5f0f\u6587\u4ef6");
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
            String fileName = upfile.getOriginalFilename();
            String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFilename.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
            String objectName = "ejc-platform/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
            upfileInputStream = upfile.getInputStream();
            ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(upfileInputStream, (long)upfileInputStream.available(), -1L).build());
            if (StringUtils.isBlank((String)objectResponse.etag())) {
                throw new BusinessException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25");
            }
            state = new BaseState(true);
            String filePath = this.fileServer + "ejc-file-web/attachment/filePreview?filePath=" + URLEncoder.encode(objectName, "utf-8");
            state.putInfo("url", filePath);
            state.putInfo("size", upfile.getSize());
            state.putInfo("fileName", fileName);
            state.putInfo("type", upfile.getContentType());
        }
        catch (Exception e) {
            state = new BaseState(false);
        }
        finally {
            if (upfileInputStream != null) {
                try {
                    upfileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return state.toJSONString();
    }

    private String getConfig() throws Exception {
        String inputStr;
        ClassPathResource resource = new ClassPathResource("ueditor_config.json");
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), "UTF-8");
        StringBuilder responseStrBuilder = new StringBuilder();
        BufferedReader bfReader = new BufferedReader(reader);
        while ((inputStr = bfReader.readLine()) != null) {
            responseStrBuilder.append(inputStr);
        }
        String config = FileBaiduController.filter(responseStrBuilder.toString());
        config = config.replaceAll("filePathUrl", this.fileServer);
        JSONObject json = JSONObject.parseObject((String)config);
        return json.toString();
    }

    private static String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }

    public String listimg(Integer start, Integer size) {
        State state = null;
        try {
            try {
                QueryParam queryParam = new QueryParam();
                queryParam.getOrderMap().put("createTime", "desc");
                Map params = queryParam.getParams();
                params.put("sourceType", new Parameter("eq", (Object)"baidu"));
                List<AttachmentVO> list = this.attachmentService.queryListByParams(queryParam);
                if (start < 0 || start > list.size()) {
                    state = new MultiState(true);
                } else {
                    Object[] fileList = Arrays.copyOfRange(list.toArray(), (int)start, start + size);
                    state = this.getState(fileList);
                }
                state.putInfo("start", start.intValue());
                state.putInfo("total", list.size());
            }
            catch (Exception ex) {
                logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)ex);
                throw new RuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return state.toJSONString();
    }

    private State getState(Object[] files) {
        MultiState state = new MultiState(true);
        BaseState fileState = null;
        AttachmentVO file = null;
        for (Object obj : files) {
            if (obj == null) break;
            file = (AttachmentVO)obj;
            if (file.getFilePath() == null) continue;
            fileState = new BaseState(true);
            fileState.putInfo("url", file.getFilePath().replace("\\", "/"));
            state.addState(fileState);
        }
        return state;
    }

    @RequestMapping(value={"/getUploadImg/{photoName:.+}"})
    @ResponseBody
    public void getUploadImg(@PathVariable String photoName, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/octet-stream;charset=UTF-8");
        try {
            String picUrl = "";
            FileInputStream in = new FileInputStream(picUrl + photoName);
            int i = in.available();
            byte[] data = new byte[i];
            in.read(data);
            in.close();
            BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)outputStream).write(data);
            ((OutputStream)outputStream).flush();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean fileExtInBlackList(String fileExt) {
        if (StringUtils.isNotEmpty((String)this.blackFileExtList) && fileExt != null) {
            String[] blackFileExtArr;
            for (String blackExt : blackFileExtArr = this.blackFileExtList.split(",")) {
                if (!fileExt.equals(blackExt)) continue;
                return true;
            }
        }
        return false;
    }

    @RequestMapping(value={"onLineImagePreview"}, method={RequestMethod.GET})
    @ResponseBody
    public void onLineImagePreview(@RequestParam(name="filePath", required=false) String filePath, HttpServletResponse response) throws UnsupportedEncodingException {
        try {
            URL urls = new URL(filePath);
            String host = urls.getHost();
            HttpURLConnection conn = (HttpURLConnection)urls.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(50000);
            conn.setReadTimeout(50000);
            InputStream inStream = conn.getInputStream();
            byte[] data = FileBaiduController.readInputStream(inStream);
            response.setContentType("image/jpg");
            ServletOutputStream os = response.getOutputStream();
            os.write(data);
            os.flush();
            os.close();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        int len = 0;
        while ((len = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len);
        }
        inStream.close();
        return outStream.toByteArray();
    }
}

