/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.controller;

import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.service.FilePreviewFactory;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class OnlinePreviewController {
    @Autowired
    FilePreviewFactory previewFactory;
    @Autowired
    private IAttachmentService attachmentService;
    @Autowired
    FileUtils fileUtils;
    @Value(value="${fileUrl}")
    private String fileUrl;

    @RequestMapping(value={"onlinePreview"}, method={RequestMethod.GET})
    public String onlinePreview(String fileId, Model model, HttpServletRequest req) {
        AttachmentVO attachmentVo = this.attachmentService.selectById(fileId);
        if (attachmentVo != null) {
            FilePreview filePreview = this.previewFactory.get(attachmentVo.getFilePath());
            String fileExt = null;
            try {
                fileExt = filePreview.filePreviewHandle(req, attachmentVo, model);
            }
            catch (Exception e) {
                return "fileNotSupported";
            }
            return fileExt;
        }
        return "fileNotSupported";
    }

    @GetMapping(value={"imgsOnlinePreview"})
    public String imgsOnlinePreview(@RequestParam(name="sourceId", required=false) Long sourceId, @RequestParam(name="billType", required=false) String billType, @RequestParam(name="sourceType", required=false) String sourceType, @RequestParam(name="orderType", required=false) String orderType, @RequestParam(name="fileId", required=false) Long fileId, @RequestParam(name="fileIdsStr", required=false) String fileIdsStr, Model model) {
        List<AttachmentVO> list;
        QueryParam queryParam = new QueryParam();
        AttachmentVO curImageFile = null;
        if (StringUtils.isBlank((CharSequence)orderType)) {
            orderType = "desc";
        }
        queryParam.getOrderMap().put("createTime", orderType);
        Map params = queryParam.getParams();
        if (null != sourceId) {
            params.put("sourceId", new Parameter("eq", (Object)sourceId));
        }
        if (StringUtils.isNotBlank((CharSequence)fileIdsStr)) {
            params.put("id", new Parameter("in", Arrays.asList(fileIdsStr.split(","))));
        }
        if (StringUtils.isNotBlank((CharSequence)sourceType)) {
            params.put("sourceType", new Parameter("eq", (Object)sourceType));
        }
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            params.put("billType", new Parameter("eq", (Object)billType));
        }
        if (CollectionUtils.isEmpty(list = this.attachmentService.queryListByParams(queryParam))) {
            model.addAttribute("backMsg", (Object)"\u6ca1\u6709\u53d1\u73b0\u53ef\u9884\u89c8\u7684\u56fe\u7247.");
            return "fileNotSupported";
        }
        ArrayList<String> imgUrls = new ArrayList<String>();
        for (AttachmentVO attach : list) {
            imgUrls.add(this.fileUrl + attach.getFilePath());
            if (null == fileId || fileId.longValue() != attach.getId().longValue()) continue;
            curImageFile = attach;
        }
        if (null == curImageFile) {
            curImageFile = list.get(0);
        }
        model.addAttribute("imgurls", imgUrls);
        String imageFilePath = curImageFile.getFilePath();
        if (StringUtils.isNotBlank((CharSequence)imageFilePath) && imageFilePath.indexOf("http") == -1) {
            imageFilePath = this.fileUrl + imageFilePath;
        }
        model.addAttribute("currentUrl", (Object)imageFilePath);
        return "picture";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/getCorsFile"}, method={RequestMethod.GET})
    public void getCorsFile(String urlPath, String OSSAccessKeyId, String Signature, HttpServletResponse resp) {
        BufferedInputStream inputStream = null;
        OutputStream outputStream = null;
        CloseableHttpResponse httpResponse = null;
        try {
            String strUrl = urlPath = URLDecoder.decode(URLDecoder.decode(urlPath, "utf-8"), "utf-8");
            CloseableHttpClient client = HttpTookit.client;
            URIBuilder urlBuilder = new URIBuilder(strUrl);
            HttpGet httpGet = new HttpGet(urlBuilder.build());
            httpResponse = client.execute((HttpUriRequest)httpGet);
            int status = httpResponse.getStatusLine().getStatusCode();
            if (200 == status) {
                inputStream = new BufferedInputStream(httpResponse.getEntity().getContent());
                outputStream = resp.getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

