/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.controller.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.define.BASE64DecodedMultipartFile;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.util.PicRotateUtils;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.file.vo.WaterMarketConfigVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

@RestController
@RequestMapping
public class AttachmentRefApi {
    private static Logger logger = LoggerFactory.getLogger(AttachmentRefApi.class);
    @Autowired
    private IAttachmentService attachmentService;
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Autowired
    private IEmployeeApi employeeApi;
    @Value(value="${fileUrl}")
    private String fileUrl;

    @PostMapping(value={"/api/attachref/fileToImg"})
    public CommonResponse<List<AttachmentVO>> pdfFileToImg(@RequestBody JSONObject params) {
        ArrayList<Object> resp = new ArrayList<Object>();
        ArrayList sourceIds = new ArrayList();
        ArrayList fileIds = new ArrayList();
        ArrayList sourceTypes = new ArrayList();
        ArrayList billTypes = new ArrayList();
        if (null == params.get((Object)"sourceIds") && null == params.get((Object)"fileIds")) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25, \u53c2\u6570\uff1asourceIds\u3001fileIds\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        QueryParam query = new QueryParam();
        if (null != params.get((Object)"sourceIds")) {
            query.getParams().put("sourceId", Parameter.getInInstance(Arrays.asList(params.getString("sourceIds").split(",")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toList())));
        }
        if (null != params.get((Object)"fileIds")) {
            query.getParams().put("id", Parameter.getInInstance(Arrays.asList(params.getString("fileIds").split(",")).stream().map(item -> Long.valueOf(item)).collect(Collectors.toList())));
        }
        if (null != params.get((Object)"sourceTypes")) {
            query.getParams().put("sourceType", Parameter.getInInstance(Arrays.asList(params.getString("sourceType").split(","))));
        }
        if (null != params.get((Object)"billTypes")) {
            query.getParams().put("billTypes", Parameter.getInInstance(Arrays.asList(params.getString("billTypes").split(","))));
        }
        List attachmentEntities = this.attachmentService.queryList(query);
        List<String> fileType = Arrays.asList("jpg", "bmp", "png", "jpeg");
        if (CollectionUtils.isNotEmpty((Collection)attachmentEntities)) {
            ArrayList imgFile = new ArrayList();
            ArrayList toTransferFileIds = new ArrayList();
            attachmentEntities.stream().forEach(file -> {
                if (fileType.contains(FileUtils.getFileExt((String)file.getFileName(), (Boolean)false))) {
                    imgFile.add(file);
                } else if ("pdf".equals(FileUtils.getFileExt((String)file.getFileName(), (Boolean)false))) {
                    toTransferFileIds.add(file.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(imgFile)) {
                resp.addAll(BeanMapper.mapList(imgFile, AttachmentVO.class));
            }
            if (CollectionUtils.isNotEmpty(toTransferFileIds)) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"source_id", toTransferFileIds);
                queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
                List imgList = this.attachmentService.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)imgList)) {
                    for (AttachmentEntity attach : imgList) {
                        resp.add(BeanMapper.map((Object)((Object)attach), AttachmentVO.class));
                        toTransferFileIds.remove(attach.getSourceId());
                    }
                }
                if (CollectionUtils.isNotEmpty(toTransferFileIds)) {
                    List dbList = (List)this.attachmentService.listByIds(toTransferFileIds);
                    List<AttachmentVO> ismg = this.attachmentService.fileToImg(BeanMapper.mapList((Iterable)dbList, AttachmentVO.class), "JEPG", 300, null);
                    resp.addAll(ismg.stream().filter(item -> null != item).collect(Collectors.toList()));
                }
            }
        }
        return CommonResponse.success((String)"\u6587\u4ef6\u5904\u7406\u6210\u529f\uff01", resp);
    }

    @GetMapping(value={"/api/attachref/queryListBySourceId"})
    public CommonResponse<List<AttachmentVO>> queryListBySourceId(@RequestParam(name="sourceId", required=false) Long sourceId, @RequestParam(name="billType", required=false) String billType, @RequestParam(name="sourceType", required=false) String sourceType, @RequestParam(name="orderType", required=false) String orderType) {
        QueryParam queryParam = new QueryParam();
        if (null == sourceId) {
            return CommonResponse.success((String)"sourceId\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        if (StringUtils.isBlank((CharSequence)orderType)) {
            orderType = "desc";
        }
        queryParam.getOrderMap().put("createTime", orderType);
        queryParam.getOrderMap().put("id", "desc");
        Map params = queryParam.getParams();
        params.put("sourceId", new Parameter("eq", (Object)sourceId));
        if (StringUtils.isNotBlank((CharSequence)sourceType)) {
            params.put("sourceType", new Parameter("eq", (Object)sourceType));
        }
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            params.put("billType", new Parameter("eq", (Object)billType));
        }
        return this.queryList(queryParam);
    }

    @PostMapping(value={"/api/attachref/queryListBySourceIds"})
    public CommonResponse<List<AttachmentVO>> queryAllBySourceIdList(@RequestBody JSONObject paramStr) {
        QueryParam queryParam = new QueryParam();
        List sourceIdList = JSONArray.parseArray((String)paramStr.getString("sourceIds"), Long.class);
        ArrayList sourceTypeList = new ArrayList();
        if (null != paramStr.getString("sourceTypeList")) {
            sourceTypeList.addAll(JSONArray.parseArray((String)paramStr.getString("sourceTypeList"), String.class));
        }
        String orderType = paramStr.getString("orderType");
        if (CollectionUtils.isEmpty((Collection)sourceIdList)) {
            return CommonResponse.success((String)"sourceId\u5217\u8868\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        if (StringUtils.isBlank((CharSequence)orderType)) {
            orderType = "desc";
        }
        queryParam.getOrderMap().put("createTime", orderType);
        Map params = queryParam.getParams();
        params.put("sourceId", new Parameter("in", (Object)sourceIdList));
        if (!sourceTypeList.isEmpty()) {
            params.put("sourceType", new Parameter("in", sourceTypeList));
        }
        return this.queryList(queryParam);
    }

    @PostMapping(value={"/no_auth/api/attachref/uploadFileFormNet"})
    public CommonResponse<String> uploadFileFormNet(@RequestBody UploadFileForNetParam param) {
        List newFileNames;
        logger.info("\u5f02\u6b65\u6587\u4ef6\u4e0b\u8f7d\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        if (param.getTenantId() == null) {
            return CommonResponse.error((String)"\u79df\u6237Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (param.getSourceId() == null) {
            return CommonResponse.error((String)"sourceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List filePathList = param.getFilePathList();
        int idx = 0;
        Long newFileId = null;
        List newFileIds = CollectionUtils.isEmpty((Collection)param.getNewFileIds()) ? new ArrayList() : param.getNewFileIds();
        List list = newFileNames = CollectionUtils.isEmpty((Collection)param.getNewFileNames()) ? new ArrayList() : param.getNewFileNames();
        if (filePathList != null && filePathList.size() > 0) {
            int threadCount = filePathList.size() > 5 ? 5 : filePathList.size();
            ExecutorService threadPool = Executors.newFixedThreadPool(threadCount);
            ArrayList<Future<String>> futureList = new ArrayList<Future<String>>();
            for (String string : filePathList) {
                newFileId = newFileIds.size() > idx ? (Long)newFileIds.get(idx) : Long.valueOf(IdWorker.getId());
                String newFileName = newFileNames.size() > idx ? (String)newFileNames.get(idx++) : null;
                futureList.add(threadPool.submit(new FileFromNetCallable(param, string, newFileId, newFileName)));
            }
            for (Future future : futureList) {
                try {
                    logger.info("----result =====" + (String)future.get());
                }
                catch (Exception exception) {}
            }
            threadPool.shutdown();
        }
        return CommonResponse.success((String)"\u4e0a\u4f20\u6210\u529f");
    }

    private CommonResponse<List<AttachmentVO>> queryList(QueryParam queryParam) {
        List<AttachmentVO> list = this.attachmentService.queryListByParams(queryParam);
        this.setFileTruePath(list);
        return CommonResponse.success(list);
    }

    @PostMapping(value={"/api/attachref/updateAttachArchiveStatus"})
    public CommonResponse<String> updateAttachArchiveStatus(@RequestBody String param) {
        JSONObject jsonParam = JSONObject.parseObject((String)param);
        String status = jsonParam.getString("status");
        List attachIds = JSONArray.parseArray((String)jsonParam.getString("attachIds"), Long.class);
        this.attachmentService.updateAttachArchiveStatus(attachIds, status);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @GetMapping(value={"/api/attachref/detailById"})
    public CommonResponse<AttachmentVO> queryAttachmentDetail(Long fileId) {
        AttachmentEntity attach = (AttachmentEntity)((Object)this.attachmentService.selectById(fileId));
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)attach), AttachmentVO.class));
    }

    @PostMapping(value={"/api/attachref/queryAllByIds"})
    public CommonResponse<List<AttachmentVO>> queryAllByIds(@RequestBody List<Long> fileIds) {
        List<AttachmentVO> attachs = this.attachmentService.queryAllByIds(fileIds);
        return CommonResponse.success(attachs);
    }

    @RequestMapping(value={"/api/attachref/update"}, method={RequestMethod.GET})
    public CommonResponse<String> updateAttachRef(@RequestParam(name="sourceId") Long sourceId, @RequestParam(name="attachIds") List<Long> attachIds) {
        this.attachmentService.updateAttachRef(sourceId, attachIds);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/api/attachref/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> delete(@RequestParam(name="ids") String ids) {
        return this.attachmentService.delete(ids);
    }

    @RequestMapping(value={"/api/attachref/deleteFileByParams"}, method={RequestMethod.GET})
    public CommonResponse<String> deleteFileByParams(@RequestParam(name="sourceId") Long sourceId, @RequestParam(name="billType") String billType, @RequestParam(name="sourceType") String sourceType, @RequestParam(name="fileNames") List<String> fileNames) {
        this.attachmentService.deleteFileByParams(sourceId, billType, sourceType, fileNames);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/api/attachref/deleteFileByParam"}, method={RequestMethod.GET})
    public CommonResponse<String> deleteFileByParam(@RequestParam(name="sourceId") Long sourceId, @RequestParam(name="billType") String billType, @RequestParam(name="sourceType") String sourceType) {
        this.attachmentService.deleteFileByParam(sourceId, billType, sourceType);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/api/attachref/copyFromSourceBillToTargetBill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> copyFromSourceBillToTargetBill(@RequestParam(name="sourceBillId") String sourceBillId, @RequestParam(name="sourceBillType") String sourceBillType, @RequestParam(name="sourceBillSourceType", required=false) String sourceBillSourceType, @RequestParam(name="targetBillId") String targetBillId, @RequestParam(name="targetBillType") String targetBillType, @RequestParam(name="targetBillSourceType", required=false) String targetBillSourceType) {
        try {
            logger.info("\u6839\u636e\u53c2\u6570\u590d\u5236\u6587\u4ef6\uff0c\u53c2\u6570\uff1asourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}", new Object[]{sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType});
            List<AttachmentVO> resp = this.copyFilesNew(sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, false, null);
            return CommonResponse.success((String)"\u6587\u4ef6\u590d\u5236\u6210\u529f\uff01", resp);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u53c2\u6570sourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}\u590d\u5236\u6587\u4ef6\u5f02\u5e38", new Object[]{sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, e});
            return CommonResponse.error((String)"\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/api/attachref/copyFilesFromSourceBillToTargetBill"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> copyFilesFromSourceBillToTargetBill(@RequestParam(name="sourceBillId") String sourceBillId, @RequestParam(name="sourceBillType") String sourceBillType, @RequestParam(name="sourceBillSourceType", required=false) String sourceBillSourceType, @RequestParam(name="targetBillId") String targetBillId, @RequestParam(name="targetBillType") String targetBillType, @RequestParam(name="targetBillSourceType", required=false) String targetBillSourceType) {
        try {
            List<AttachmentVO> resp = this.copyFilesNew(sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, false, null);
            return CommonResponse.success((String)"\u6587\u4ef6\u590d\u5236\u6210\u529f\uff01");
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u53c2\u6570sourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}\u590d\u5236\u6587\u4ef6\u5f02\u5e38", new Object[]{sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, e});
            return CommonResponse.error((String)"\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/api/attachref/copyFiles"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> copyFiles(@RequestParam(name="sourceBillId") String sourceBillId, @RequestParam(name="sourceBillType", required=false) String sourceBillType, @RequestParam(name="sourceBillSourceType", required=false) String sourceBillSourceType, @RequestParam(name="targetBillId") String targetBillId, @RequestParam(name="targetBillType", required=false) String targetBillType, @RequestParam(name="targetBillSourceType", required=false) String targetBillSourceType, @RequestParam(name="clearTargetFile") boolean clearTargetFile) {
        try {
            List<AttachmentVO> resp = this.copyFilesNew(sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, clearTargetFile, null);
            return CommonResponse.success(resp);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u53c2\u6570sourceBillId-{}, sourceBillType-{}, sourceBillSourceType-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}\u590d\u5236\u6587\u4ef6\u5f02\u5e38", new Object[]{sourceBillId, sourceBillType, sourceBillSourceType, targetBillId, targetBillType, targetBillSourceType, e});
            return CommonResponse.error((String)"\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/api/attachref/copyFile"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AttachmentVO> copyFile(@RequestParam(name="sourceFileId") String sourceFileId, @RequestParam(name="targetBillId") String targetBillId, @RequestParam(name="targetBillType") String targetBillType, @RequestParam(name="targetBillSourceType") String targetBillSourceType, @RequestParam(name="clearTargetFile") boolean clearTargetFile) {
        try {
            List<AttachmentVO> resp = this.copyFilesNew(null, null, null, targetBillId, targetBillType, targetBillSourceType, clearTargetFile, sourceFileId);
            return CommonResponse.success((Object)resp.get(0));
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u53c2\u6570sourceFileId-{}, targetBillId-{}, targetBillType-{}, targetBillSourceType-{}\u590d\u5236\u6587\u4ef6\u5f02\u5e38", new Object[]{sourceFileId, targetBillId, targetBillType, targetBillSourceType, e});
            return CommonResponse.error((String)"\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/api/attachref/copyFileBeach"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> copyFileBeach(@RequestBody List<String> sourceFileIds, @RequestParam(name="targetBillId") String targetBillId, @RequestParam(name="targetBillType") String targetBillType, @RequestParam(name="targetBillSourceType") String targetBillSourceType) {
        if (ListUtil.isEmpty(sourceFileIds)) {
            return CommonResponse.error((String)"\u53c2\u6570sourceFileIds\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)targetBillId)) {
            return CommonResponse.error((String)"\u53c2\u6570targetBillId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List resp = new ArrayList();
        try {
            QueryParam queryParam = new QueryParam();
            Map params = queryParam.getParams();
            params.put("id", new Parameter("in", sourceFileIds));
            List<AttachmentVO> list = this.attachmentService.queryListByParams(queryParam);
            if (ListUtil.isEmpty(list)) {
                return CommonResponse.error((String)"\u539f\u59cb\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            }
            ArrayList<AttachmentEntity> entityList = new ArrayList<AttachmentEntity>();
            for (AttachmentVO file : list) {
                file.setId(Long.valueOf(IdWorker.getId()));
                file.setBillType(StringUtils.isNotBlank((CharSequence)targetBillType) ? targetBillType : file.getBillType());
                file.setSourceType(StringUtils.isNotBlank((CharSequence)targetBillSourceType) ? targetBillSourceType : file.getSourceType());
                file.setSourceId(Long.valueOf(Long.parseLong(targetBillId)));
                file.setVersion(Integer.valueOf(0));
                QueryWrapper queryRepeat = new QueryWrapper();
                queryRepeat.eq((Object)"source_id", (Object)targetBillId);
                queryRepeat.eq((Object)"source_type", (Object)file.getSourceType());
                queryRepeat.eq((Object)"bill_type", (Object)file.getBillType());
                queryRepeat.eq((Object)"file_path", (Object)file.getFilePath());
                queryRepeat.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
                List exist = this.attachmentService.list((Wrapper)queryRepeat);
                if (ListUtil.isEmpty((List)exist)) {
                    AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)file, AttachmentEntity.class));
                    entityList.add(entity);
                    continue;
                }
                logger.info("\u76ee\u6807\u5355\u636e\u5df2\u5b58\u5728\u8be5\u6587\u4ef6\uff1aid-{},targetBillType-{}\uff0ctargetBillSourceType-{}\uff0ctargetBillId-{},filePath-{}", new Object[]{((AttachmentEntity)((Object)exist.get(0))).getId(), targetBillType, targetBillSourceType, targetBillId, file.getFilePath()});
            }
            if (ListUtil.isNotEmpty(entityList)) {
                this.attachmentService.saveOrUpdateBatch(entityList);
                resp = BeanMapper.mapList(entityList, AttachmentVO.class);
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u53c2\u6570 \u6279\u91cf\u590d\u5236 targetBillId-{}, targetBillType-{}, targetBillSourceType-{}\u590d\u5236\u6587\u4ef6\u5f02\u5e38", new Object[]{targetBillId, targetBillType, targetBillSourceType, e});
            return CommonResponse.error((String)"\u6587\u4ef6\u590d\u5236\u5931\u8d25\uff01");
        }
        return CommonResponse.success(resp);
    }

    private List<AttachmentVO> copyFilesNew(String sourceBillId, String sourceBillType, String sourceBillSourceType, String targetBillId, String targetBillType, String targetBillSourceType, boolean clearTargetFile, String sourceFileId) {
        List<Object> resp = new ArrayList<AttachmentVO>();
        if (StringUtils.isBlank((CharSequence)sourceBillId) && StringUtils.isBlank((CharSequence)sourceFileId)) {
            throw new BusinessException("\u53c2\u6570sourceBillId\u548csourceFileId\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        Integer newVersion = -1;
        QueryParam queryParam = new QueryParam();
        Map params = queryParam.getParams();
        if (StringUtils.isNotBlank((CharSequence)sourceBillId)) {
            params.put("sourceId", new Parameter("eq", (Object)sourceBillId));
        }
        if (StringUtils.isNotBlank((CharSequence)sourceBillSourceType)) {
            params.put("sourceType", new Parameter("eq", (Object)sourceBillSourceType));
        }
        if (StringUtils.isNotBlank((CharSequence)sourceBillType)) {
            params.put("billType", new Parameter("eq", (Object)sourceBillType));
        }
        if (StringUtils.isNotBlank((CharSequence)sourceFileId)) {
            params.put("id", new Parameter("eq", (Object)sourceFileId));
            List<AttachmentVO> oldFiles = this.attachmentService.findFileList(InvocationInfoProxy.getTenantid(), targetBillId, targetBillSourceType, targetBillType);
            if (CollectionUtils.isNotEmpty(oldFiles)) {
                newVersion = ((AttachmentVO)oldFiles.stream().sorted(Comparator.comparing(BaseVO::getVersion).reversed()).collect(Collectors.toList()).get(0)).getVersion();
            }
        }
        List<AttachmentVO> list = this.attachmentService.queryListByParams(queryParam);
        ArrayList entityList = null;
        if (ListUtil.isNotEmpty(list)) {
            ArrayList finalEntityList = entityList = new ArrayList();
            list.forEach(file -> {
                file.setId(Long.valueOf(IdWorker.getId()));
                file.setBillType(StringUtils.isNotBlank((CharSequence)targetBillType) ? targetBillType : file.getBillType());
                file.setSourceType(StringUtils.isNotBlank((CharSequence)targetBillSourceType) ? targetBillSourceType : file.getSourceType());
                file.setSourceId(Long.valueOf(Long.parseLong(targetBillId)));
                QueryWrapper queryRepeat = new QueryWrapper();
                queryRepeat.eq((Object)"source_id", (Object)targetBillId);
                queryRepeat.eq((Object)"source_type", (Object)(StringUtils.isNotBlank((CharSequence)targetBillSourceType) ? targetBillSourceType : file.getSourceType()));
                queryRepeat.eq((Object)"bill_type", (Object)(StringUtils.isNotBlank((CharSequence)targetBillType) ? targetBillType : file.getBillType()));
                queryRepeat.eq((Object)"file_path", (Object)file.getFilePath());
                queryRepeat.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
                List exist = this.attachmentService.list((Wrapper)queryRepeat);
                if (ListUtil.isEmpty((List)exist) || clearTargetFile) {
                    AttachmentEntity entity = (AttachmentEntity)((Object)((Object)BeanMapper.map((Object)file, AttachmentEntity.class)));
                    finalEntityList.add(entity);
                } else {
                    logger.info("\u76ee\u6807\u5355\u636e\u5df2\u5b58\u5728\u8be5\u6587\u4ef6\uff1aid-{},targetBillType-{}\uff0ctargetBillSourceType-{}\uff0ctargetBillId-{},filePath-{}", new Object[]{((AttachmentEntity)((Object)((Object)exist.get(0)))).getId(), targetBillType, targetBillSourceType, targetBillId, file.getFilePath()});
                }
            });
            if (ListUtil.isNotEmpty(finalEntityList)) {
                AttachmentEntity tmp;
                if (StringUtils.isNotBlank((CharSequence)sourceFileId) && newVersion.compareTo((tmp = (AttachmentEntity)((Object)finalEntityList.get(0))).getVersion()) > 0) {
                    tmp.setVersion(newVersion + 1);
                }
                if (clearTargetFile) {
                    logger.info("\u7269\u7406\u5220\u9664\u6587\u4ef6\u53c2\u6570\uff1asourceId-{},billType-{},sourceType-{}", new Object[]{Long.valueOf(targetBillId), targetBillType, targetBillSourceType});
                    this.attachmentService.deleteFileByParam(Long.valueOf(targetBillId), targetBillType, targetBillSourceType);
                }
                this.attachmentService.saveOrUpdateBatch(finalEntityList);
                resp = BeanMapper.mapList(finalEntityList, AttachmentVO.class);
            }
        }
        return resp;
    }

    @RequestMapping(value={"/api/attachref/uploadForBase64"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> uploadForBase64(@RequestBody AttachmentRequestVO request) {
        String billType = request.getBillType();
        String sourceId = request.getSourceId();
        String sourceType = request.getSourceType();
        if (StringUtils.isBlank((CharSequence)billType)) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u4f20\u5355\u636e\u7c7b\u578b\u7f16\u53f7\uff01");
        }
        ArrayList<Object> fileList = new ArrayList<Object>();
        for (String fileStr : request.getFileList()) {
            MultipartFile mf = this.base64ToMultipart(fileStr);
            String string = mf.getOriginalFilename();
            if (mf.getSize() == 0L) {
                logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            String commonResponse = string.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            commonResponse.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)commonResponse, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                logger.error("\u9650\u5b9a\u5927\u5c0f\u4e3a\uff1a" + sizeLimit + "\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + mf.getSize());
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        InputStream mfInputStream = null;
        try {
            ArrayList<AttachmentEntity> resultEntity = new ArrayList<AttachmentEntity>();
            for (MultipartFile multipartFile : fileList) {
                String bucketName = this.minioConfiguration.getBucketName();
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String fileName = multipartFile.getOriginalFilename();
                String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFilename.replaceAll("00.", "");
                String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
                String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                mfInputStream = multipartFile.getInputStream();
                ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(mfInputStream, (long)mfInputStream.available(), -1L).build());
                if (!StringUtils.isNotBlank((CharSequence)objectResponse.etag())) continue;
                AttachmentVO attachment = new AttachmentVO();
                attachment.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                }
                attachment.setSourceType(sourceType);
                attachment.setFileName(fileName);
                attachment.setFilePath(objectName);
                attachment.setFileSize(Long.valueOf(multipartFile.getSize()));
                Long userId = InvocationInfoProxy.getUserid();
                CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
                if (employeeResponse.isSuccess()) {
                    attachment.setUploadUserName(((EmployeeVO)employeeResponse.getData()).getName());
                }
                AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                entity.setOnlinePath(this.fileUrl + objectName);
                resultEntity.add(entity);
            }
            if (CollectionUtils.isNotEmpty(resultEntity)) {
                this.attachmentService.saveOrUpdateFileList(resultEntity, request.getClearBeforeSave());
            }
            List resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
            this.setFileTruePath(resultList);
            CommonResponse commonResponse = CommonResponse.success((Object)resultList);
            return commonResponse;
        }
        catch (Exception ex) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)ex);
            throw new BusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0cMsg\uff1a" + ex.getMessage());
        }
        finally {
            if (mfInputStream != null) {
                try {
                    mfInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/api/attachref/uploadSignatureForBase64"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttachmentVO>> uploadSignatureForBase64(@RequestBody AttachmentRequestVO request) {
        String billType = request.getBillType();
        String sourceId = request.getSourceId();
        String sourceType = request.getSourceType();
        Integer rotate = request.getRotate();
        if (StringUtils.isBlank((CharSequence)billType)) {
            return CommonResponse.error((String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53ef\u4ee5\u4f20\u5355\u636e\u7c7b\u578b\u7f16\u53f7\uff01");
        }
        ArrayList<Object> fileList = new ArrayList<Object>();
        for (String fileStr : request.getFileList()) {
            MultipartFile mf = this.base64ToMultipart(fileStr);
            String string = mf.getOriginalFilename();
            if (mf.getSize() == 0L) {
                logger.error(mf.getOriginalFilename() + "\u5927\u5c0f\u4e0d\u80fd\u4e3a0");
                throw new BusinessException("\u4e0a\u4f20\u4e86\u7a7a\u6587\u4ef6");
            }
            String commonResponse = string.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            commonResponse.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)commonResponse, (Boolean)false);
            if (this.fileExtInBlackList(extName)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + extName + "\u683c\u5f0f\u6587\u4ef6");
            }
            Integer sizeLimit = this.minioConfiguration.getSizeLimit();
            if (mf.getSize() > (long)sizeLimit.intValue()) {
                logger.error("\u9650\u5b9a\u5927\u5c0f\u4e3a\uff1a" + sizeLimit + "\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a\uff1a" + mf.getSize());
                throw new BusinessException("\u4e0a\u4f20\u4e86\u5927\u4e8e\u9650\u5b9a\u5927\u5c0f\u7684\u6587\u4ef6");
            }
            fileList.add(mf);
        }
        InputStream inputStream = null;
        try {
            ArrayList<AttachmentEntity> resultEntity = new ArrayList<AttachmentEntity>();
            for (MultipartFile multipartFile : fileList) {
                ObjectWriteResponse objectResponse;
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String fileName = multipartFile.getOriginalFilename();
                String originalFilename = fileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
                originalFilename.replaceAll("00.", "");
                String extName = FileUtils.getFileExt((String)originalFilename, (Boolean)false);
                String objectName = InvocationInfoProxy.getTenantid() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                if (rotate != null && rotate > 0) {
                    BufferedImage src = ImageIO.read(multipartFile.getInputStream());
                    BufferedImage des = PicRotateUtils.Rotate(src, rotate);
                    ByteArrayOutputStream bs = new ByteArrayOutputStream();
                    ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
                    ImageIO.write((RenderedImage)des, "png", imOut);
                    inputStream = new ByteArrayInputStream(bs.toByteArray());
                } else {
                    inputStream = multipartFile.getInputStream();
                }
                if (!StringUtils.isNotBlank((CharSequence)(objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(inputStream, (long)inputStream.available(), -1L).build())).etag())) continue;
                AttachmentVO attachment = new AttachmentVO();
                attachment.setBillType(billType);
                if (StringUtils.isNotBlank((CharSequence)sourceId)) {
                    attachment.setSourceId(Long.valueOf(Long.parseLong(sourceId)));
                }
                attachment.setSourceType(sourceType);
                attachment.setFileName(fileName);
                attachment.setFilePath(objectName);
                attachment.setFileSize(Long.valueOf(multipartFile.getSize()));
                Long userId = InvocationInfoProxy.getUserid();
                CommonResponse employeeResponse = this.employeeApi.queryEmployeByUserId(userId);
                if (employeeResponse.isSuccess()) {
                    attachment.setUploadUserName(((EmployeeVO)employeeResponse.getData()).getName());
                }
                AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                this.attachmentService.saveOrUpdate((Object)entity, false);
                entity.setOnlinePath(this.fileUrl + objectName);
                resultEntity.add(entity);
            }
            List resultList = BeanMapper.mapList(resultEntity, AttachmentVO.class);
            this.setFileTruePath(resultList);
            CommonResponse commonResponse = CommonResponse.success((Object)resultList);
            return commonResponse;
        }
        catch (Exception ex) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)ex);
            throw new BusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0cMsg\uff1a" + ex.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private MultipartFile base64ToMultipart(String base64) {
        try {
            String[] baseStrs = base64.split(",");
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] b = new byte[]{};
            b = baseStrs.length > 1 ? decoder.decodeBuffer(baseStrs[1]) : decoder.decodeBuffer(baseStrs[0]);
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 0) continue;
                int n = i;
                b[n] = (byte)(b[n] + 256);
            }
            if (baseStrs.length > 1) {
                return new BASE64DecodedMultipartFile(b, baseStrs[0]);
            }
            return new BASE64DecodedMultipartFile(b, "data:image/png;base64");
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private boolean fileExtInBlackList(String fileExt) {
        String blackFileExt = this.minioConfiguration.getBlackFileExt();
        if (StringUtils.isNotEmpty((CharSequence)blackFileExt) && fileExt != null) {
            String[] blackFileExtArr;
            for (String blackExt : blackFileExtArr = blackFileExt.split(",")) {
                if (!fileExt.equals(blackExt)) continue;
                return true;
            }
        }
        return false;
    }

    public void setFileTruePath(List<AttachmentVO> list) {
        if (!ListUtil.isEmpty(list)) {
            list.forEach(f -> {
                f.setTruePath(this.fileUrl + f.getFilePath());
                if (StringUtils.isNotBlank((CharSequence)f.getFileFormatPathStr())) {
                    f.setFileFormatPath((List)JSONArray.parse((String)f.getFileFormatPathStr()));
                }
                f.setImgServerPath(this.fileUrl);
            });
        }
    }

    @GetMapping(value={"/no_auth/api/attachref/queryListBySourceId"})
    public CommonResponse<List<AttachmentVO>> queryNoAuthListBySourceId(@RequestParam(name="sourceId", required=false) Long sourceId, @RequestParam(name="billType", required=false) String billType, @RequestParam(name="sourceType", required=false) String sourceType, @RequestParam(name="orderType", required=false) String orderType) {
        QueryParam queryParam = new QueryParam();
        if (null == sourceId) {
            return CommonResponse.success((String)"sourceId\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e0d\u5230\u5339\u914d\u7684\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        if (StringUtils.isBlank((CharSequence)orderType)) {
            orderType = "desc";
        }
        queryParam.getOrderMap().put("createTime", orderType);
        queryParam.getOrderMap().put("id", "desc");
        Map params = queryParam.getParams();
        params.put("sourceId", new Parameter("eq", (Object)sourceId));
        if (StringUtils.isNotBlank((CharSequence)sourceType)) {
            params.put("sourceType", new Parameter("eq", (Object)sourceType));
        }
        if (StringUtils.isNotBlank((CharSequence)billType)) {
            params.put("billType", new Parameter("eq", (Object)billType));
        }
        return this.queryList(queryParam);
    }

    @RequestMapping(value={"/api/attachref/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<AttachmentVO> queryDetail(@RequestParam(name="id") String id) {
        AttachmentVO attachmentVO = this.attachmentService.selectById(id);
        if (attachmentVO == null) {
            return CommonResponse.success(null);
        }
        attachmentVO.setTruePath(this.fileUrl + attachmentVO.getFilePath());
        if (StringUtils.isNotBlank((CharSequence)attachmentVO.getFileFormatPathStr())) {
            attachmentVO.setFileFormatPath((List)JSONArray.parse((String)attachmentVO.getFileFormatPathStr()));
        }
        attachmentVO.setImgServerPath(this.fileUrl);
        return CommonResponse.success((Object)attachmentVO);
    }

    @RequestMapping(value={"/api/attachref/insertBatch"}, method={RequestMethod.POST})
    public CommonResponse<String> insertBatch(@RequestBody List<AttachmentVO> AttachmentVOs) {
        if (AttachmentVOs == null || AttachmentVOs.size() <= 0) {
            return CommonResponse.error((String)"\u7f3a\u5c11\u9644\u4ef6\u4fe1\u606f");
        }
        this.attachmentService.saveOrUpdateBatch(BeanMapper.mapList(AttachmentVOs, AttachmentEntity.class), AttachmentVOs.size(), false);
        return CommonResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    @GetMapping(value={"/api/attachref/downloadFileById"})
    public void downloadFileById(@RequestParam(value="fileId") Long fileId, HttpServletResponse response) {
        AttachmentEntity attachment = (AttachmentEntity)((Object)this.attachmentService.selectById(fileId));
        if (attachment != null) {
            String bucketName = this.minioConfiguration.getBucketName();
            BufferedOutputStream out = null;
            GetObjectResponse getObjectResponse = null;
            try {
                response.setContentType("application/octet-stream");
                response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(attachment.getFileName(), "UTF-8"));
                getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(attachment.getFilePath())).build());
                out = new BufferedOutputStream((OutputStream)response.getOutputStream());
                IOUtils.copy((InputStream)getObjectResponse, (OutputStream)out);
            }
            catch (Exception e) {
                logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25", (Throwable)e);
                throw new BusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0cMsg\uff1a" + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (getObjectResponse != null) {
                    try {
                        getObjectResponse.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        throw new BusinessException("\u53c2\u6570fileId\u4e0d\u5408\u6cd5\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u9644\u4ef6\u4fe1\u606f");
    }

    @RequestMapping(value={"/api/attachref/makeWatermarkToFile"}, method={RequestMethod.GET})
    public CommonResponse<String> makeWatermarkToFile(@RequestParam(value="fileId") Long fileId, @RequestParam(value="watermarkText") String watermarkText, @RequestParam(value="waterWay") String waterWay) {
        String onlineFilePath = this.attachmentService.makeWatermarkToFile(fileId, watermarkText, waterWay);
        return CommonResponse.success((String)onlineFilePath);
    }

    @RequestMapping(value={"/api/attachref/updateFileInfo"}, method={RequestMethod.POST})
    public CommonResponse<String> updateFileInfo(@RequestBody AttachmentVO vo) {
        AttachmentEntity entity = (AttachmentEntity)((Object)this.attachmentService.selectById(vo.getId()));
        if (entity == null) {
            return CommonResponse.error((String)"\u6307\u5b9a\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        entity = (AttachmentEntity)((Object)BeanMapper.map((Object)vo, AttachmentEntity.class));
        this.attachmentService.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"/api/attachref/addMakeWatermark"})
    public CommonResponse<AttachmentVO> addMakeWatermark(@RequestBody WaterMarketConfigVO waterMarketConfig) {
        logger.info("\u6dfb\u52a0\u6c34\u5370\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)waterMarketConfig));
        AttachmentVO resp = this.attachmentService.addWaterMarket(waterMarketConfig);
        if (resp != null) {
            return CommonResponse.success((Object)resp);
        }
        return CommonResponse.error((String)"\u751f\u6210\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/api/attachref/queryNumberBySourceId"})
    public CommonResponse<Map<Long, Integer>> queryNumberBySourceId(@RequestParam(name="sourceIds", required=false) List<Long> sourceIds, @RequestParam(name="billType", required=false) String billType, @RequestParam(name="sourceType", required=false) String sourceType) {
        HashMap<Long, Integer> countNum = new HashMap<Long, Integer>();
        for (Long sourceId : sourceIds) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"source_id", (Object)sourceId);
            if (StringUtils.isNotBlank((CharSequence)sourceType)) {
                queryWrapper.eq((Object)"source_type", (Object)sourceType);
            }
            if (StringUtils.isNotBlank((CharSequence)billType)) {
                queryWrapper.eq((Object)"bill_type", (Object)billType);
            }
            queryWrapper.eq((Object)"source_id", (Object)sourceId);
            Integer num = this.attachmentService.count((Wrapper)queryWrapper);
            countNum.put(sourceId, num);
        }
        return CommonResponse.success(countNum);
    }

    @GetMapping(value={"/api/attachref/queryPageNumber"})
    public CommonResponse<Integer> queryPageNumber(@RequestParam(name="fileId", required=false) Long fileId) {
        Integer pages = this.attachmentService.queryPageNumber(fileId);
        return CommonResponse.success((Object)pages);
    }

    class FileFromNetCallable
    implements Callable<String> {
        private UploadFileForNetParam param;
        private String filePath;
        private Long fileId;
        private String newFileName;

        public FileFromNetCallable(UploadFileForNetParam param, String filePath) {
            this.param = param;
            this.filePath = filePath;
        }

        public FileFromNetCallable(UploadFileForNetParam param, String filePath, Long newFileId) {
            this.param = param;
            this.filePath = filePath;
            this.fileId = newFileId;
        }

        public FileFromNetCallable(UploadFileForNetParam param, String filePath, Long fileId, String newFileName) {
            this.param = param;
            this.filePath = filePath;
            this.fileId = fileId;
            this.newFileName = newFileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() throws Exception {
            String fileName = this.filePath.split("\\?")[0];
            String fileExt = FileUtils.getFileExt((String)fileName, (Boolean)false);
            if (AttachmentRefApi.this.fileExtInBlackList(fileExt)) {
                logger.error("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + fileExt + "\u683c\u5f0f\u6587\u4ef6");
                throw new BusinessException("\u4e0d\u5141\u8bb8\u4e0a\u4f20" + fileExt + "\u683c\u5f0f\u6587\u4ef6");
            }
            try (ByteArrayInputStream bis = null;){
                byte[] fileBytes = HttpTookit.downloadFromNet((String)this.filePath);
                if (null == fileBytes) {
                    throw new BusinessException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u4e0b\u8f7d\u5730\u5740\uff1a" + this.filePath);
                }
                bis = new ByteArrayInputStream(fileBytes);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String yearMonth = format.format(new Date());
                String objectFileName = yearMonth + "-" + IdWorker.getId() + (StringUtils.isNotBlank((CharSequence)fileExt) ? "." + fileExt : ".png");
                String objectName = this.param.getTenantId() + "/" + yearMonth + "/" + objectFileName;
                ObjectWriteResponse objectResponse = AttachmentRefApi.this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(AttachmentRefApi.this.minioConfiguration.getBucketName())).object(objectName)).stream((InputStream)bis, (long)bis.available(), -1L).build());
                if (StringUtils.isNotBlank((CharSequence)objectResponse.etag())) {
                    AttachmentVO attachment = new AttachmentVO();
                    attachment.setBillType(this.param.getBillType());
                    attachment.setSourceId(this.param.getSourceId());
                    attachment.setSourceType(this.param.getSourceType());
                    attachment.setFileName(StringUtils.isNotBlank((CharSequence)this.newFileName) ? this.newFileName : objectFileName);
                    attachment.setFilePath(objectName);
                    attachment.setFileSize(Long.valueOf(fileBytes.length));
                    if (null != this.fileId) {
                        attachment.setId(this.fileId);
                    }
                    attachment.setTenantId(this.param.getTenantId());
                    AttachmentEntity entity = (AttachmentEntity)((Object)BeanMapper.map((Object)attachment, AttachmentEntity.class));
                    AttachmentRefApi.this.attachmentService.saveOrUpdate((Object)entity, false);
                }
            }
            return "success";
        }
    }
}

