/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.FontSettings;
import com.aspose.words.HeaderFooter;
import com.aspose.words.IWarningCallback;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Paragraph;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.bean.AttachmentEntity;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.enums.WaterWayEnum;
import com.ejianc.foundation.file.mapper.AttachmentMapper;
import com.ejianc.foundation.file.service.IAttachmentService;
import com.ejianc.foundation.file.util.HandleDocumentWarnings;
import com.ejianc.foundation.file.util.PdfProcessor;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.file.vo.WaterMarketConfigVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.ImgUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AttachmentServiceImpl
extends BaseServiceImpl<AttachmentMapper, AttachmentEntity>
implements IAttachmentService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AttachmentMapper attachmentMapper;
    @Autowired
    com.ejianc.foundation.file.util.FileUtils fileUtils;
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Autowired
    private EnvironmentTools environmentTools;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${fileUrl}")
    private String fileUrl;
    @Autowired
    private PdfProcessor pdfProcessor;

    @Override
    public void updateAttachRef(Long sourceId, List<Long> attachIds) {
        for (Long attachId : attachIds) {
            this.attachmentMapper.updateAttachRef(sourceId, attachId);
        }
    }

    @Override
    public AttachmentVO selectById(String fileId) {
        AttachmentEntity entity = (AttachmentEntity)((Object)super.getById((Serializable)((Object)fileId)));
        if (entity != null) {
            return (AttachmentVO)BeanMapper.map((Object)((Object)entity), AttachmentVO.class);
        }
        return null;
    }

    @Override
    public InputStream getThumbnailPath(AttachmentEntity entity) {
        String thumbnailPath = entity.getFilePath();
        Object is = null;
        if (StringUtils.isNotEmpty((CharSequence)thumbnailPath) && thumbnailPath.contains(".") && this.isImage(thumbnailPath.split("\\.")[1]) && entity.getFileSize() > 512000) {
            thumbnailPath = thumbnailPath.split("\\.")[0] + "/thumbnail.jpg";
            try {
                is = this.fileUtils.downloadFileByKeyName(thumbnailPath);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.info(e.getMessage());
            }
            if (is == null) {
                byte[] imgBytes = ImgUtils.compressPic(null, (InputStream)this.fileUtils.downloadFileByKeyName(entity.getFilePath()), (Integer)250, (Integer)250, (Integer)1);
                try {
                    is = new ByteArrayInputStream(imgBytes);
                    this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(thumbnailPath)).stream((InputStream)is, (long)((InputStream)is).available(), -1L).build());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error("\u4fdd\u5b58\u7f29\u7565\u56fe\u7247\u5931\u8d25\uff01", (Throwable)e);
                }
            }
        }
        return is;
    }

    private boolean isImage(String ex) {
        boolean res = false;
        switch (ex.toLowerCase()) {
            case "jpg": 
            case "jpeg": 
            case "png": 
            case "bpm": 
            case "gif": {
                res = true;
                break;
            }
        }
        return res;
    }

    @Override
    public List<AttachmentVO> queryListByIds(String fileIds) {
        String[] fileIdArr;
        ArrayList<AttachmentVO> attachmentVos = new ArrayList<AttachmentVO>();
        for (String fileId : fileIdArr = fileIds.split(",")) {
            AttachmentEntity entity = (AttachmentEntity)((Object)super.getById((Serializable)((Object)fileId)));
            if (entity == null) continue;
            attachmentVos.add((AttachmentVO)BeanMapper.map((Object)((Object)entity), AttachmentVO.class));
        }
        return attachmentVos;
    }

    @Override
    @Transactional
    public CommonResponse<String> delete(String ids) {
        try {
            QueryWrapper query = new QueryWrapper();
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            query.in((Object)"source_id", new Object[]{ids});
            List list = ((AttachmentMapper)this.baseMapper).selectList((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                this.attachmentMapper.deleteIds(list.stream().map(item -> item.getId().toString()).collect(Collectors.joining(",")));
            }
            this.attachmentMapper.deleteIds(ids);
            List idList = Arrays.asList(ids.split(",")).stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
            query = new QueryWrapper();
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            query.in((Object)"id", idList);
            query.eq((Object)"archive_status", (Object)AttachmentVO.ARCHIVED);
            list = ((AttachmentMapper)this.baseMapper).selectList((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                String url = this.environmentTools.getBaseHost() + "ejc-doc-web/api/projectDoc/delByFileIds";
                List fileIds = list.stream().map(file -> file.getId()).collect(Collectors.toList());
                String resp = HttpTookit.postByJson((String)url, (String)JSONObject.toJSONString(fileIds));
                this.logger.info("\u6839\u636e\u9644\u4ef6Id\u5217\u8868-{},\u5220\u9664\u5176\u5bf9\u5e94\u5f52\u6863\u4fe1\u606f\u8bf7\u6c42\u7ed3\u679c\uff1a{},", (Object)JSONObject.toJSONString(fileIds), (Object)resp);
                CommonResponse result = (CommonResponse)JSONObject.parseObject((String)resp, CommonResponse.class);
                if (!result.isSuccess()) {
                    this.logger.error("\u6839\u636e\u9644\u4ef6Id\u5217\u8868-{},\u5220\u9664\u5176\u5bf9\u5e94\u5f52\u6863\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString(fileIds), (Object)result.getMsg());
                    throw new BusinessException("\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u9644\u4ef6\u5f52\u6863\u4fe1\u606f\u5931\u8d25!");
                }
            }
            return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("----------\u5220\u9664\u6587\u4ef6\u5931\u8d25--------", (Throwable)e);
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public List<AttachmentVO> queryListByParams(QueryParam queryParam) {
        List list = this.queryList(queryParam, false);
        return BeanMapper.mapList((Iterable)list, AttachmentVO.class);
    }

    @Override
    public void updateAttachArchiveStatus(List<Long> attachIds, String status) {
        this.attachmentMapper.updateAttachArchiveStatus(attachIds, status);
    }

    @Override
    public List<AttachmentVO> findFileList(Long tenantId, String sourceId, String sourceType, String billType) {
        List list;
        List<Object> resp = new ArrayList<AttachmentVO>();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"tenant_id", (Object)tenantId);
        query.eq((Object)"source_id", (Object)sourceId);
        query.eq((Object)"bill_type", (Object)billType);
        if (StringUtils.isNotBlank((CharSequence)sourceType)) {
            query.eq((Object)"source_type", (Object)sourceType);
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)query)))) {
            resp = BeanMapper.mapList((Iterable)list, AttachmentVO.class);
        }
        return resp;
    }

    @Override
    public void deleteFileByParams(Long sourceId, String billType, String sourceType, List<String> fileNames) {
        if (fileNames != null && fileNames.size() > 0) {
            for (String fileName : fileNames) {
                this.attachmentMapper.deleteFileByParams(sourceId, billType, sourceType, fileName);
            }
        }
    }

    @Override
    public void deleteFileByParam(Long sourceId, String billType, String sourceType) {
        this.attachmentMapper.deleteFileByParam(sourceId, billType, sourceType);
    }

    @Override
    public void saveOrUpdateFileList(List<AttachmentEntity> resultEntity, Boolean clearBeforeSave) {
        if (null != clearBeforeSave && clearBeforeSave.booleanValue()) {
            AttachmentEntity tmp = resultEntity.get(0);
            this.attachmentMapper.deleteFileByParam(tmp.getSourceId(), tmp.getBillType(), tmp.getSourceType());
            List fileIds = resultEntity.stream().map(BaseEntity::getId).collect(Collectors.toList());
            QueryWrapper query = new QueryWrapper();
            query.in((Object)"source_id", fileIds);
            query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
            List relatedFiles = super.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)relatedFiles)) {
                this.attachmentMapper.deleteIds(relatedFiles.stream().map(item -> item.getId().toString()).collect(Collectors.joining(",")));
            }
        }
        super.saveOrUpdateBatch(resultEntity, resultEntity.size(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeWatermarkToFile(Long fileId, String watermarkText, String waterWay) {
        GetObjectResponse in = null;
        OutputStream bos = null;
        ByteArrayInputStream bis = null;
        InputStream fileInputStream = null;
        AttachmentEntity entity = (AttachmentEntity)((Object)this.attachmentMapper.selectById(fileId));
        String suffix = entity.getFileName().substring(entity.getFileName().lastIndexOf(".") + 1);
        if ("docx".equals(suffix) || "doc".equals(suffix)) {
            try {
                in = this.fileUtils.downloadFileByKeyName(entity.getFilePath());
                bos = new ByteArrayOutputStream();
                BufferedInputStream bufferedInputStream = null;
                try {
                    FontSettings fontSetting = FontSettings.getDefaultInstance();
                    fontSetting.setFontsFolder("/usr/share/fonts/", false);
                    bufferedInputStream = new BufferedInputStream((InputStream)in);
                    Document document = new Document((InputStream)bufferedInputStream);
                    document.setFontSettings(fontSetting);
                    if (StringUtils.isNotBlank((CharSequence)watermarkText)) {
                        if ("single".equals(waterWay)) {
                            this.insertWatermarkText(document, watermarkText);
                        } else if ("more".equals(waterWay)) {
                            this.insertWaterMarks(document, watermarkText);
                        }
                    }
                    HandleDocumentWarnings warningsHandler = new HandleDocumentWarnings();
                    document.setWarningCallback((IWarningCallback)warningsHandler);
                    document.save(bos, 40);
                    warningsHandler.printMissingFontDetails();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException ignored) {
                            System.out.println("\u5173\u95ed\u6d41\u5f02\u5e38" + ignored);
                        }
                    }
                }
                bis = new ByteArrayInputStream(((ByteArrayOutputStream)bos).toByteArray());
                String pdfName = entity.getFileName().substring(0, entity.getFileName().lastIndexOf(".") + 1) + "pdf";
                MockMultipartFile multipartFile = new MockMultipartFile(pdfName, (InputStream)bis);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String objectName = entity.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + ".pdf";
                fileInputStream = multipartFile.getInputStream();
                this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(fileInputStream, (long)fileInputStream.available(), -1L).build());
                entity.setOnlinePath(objectName);
                this.attachmentMapper.insert((Object)entity);
                String string = this.fileUrl + objectName;
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("word\u8f6cpdf\u4fdd\u9519-------{}", (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (bos != null) {
                        bos.flush();
                        ((ByteArrayOutputStream)bos).close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u6587\u4ef6\u52a0\u6c34\u5370\u8d44\u6e90\u91ca\u653e\u5931\u8d25", (Throwable)e);
                }
            }
        }
        throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662fword");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachmentVO addWaterMarket(WaterMarketConfigVO waterMarketConfigVO) {
        GetObjectResponse in = null;
        OutputStream bos = null;
        ByteArrayInputStream bis = null;
        InputStream fileInputStream = null;
        AttachmentEntity entity = (AttachmentEntity)((Object)this.attachmentMapper.selectById(waterMarketConfigVO.getSourceFileId()));
        String suffix = entity.getFileName().substring(entity.getFileName().lastIndexOf(".") + 1);
        if ("docx".equals(suffix) || "doc".equals(suffix)) {
            try {
                in = this.fileUtils.downloadFileByKeyName(entity.getFilePath());
                bos = new ByteArrayOutputStream();
                BufferedInputStream bufferedInputStream = null;
                try {
                    FontSettings fontSetting = FontSettings.getDefaultInstance();
                    fontSetting.setFontsFolder("/usr/share/fonts/", false);
                    bufferedInputStream = new BufferedInputStream((InputStream)in);
                    Document document = new Document((InputStream)bufferedInputStream);
                    document.setFontSettings(fontSetting);
                    if (StringUtils.isNotBlank((CharSequence)waterMarketConfigVO.getTextContent())) {
                        if (WaterWayEnum.\u5355\u4e00\u6c34\u5370.getWaterWayCode().equals(waterMarketConfigVO.getWaterWay())) {
                            this.insertWatermarkText(document, waterMarketConfigVO);
                        } else if (WaterWayEnum.\u91cd\u590d\u6c34\u5370.getWaterWayCode().equals(waterMarketConfigVO.getWaterWay())) {
                            this.insertWaterMarks(document, waterMarketConfigVO);
                        }
                    }
                    HandleDocumentWarnings warningsHandler = new HandleDocumentWarnings();
                    document.setWarningCallback((IWarningCallback)warningsHandler);
                    document.save(bos, 40);
                    warningsHandler.printMissingFontDetails();
                }
                catch (Exception e) {
                    this.logger.error("\u6dfb\u52a0\u6c34\u5370\u5931\u8d25\uff1a", (Throwable)e);
                }
                finally {
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (IOException ignored) {
                            System.out.println("\u5173\u95ed\u6d41\u5f02\u5e38" + ignored);
                        }
                    }
                }
                bis = new ByteArrayInputStream(((ByteArrayOutputStream)bos).toByteArray());
                String pdfName = entity.getFileName().substring(0, entity.getFileName().lastIndexOf(".") + 1) + "pdf";
                MockMultipartFile multipartFile = new MockMultipartFile(pdfName, (InputStream)bis);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                String objectName = entity.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + ".pdf";
                fileInputStream = multipartFile.getInputStream();
                this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(fileInputStream, (long)fileInputStream.available(), -1L).build());
                AttachmentEntity pdfEntity = new AttachmentEntity();
                pdfEntity.setOnlinePath(this.fileUrl + objectName);
                pdfEntity.setSourceId(null != waterMarketConfigVO.getBillId() ? waterMarketConfigVO.getBillId() : entity.getSourceId());
                pdfEntity.setSourceType(StringUtils.isNotBlank((CharSequence)waterMarketConfigVO.getSourceType()) ? waterMarketConfigVO.getSourceType() : entity.getSourceType() + "Pdf");
                pdfEntity.setBillType(StringUtils.isNotBlank((CharSequence)waterMarketConfigVO.getBillType()) ? waterMarketConfigVO.getBillType() : entity.getBillType());
                pdfEntity.setFilePath(objectName);
                pdfEntity.setFileSize(Integer.valueOf(multipartFile.getSize() + ""));
                pdfEntity.setFileName(pdfName);
                super.saveOrUpdate((Object)pdfEntity, false);
                AttachmentVO attachmentVO = (AttachmentVO)BeanMapper.map((Object)((Object)pdfEntity), AttachmentVO.class);
                return attachmentVO;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("word\u8f6cpdf\u4fdd\u9519-------{}", (Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (bos != null) {
                        bos.flush();
                        ((ByteArrayOutputStream)bos).close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u6587\u4ef6\u52a0\u6c34\u5370\u8d44\u6e90\u91ca\u653e\u5931\u8d25", (Throwable)e);
                }
            }
        }
        throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u662fword");
        return null;
    }

    @Override
    public List<AttachmentVO> queryAllByIds(List<Long> fileIds) {
        List<Object> resp = new ArrayList<AttachmentVO>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", fileIds);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = BeanMapper.mapList((Iterable)dbList, AttachmentVO.class);
        }
        return resp;
    }

    private void insertWatermarkText(Document doc, String watermarkText) throws Exception {
        WaterMarketConfigVO waterMarketConfig = new WaterMarketConfigVO();
        waterMarketConfig.setTextContent(watermarkText);
        this.insertWatermarkText(doc, waterMarketConfig);
    }

    private void insertWatermarkText(Document doc, WaterMarketConfigVO waterMarketConfig) throws Exception {
        System.out.println("\u5f00\u59cb\u6dfb\u52a0\u6c34\u5370...");
        Shape watermark = new Shape((DocumentBase)doc, 136);
        watermark.getTextPath().setText(waterMarketConfig.getTextContent());
        watermark.getTextPath().setFontFamily(StringUtils.isNotBlank((CharSequence)waterMarketConfig.getFontFamily()) ? waterMarketConfig.getFontFamily() : "\u5b8b\u4f53");
        watermark.setWidth(500.0);
        watermark.setHeight(100.0);
        watermark.setRotation(null != waterMarketConfig.getRotation() ? waterMarketConfig.getRotation() : -40.0);
        watermark.getFill().setColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);
        watermark.setStrokeColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);
        watermark.setRelativeHorizontalPosition(1);
        watermark.setRelativeVerticalPosition(1);
        watermark.setWrapType(3);
        watermark.setVerticalAlignment(2);
        watermark.setHorizontalAlignment(2);
        Paragraph watermarkPara = new Paragraph((DocumentBase)doc);
        watermarkPara.appendChild((Node)watermark);
        for (Section sect : doc.getSections()) {
            this.insertWatermarkIntoHeader(watermarkPara, sect, 1);
            this.insertWatermarkIntoHeader(watermarkPara, sect, 4);
            this.insertWatermarkIntoHeader(watermarkPara, sect, 0);
        }
        System.out.println("\u7ed3\u675f\u6dfb\u52a0\u6c34\u5370...");
    }

    private void insertWatermarkIntoHeader(Paragraph watermarkPara, Section sect, int headerType) throws Exception {
        HeaderFooter header = sect.getHeadersFooters().getByHeaderFooterType(headerType);
        if (header == null) {
            header = new HeaderFooter(sect.getDocument(), headerType);
            sect.getHeadersFooters().add((Node)header);
        }
        header.appendChild(watermarkPara.deepClone(true));
    }

    private void insertWaterMarks(Document doc, String waterMark) throws Exception {
        WaterMarketConfigVO waterMarkConfig = new WaterMarketConfigVO();
        waterMarkConfig.setTextContent(waterMark);
        this.insertWaterMarks(doc, waterMarkConfig);
    }

    private void insertWaterMarks(Document doc, WaterMarketConfigVO waterMarketConfig) throws Exception {
        Paragraph watermarkPara = new Paragraph((DocumentBase)doc);
        for (int j = 0; j < 500; j += 200) {
            for (int i = 0; i < 700; i += 200) {
                Shape waterShape = AttachmentServiceImpl.ShapeMore(doc, waterMarketConfig, j - 100, i);
                watermarkPara.appendChild((Node)waterShape);
            }
        }
        String text = watermarkPara.getText();
        System.out.println("++++++++++" + text);
        System.out.println("______________" + watermarkPara);
        NodeCollection childNodes = watermarkPara.getChildNodes();
        String text1 = childNodes.get(0).getText();
        System.out.println("111111" + text1);
        for (Section sect : doc.getSections()) {
            this.insertWatermarkIntoHeader(watermarkPara, sect, 1);
            this.insertWatermarkIntoHeader(watermarkPara, sect, 4);
            this.insertWatermarkIntoHeader(watermarkPara, sect, 0);
        }
    }

    private Shape ShapeMore(Document doc, String waterMark, double left, double top) throws Exception {
        WaterMarketConfigVO waterMarketConfigVO = new WaterMarketConfigVO();
        waterMarketConfigVO.setTextContent(waterMark);
        waterMarketConfigVO.setFontFamily("\u5b8b\u4f53");
        waterMarketConfigVO.setFontColor(Color.lightGray);
        return AttachmentServiceImpl.ShapeMore(doc, waterMarketConfigVO, left, top);
    }

    public static Shape ShapeMore(Document doc, WaterMarketConfigVO waterMarketConfig, double left, double top) throws Exception {
        Shape waterShape = new Shape((DocumentBase)doc, 136);
        waterShape.getTextPath().setText(waterMarketConfig.getTextContent());
        waterShape.getTextPath().setFontFamily(StringUtils.isNotBlank((CharSequence)waterMarketConfig.getFontFamily()) ? waterMarketConfig.getFontFamily() : "\u5b8b\u4f53");
        waterShape.setWidth((double)(waterMarketConfig.getTextContent().length() * 14));
        waterShape.setHeight(10.0);
        waterShape.setRotation(null != waterMarketConfig.getRotation() ? waterMarketConfig.getRotation() : -30.0);
        waterShape.setDistanceLeft(0.0);
        waterShape.setFilled(true);
        waterShape.getFill().setColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);
        waterShape.setStrokeColor(null != waterMarketConfig.getFontColor() ? waterMarketConfig.getFontColor() : Color.lightGray);
        waterShape.setLeft(left);
        waterShape.setTop(top);
        waterShape.setWrapType(3);
        return waterShape;
    }

    @Override
    public List<AttachmentVO> queryMyFavoriteList(String userCode, String search) {
        List<AttachmentVO> attachmentVoList = this.attachmentMapper.queryMyFavoriteList(userCode, search);
        return attachmentVoList;
    }

    @Override
    public List<AttachmentVO> queryRecentList(String userCode, String search) {
        List<AttachmentVO> attachmentVoList = this.attachmentMapper.queryRecentList(userCode, search);
        return attachmentVoList;
    }

    @Override
    public List<AttachmentVO> queryListByBillType(String billCode, Long tenantId, String search) {
        List<AttachmentVO> attachmentVos = this.attachmentMapper.queryListByBillType(billCode, tenantId, search);
        return attachmentVos;
    }

    @Override
    public void updateFileCss(String fileId, String extcss) {
        this.attachmentMapper.updateFileCss(fileId, extcss);
    }

    public static int countChineseCharacters(String str) {
        int count = 0;
        for (char c : str.toCharArray()) {
            if (!AttachmentServiceImpl.isChineseCharacter(c)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isChineseCharacter(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static int countEnglishWords(String str) {
        String[] words = str.split("\\W+");
        return words.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Integer queryPageNumber(Long fileId) {
        Integer pages = 0;
        AttachmentEntity attachmentVo = (AttachmentEntity)((Object)this.selectById(fileId));
        if (attachmentVo == null) throw new BusinessException("\u672a\u83b7\u53d6\u5230\u9644\u4ef6\u4fe1\u606f");
        String suffix = FileUtils.getFileExt((String)attachmentVo.getFileName(), (Boolean)false);
        String bucketName = this.minioConfiguration.getBucketName();
        BufferedInputStream in = null;
        try {
            GetObjectResponse getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(attachmentVo.getFilePath())).build());
            in = new BufferedInputStream((InputStream)getObjectResponse);
            if ("docx".equals(suffix)) {
                XWPFDocument document = new XWPFDocument((InputStream)in);
                pages = document.getProperties().getExtendedProperties().getPages();
                return pages;
            } else if ("doc".equals(suffix)) {
                HWPFDocument document = new HWPFDocument((InputStream)in);
                pages = document.getSummaryInformation().getPageCount();
                return pages;
            } else if ("xls".equals(suffix) || "xlsx".equals(suffix)) {
                XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
                Sheet sheet = workbook.getSheetAt(0);
                for (Row row : sheet) {
                    for (Cell cell : row) {
                        cell.setCellType(1);
                        String cellValue = cell.getStringCellValue();
                        if (cellValue == null) continue;
                        int chineseCount = AttachmentServiceImpl.countChineseCharacters(cellValue);
                        int englishWordCount = AttachmentServiceImpl.countEnglishWords(cellValue);
                        pages = pages + (chineseCount + englishWordCount);
                    }
                }
                pages = pages % 2000 == 0 ? Integer.valueOf(pages / 2000) : Integer.valueOf(pages / 2000 + 1);
                return pages;
            } else if ("ppt".equals(suffix) || "pptx".equals(suffix)) {
                XMLSlideShow ppt = new XMLSlideShow((InputStream)in);
                pages = ppt.getSlides().length;
                return pages;
            } else if ("png".equals(suffix) || "jpg".equals(suffix) || "jpeg".equals(suffix) || "svg".equals(suffix) || "gif".equals(suffix)) {
                pages = 1;
                return pages;
            } else {
                if (!"pdf".equals(suffix)) return pages;
                PDDocument document = PDDocument.load((InputStream)in);
                pages = document.getNumberOfPages();
            }
            return pages;
        }
        catch (Exception e) {
            this.logger.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0cMsg\uff1a" + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AttachmentVO> fileToImg(List<AttachmentVO> attaches, String imeType, Integer imgDpi, String imgSourceType) {
        ArrayList<AttachmentVO> resp;
        block17: {
            resp = new ArrayList<AttachmentVO>();
            OutputStream out = null;
            GetObjectResponse getObjectResponse = null;
            try {
                if (!CollectionUtils.isNotEmpty(attaches)) break block17;
                for (AttachmentVO attach : attaches) {
                    if (!attach.getFileName().endsWith(".pdf")) {
                        this.logger.info("**********\u6587\u4ef6id-{}\u8f6c\u56fe\u7247\u8df3\u8fc7\uff0c\u6587\u4ef6\u975ePDF\u683c\u5f0f\uff0c\u5f53\u524d\u4e0d\u652f\u6301\u8fdb\u884c\u683c\u5f0f\u8f6c\u6362**********", (Object)attach.getId());
                        continue;
                    }
                    try {
                        this.logger.info("\u6587\u4ef6id-{}\u8f6c\u56fe\u7247---STAGE----ONE----\u6587\u4ef6\u4e0b\u8f7d------", (Object)attach.getId());
                        String bucketName = this.minioConfiguration.getBucketName();
                        out = new ByteArrayOutputStream();
                        getObjectResponse = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(attach.getFilePath())).build());
                        IOUtils.copy((InputStream)getObjectResponse, (OutputStream)out);
                        this.logger.info("\u6587\u4ef6id-{}\u8f6c\u56fe\u7247---STAGE----ONE----\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f------", (Object)attach.getId());
                        List<byte[]> imgBytesArr = this.pdfProcessor.convertPdfToImages(((ByteArrayOutputStream)out).toByteArray(), imeType, null != imgDpi ? imgDpi : 300);
                        String extName = this.getImgFileExtName(imeType);
                        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                        ByteArrayInputStream mfInputStream = null;
                        AttachmentEntity attachment = null;
                        for (int i = 0; i < imgBytesArr.size(); ++i) {
                            String objectName = attach.getTenantId().toString() + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + extName;
                            mfInputStream = new ByteArrayInputStream(imgBytesArr.get(i));
                            ObjectWriteResponse objectResponse = this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream((InputStream)mfInputStream, (long)((InputStream)mfInputStream).available(), -1L).build());
                            if (!StringUtils.isNotBlank((CharSequence)objectResponse.etag())) continue;
                            attachment = new AttachmentEntity();
                            attachment.setBillType(attach.getBillType());
                            attachment.setSourceId(attach.getId());
                            attachment.setSourceType(StringUtils.isNotBlank((CharSequence)imgSourceType) ? imgSourceType : attach.getSourceType() + "-printFormatImg");
                            attachment.setMark("printFormatImg");
                            attachment.setFileName(attach.getFileName().substring(0, attach.getFileName().indexOf(".")) + "(" + i + ")." + extName);
                            attachment.setFilePath(objectName);
                            attachment.setFileSize(imgBytesArr.get(i).length);
                            attachment.setUploadUserName(attach.getUploadUserName());
                            attachment.setCreateUserCode(attach.getCreateUserCode());
                            attachment.setTenantId(attach.getTenantId());
                            attachment.setOnlinePath(this.fileUrl + objectName);
                            super.saveOrUpdate((Object)attachment, false);
                            resp.add((AttachmentVO)BeanMapper.map((Object)((Object)attachment), AttachmentVO.class));
                        }
                        if (!CollectionUtils.isNotEmpty(resp)) continue;
                        this.setFileTruePath(resp);
                    }
                    catch (Exception e) {
                        this.logger.error("\u9644\u4ef6id-{}\u8f6c\u6362\u4e3a\u56fe\u7247\u5f02\u5e38,", (Object)attach.getId());
                        this.logger.error("\u9644\u4ef6\u8f6c\u6362\u4e3a\u56fe\u7247\u5f02\u5e38,", (Throwable)e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.flush();
                                ((ByteArrayOutputStream)out).close();
                            }
                            catch (IOException e) {
                                this.logger.error("\u9644\u4ef6\u8f6c\u6362\u4e3a\u56fe\u7247\u5f02\u5e38,", (Throwable)e);
                            }
                        }
                        if (getObjectResponse == null) continue;
                        getObjectResponse.close();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("\u9644\u4ef6\u8f6c\u6362\u4e3a\u56fe\u7247\u5f02\u5e38", (Throwable)e);
            }
        }
        return resp;
    }

    public void setFileTruePath(List<AttachmentVO> list) {
        if (!ListUtil.isEmpty(list)) {
            list.forEach(f -> {
                String filePath = f.getFilePath();
                if (StringUtils.isNotBlank((CharSequence)filePath) && filePath.indexOf("http") != -1) {
                    f.setTruePath(filePath);
                } else {
                    f.setTruePath(this.baseHost + "ejc-file-web/attachment/filePreview?fileId=" + f.getId());
                }
                if (StringUtils.isNotBlank((CharSequence)f.getFileFormatPathStr())) {
                    f.setFileFormatPath((List)JSONArray.parse((String)f.getFileFormatPathStr()));
                }
                f.setImgServerPath(this.fileUrl);
                f.setOnlinePath(this.baseHost + "ejc-file-web/attachment/filePreview?fileId=" + f.getId());
            });
        }
    }

    private String getImgFileExtName(String imeType) {
        switch (imeType) {
            case "PNG": {
                return "png";
            }
            case "BMP": {
                return "bmp";
            }
        }
        return "jpg";
    }

    @Override
    public String queryFileCss(String fileId) {
        String extCss = this.attachmentMapper.queryFileCss(fileId);
        return extCss;
    }
}

