/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.service.impl;

import com.aspose.cells.License;
import com.aspose.cells.PdfSaveOptions;
import com.aspose.cells.SaveOptions;
import com.aspose.cells.Workbook;
import com.ejianc.foundation.file.config.MinioConfiguration;
import com.ejianc.foundation.file.mapper.AttachmentMapper;
import com.ejianc.foundation.file.model.FileAttribute;
import com.ejianc.foundation.file.service.FilePreview;
import com.ejianc.foundation.file.util.FileUtils;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class PoiExcelToHtmlImpl
implements FilePreview {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    FileUtils fileUtils;
    @Autowired
    private AttachmentMapper attachmentMapper;
    @Value(value="${fileUrl}")
    private String fileUrl;
    @Autowired
    private MinioClient minioClient;
    @Autowired
    private MinioConfiguration minioConfiguration;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String filePreviewHandle(HttpServletRequest req, AttachmentVO attach, Model model) {
        FileAttribute fileAttribute = this.fileUtils.getFileAttribute(attach.getFilePath());
        String fileName = fileAttribute.getName();
        String newFileSuffix = "pdf";
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
        String newUrl = "";
        try {
            if (StringUtils.isNotBlank((String)attach.getOnlinePath())) {
                newUrl = attach.getOnlinePath().indexOf("http") != -1 ? attach.getOnlinePath() + "?attachid=" + attach.getId() : this.fileUrl + attach.getOnlinePath() + "?attachid=" + attach.getId();
            } else {
                InputStream in = null;
                BufferedInputStream bufferedInputStream = null;
                ByteArrayOutputStream bos = null;
                ByteArrayInputStream bis = null;
                InputStream fileInputStream = null;
                try {
                    bos = new ByteArrayOutputStream();
                    in = this.fileUtils.downloadFileByKeyName(attach.getFilePath());
                    bufferedInputStream = new BufferedInputStream(in);
                    boolean auth = PoiExcelToHtmlImpl.authrolizeLicense();
                    if (!auth) {
                        System.out.println("aspose \u8bb8\u53ef\u65e0\u6548\uff01");
                    }
                    Workbook workbook = new Workbook((InputStream)bufferedInputStream);
                    PdfSaveOptions pdfSaveOptions = new PdfSaveOptions();
                    pdfSaveOptions.setAllColumnsInOnePagePerSheet(true);
                    workbook.acceptAllRevisions();
                    workbook.save((OutputStream)bos, (SaveOptions)pdfSaveOptions);
                    bis = new ByteArrayInputStream(bos.toByteArray());
                    MockMultipartFile multipartFile = new MockMultipartFile(pdfName, (InputStream)bis);
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
                    String objectName = attach.getFilePath().split("/")[0] + "/" + format.format(new Date()) + "/" + IdWorker.getId() + "." + newFileSuffix;
                    fileInputStream = multipartFile.getInputStream();
                    this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.minioConfiguration.getBucketName())).object(objectName)).stream(fileInputStream, (long)fileInputStream.available(), -1L).build());
                    this.attachmentMapper.updateOnlinePath(attach.getFilePath(), objectName);
                    newUrl = this.fileUrl + objectName + "?attachid=" + attach.getId();
                    if (StringUtils.isBlank((String)newUrl)) {
                        String string = "fileNotSupported";
                        return string;
                    }
                }
                catch (Exception e) {
                    this.logger.info("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                    String string = "fileNotSupported";
                    return string;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                    if (bis != null) {
                        bis.close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            newUrl = newUrl.replaceAll("=", "%3d");
            model.addAttribute("pdfUrl", (Object)newUrl);
            return "mobilepdf";
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            return "fileNotSupported";
        }
    }

    public static boolean authrolizeLicense() {
        boolean result = false;
        try {
            InputStream is = License.class.getResourceAsStream("/com.aspose.cells.lic_2999.xml");
            License asposeLicense = new License();
            asposeLicense.setLicense(is);
            is.close();
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

