/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class FileCharsetDetector {
    public static Observer guessFileEncoding(File file) throws FileNotFoundException, IOException {
        return FileCharsetDetector.guessFileEncoding(file, new nsDetector());
    }

    public static Observer guessFileEncoding(File file, int languageHint) throws FileNotFoundException, IOException {
        return FileCharsetDetector.guessFileEncoding(file, new nsDetector(languageHint));
    }

    private static Observer guessFileEncoding(File file, nsDetector det) throws FileNotFoundException, IOException {
        int len;
        Observer observer = new Observer();
        det.Init((nsICharsetDetectionObserver)observer);
        BufferedInputStream imp = new BufferedInputStream(new FileInputStream(file));
        byte[] buf = new byte[1024];
        boolean done = false;
        boolean isAscii = false;
        while ((len = imp.read(buf, 0, buf.length)) != -1 && !(isAscii = det.isAscii(buf, len)) && !(done = det.DoIt(buf, len, false))) {
        }
        imp.close();
        det.DataEnd();
        if (isAscii) {
            observer.encoding = "ASCII";
            observer.found = true;
        }
        if (!observer.isFound()) {
            String[] prob = det.getProbableCharsets();
            if (prob.length > 0) {
                observer.encoding = prob[0];
            } else {
                observer.encoding = null;
            }
        }
        return observer;
    }

    public static class Observer
    implements nsICharsetDetectionObserver {
        private String encoding = null;
        private boolean found = false;

        public void Notify(String charset) {
            this.encoding = charset;
            this.found = true;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public boolean isFound() {
            return this.found;
        }

        public String toString() {
            return "Observer [encoding=" + this.encoding + ", found=" + this.found + "]";
        }
    }
}

