/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;

public class ZipCompress {
    private OutputStream outputStream;

    public ZipCompress(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress(Map<String, byte[]> fileBytes) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.outputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            if (fileBytes != null) {
                for (Map.Entry<String, byte[]> entry : fileBytes.entrySet()) {
                    byte[] bytes = entry.getValue();
                    String fileName = entry.getKey();
                    zipOutputStream.putNextEntry(new ZipEntry(fileName));
                    byteArrayInputStream = new ByteArrayInputStream(bytes);
                    IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)zipOutputStream);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.closeEntry();
                zipOutputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
    }
}

