/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.foundation.file.config;

import com.ejianc.foundation.file.config.ThreadContextDecorator;
import com.ejianc.framework.core.util.EnvironmentTools;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
@ConfigurationProperties(prefix="async.pdf")
public class TaskConfig {
    @Autowired
    private EnvironmentTools environmentTools;

    @Bean(name={"pdfTaskExecutor"})
    public Executor pdfTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(2);
        executor.setMaxPoolSize(8);
        executor.setQueueCapacity(50);
        executor.setThreadNamePrefix("pdf-processor-");
        executor.setKeepAliveSeconds(60);
        executor.setTaskDecorator((TaskDecorator)new ThreadContextDecorator(this.environmentTools.getBaseHost(), false));
        executor.initialize();
        return executor;
    }
}

