package com.ejianc.business.filesystem.file.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.filesystem.file.dto.FileBtnDTO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 元文件
 * 
 * @author generator
 * 
 */
public class FileMetafileVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Integer billState; // 单据状态（审批必须字段）
    private String createUserName; // 编制人
    private String updateUserName; // 修改者
    private Integer metafileNum; // 序号
    private String metafileCode; // 档号
    private String reference; // 文号
    private Integer status; // 状态（0编辑文件1归档问价2删除文件3入卷文件）
    private String attr; // 记录属性（文书文件、荣誉文件、照片、影像、干部档案、会计档案）
    private Integer attrex; // 扩展属性
    private Long orgId; // 单位id
    private String orgName; // 单位名称
    private Long deptId; // 部门id
    private String deptName; // 部门名称
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long fileTypeId; // 分类id
    private String fileTypeName; // 分类名称
    private Long parentId; // 卷号id
    private String title; // 题名
    private Integer filingNum; // 归档份数
    private Long personFilingId; // 归档人id
    private String personFilingName; // 归档人名称
    private Long caseCreateUserId; // 立卷人id
    private String caseCreateUserName; // 立卷人名称
    private Long personResponsibleId; // 责任人id
    private String personResponsibleName; // 责任人名称
    private Long orgOutId; // 移交单位id
    private String orgOutName; // 移交单位名称
    private Long personOutId; // 移交人id
    private String personOutName; // 移交人名称
    private Long orgInId; // 接收单位id
    private String orgInName; // 接收单位名称
    private Long personInId; // 接收人id
    private String personInName; // 接收人名称
    private Date outDate; // 移交日期
    private Integer year; // 年度
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date cDate; // 成文日期
    private Date metafileDate; // 登记日期
    private Date startDate; // 开始日期
    private Date endDate; // 结束日期
    private Integer totalPageNum; // 页数
    private String pageCode; // 页号
    private Integer fileNum; // 文件件数
    private String memo; // 摘要
    private String remark; // 备注
    private String keyword; // 主题词
    private Integer retentionPeriod; // 保管期限(0:短期1:长期2:永久)
    private Integer classification; // 密级(0:普通1:秘密2:工作秘密3:商业秘密4:机密5:绝密)
    private String filingProgress; // 归档进展(符合、缺失、部分缺失)
    private String isRequired; // 是否必须(必归、须归、可归)
    private String parentCode; // 卷号
    /**
     * 附件ids
     */
    private List<Long> fileIds = new ArrayList<>();
    private String filingState; // 归档状态
    private int metafileType; // 元文件类型(0纸质1在线电子档2纸质在线电子档3纸质离线电子4离线电子档)
    private String borrowState; // 借阅状态（在库、借出）
    private Long createUserId; // 创建人id
    private Integer borrowNum; //正在借阅数量
    private String source; // 来源
    private String billAddress; // 跳转地址


    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getBillAddress() {
        return billAddress;
    }

    public void setBillAddress(String billAddress) {
        this.billAddress = billAddress;
    }

    public Integer getBorrowNum() {
        return borrowNum;
    }

    public void setBorrowNum(Integer borrowNum) {
        this.borrowNum = borrowNum;
    }

    public String getBorrowState() {
        return borrowState;
    }

    public void setBorrowState(String borrowState) {
        this.borrowState = borrowState;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }
    private String errorMsg;

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public int getMetafileType() {
        return metafileType;
    }

    public void setMetafileType(int metafileType) {
        this.metafileType = metafileType;
    }

    public String getFilingState() {
        return filingState;
    }

    public void setFilingState(String filingState) {
        this.filingState = filingState;
    }
    private List<FileBtnDTO> fileList  = new ArrayList<>();

    public List<FileBtnDTO> getFileList() {
        return fileList;
    }

    public void setFileList(List<FileBtnDTO> fileList) {
        this.fileList = fileList;
    }

    public List<Long> getFileIds() {
        return fileIds;
    }

    public void setFileIds(List<Long> fileIds) {
        this.fileIds = fileIds;
    }

    public Date getcDate() {
        return cDate;
    }

    public void setcDate(Date cDate) {
        this.cDate = cDate;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public Integer getMetafileNum() {
        return metafileNum;
    }

    public void setMetafileNum(Integer metafileNum) {
        this.metafileNum = metafileNum;
    }
    public String getMetafileCode() {
        return metafileCode;
    }

    public void setMetafileCode(String metafileCode) {
        this.metafileCode = metafileCode;
    }
    public String getReference() {
        return reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getAttr() {
        return attr;
    }

    public void setAttr(String attr) {
        this.attr = attr;
    }
    public Integer getAttrex() {
        return attrex;
    }

    public void setAttrex(Integer attrex) {
        this.attrex = attrex;
    }
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="filesystem-workType")
    public Long getFileTypeId() {
        return fileTypeId;
    }
    @ReferDeserialTransfer
    public void setFileTypeId(Long fileTypeId) {
        this.fileTypeId = fileTypeId;
    }
    public String getFileTypeName() {
        return fileTypeName;
    }

    public void setFileTypeName(String fileTypeName) {
        this.fileTypeName = fileTypeName;
    }
    @ReferSerialTransfer(referCode = "refFileCaseData")
    public Long getParentId() {
        return parentId;
    }
    @ReferDeserialTransfer
    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
    public Integer getFilingNum() {
        return filingNum;
    }

    public void setFilingNum(Integer filingNum) {
        this.filingNum = filingNum;
    }
    public Long getPersonFilingId() {
        return personFilingId;
    }
    @ReferDeserialTransfer
    public void setPersonFilingId(Long personFilingId) {
        this.personFilingId = personFilingId;
    }
    public String getPersonFilingName() {
        return personFilingName;
    }

    public void setPersonFilingName(String personFilingName) {
        this.personFilingName = personFilingName;
    }
    public Long getCaseCreateUserId() {
        return caseCreateUserId;
    }
    @ReferDeserialTransfer
    public void setCaseCreateUserId(Long caseCreateUserId) {
        this.caseCreateUserId = caseCreateUserId;
    }
    public String getCaseCreateUserName() {
        return caseCreateUserName;
    }

    public void setCaseCreateUserName(String caseCreateUserName) {
        this.caseCreateUserName = caseCreateUserName;
    }
    public Long getPersonResponsibleId() {
        return personResponsibleId;
    }
    @ReferDeserialTransfer
    public void setPersonResponsibleId(Long personResponsibleId) {
        this.personResponsibleId = personResponsibleId;
    }
    public String getPersonResponsibleName() {
        return personResponsibleName;
    }

    public void setPersonResponsibleName(String personResponsibleName) {
        this.personResponsibleName = personResponsibleName;
    }
    public Long getOrgOutId() {
        return orgOutId;
    }
    @ReferDeserialTransfer
    public void setOrgOutId(Long orgOutId) {
        this.orgOutId = orgOutId;
    }
    public String getOrgOutName() {
        return orgOutName;
    }

    public void setOrgOutName(String orgOutName) {
        this.orgOutName = orgOutName;
    }
    public Long getPersonOutId() {
        return personOutId;
    }
    @ReferDeserialTransfer
    public void setPersonOutId(Long personOutId) {
        this.personOutId = personOutId;
    }
    public String getPersonOutName() {
        return personOutName;
    }

    public void setPersonOutName(String personOutName) {
        this.personOutName = personOutName;
    }
    public Long getOrgInId() {
        return orgInId;
    }
    @ReferDeserialTransfer
    public void setOrgInId(Long orgInId) {
        this.orgInId = orgInId;
    }
    public String getOrgInName() {
        return orgInName;
    }

    public void setOrgInName(String orgInName) {
        this.orgInName = orgInName;
    }
    public Long getPersonInId() {
        return personInId;
    }
    @ReferDeserialTransfer
    public void setPersonInId(Long personInId) {
        this.personInId = personInId;
    }
    public String getPersonInName() {
        return personInName;
    }

    public void setPersonInName(String personInName) {
        this.personInName = personInName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }
    public Date getCDate() {
        return cDate;
    }

    public void setCDate(Date cDate) {
        this.cDate = cDate;
    }
    public Date getMetafileDate() {
        return metafileDate;
    }

    public void setMetafileDate(Date metafileDate) {
        this.metafileDate = metafileDate;
    }
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Integer getTotalPageNum() {
        return totalPageNum;
    }

    public void setTotalPageNum(Integer totalPageNum) {
        this.totalPageNum = totalPageNum;
    }
    public String getPageCode() {
        return pageCode;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }
    public Integer getFileNum() {
        return fileNum;
    }

    public void setFileNum(Integer fileNum) {
        this.fileNum = fileNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }
    public Integer getRetentionPeriod() {
        return retentionPeriod;
    }

    public void setRetentionPeriod(Integer retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }
    public Integer getClassification() {
        return classification;
    }

    public void setClassification(Integer classification) {
        this.classification = classification;
    }
    public String getFilingProgress() {
        return filingProgress;
    }

    public void setFilingProgress(String filingProgress) {
        this.filingProgress = filingProgress;
    }
    public String getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(String isRequired) {
        this.isRequired = isRequired;
    }
    
}
