/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.config;

import io.minio.MinioClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

@Configuration
@ConfigurationProperties(prefix="ejc.minio")
public class MinioConfiguration {
    public static Logger logger = LoggerFactory.getLogger(MinioConfiguration.class);
    private String endPoint;
    private String accessKey;
    private String secretAccessKey;
    private String bucketName;
    private String blackFileExt;
    private Integer sizeLimit = 367001600;

    @Bean
    public MinioClient getMinioClient() {
        logger.info("-------------------------endPoint:{}", (Object)this.endPoint);
        MinioClient minioClient = MinioClient.builder().endpoint(this.endPoint).credentials(this.accessKey, this.secretAccessKey).build();
        return minioClient;
    }

    @Bean(name={"multipartResolver"})
    public CommonsMultipartResolver getCommonsMultipartResolver() {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
        multipartResolver.setMaxInMemorySize(0x100000);
        return multipartResolver;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretAccessKey() {
        return this.secretAccessKey;
    }

    public void setSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBlackFileExt() {
        return this.blackFileExt;
    }

    public void setBlackFileExt(String blackFileExt) {
        this.blackFileExt = blackFileExt;
    }

    public Integer getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(Integer sizeLimit) {
        this.sizeLimit = sizeLimit;
    }
}

