/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.filesystem.file.bean.FileCaseDetailEntity;
import com.ejianc.business.filesystem.file.bean.FileCaseEntity;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.service.IFileCaseDetailService;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileCaseDetailVO;
import com.ejianc.business.filesystem.file.vo.FileCaseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fileCase"})
public class FileCaseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IFileCaseService service;
    @Autowired
    private IFileCaseDetailService detailService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFileTypeService fileTypeService;
    @Autowired
    private IFileMetafileService metafileService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FileCaseVO> saveOrUpdate(@RequestBody FileCaseVO saveOrUpdateVO) {
        FileCaseEntity entityNew;
        List<FileCaseDetailEntity> fileCaseDetailList;
        List fileCaseDetailList1 = saveOrUpdateVO.getFileCaseDetailList();
        List delFileIds = fileCaseDetailList1.stream().filter(entity -> "del".equals(entity.getRowState()) && entity.getMetaFileId() != null).map(FileCaseDetailVO::getMetaFileId).collect(Collectors.toList());
        FileCaseEntity entity2 = (FileCaseEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FileCaseEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        QueryParam param = new QueryParam();
        param.getParams().put("reference", new Parameter("eq", (Object)entity2.getReference()));
        List fileCaseEntities = this.service.queryList(param);
        if (entity2.getId() == null || entity2.getId() == 0L) {
            entity2.setCreateUserId(userContextCache.getUserId());
            entity2.setCreateUserName(userContextCache.getUserName());
            if (fileCaseEntities != null && fileCaseEntities.size() > 0) {
                throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u6863\u53f7\uff01");
            }
        } else {
            entity2.setUpdateUserName(userContextCache.getUserName());
            if (fileCaseEntities != null && fileCaseEntities.size() > 1) {
                throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u6863\u53f7\uff01");
            }
        }
        entity2.setFilingState("\u672a\u5f52\u6863");
        this.service.saveOrUpdate((Object)entity2, false);
        if (CollectionUtils.isNotEmpty(delFileIds)) {
            this.metafileService.removeByIds(delFileIds);
        }
        if (CollectionUtils.isNotEmpty(fileCaseDetailList = (entityNew = (FileCaseEntity)((Object)this.service.selectById(entity2.getId()))).getFileCaseDetailList())) {
            List collect = fileCaseDetailList.stream().filter(etity -> etity.getMetaFileId() == null).collect(Collectors.toList());
            for (FileCaseDetailEntity fileCaseDetailEntity : collect) {
                FileMetafileEntity fileMetafileEntity = new FileMetafileEntity();
                fileMetafileEntity.setParentId(entityNew.getId());
                fileMetafileEntity.setParentCode(entityNew.getCaseCode());
                fileMetafileEntity.setReference(entityNew.getCaseCode() + "-" + fileCaseDetailEntity.getCode());
                fileMetafileEntity.setTitle(entityNew.getProjectName() + "-" + fileCaseDetailEntity.getFileName());
                fileMetafileEntity.setOrgId(entityNew.getOrgId());
                fileMetafileEntity.setOrgName(entityNew.getOrgName());
                fileMetafileEntity.setFileTypeId(entityNew.getFileTypeId());
                fileMetafileEntity.setFileTypeName(entityNew.getFileTypeName());
                fileMetafileEntity.setCreateUserName(entityNew.getCreateUserName());
                fileMetafileEntity.setCreateUserId(entityNew.getCreateUserId());
                fileMetafileEntity.setPersonResponsibleName(entityNew.getCreateUserName());
                fileMetafileEntity.setMetafileNum(0);
                fileMetafileEntity.setFilingNum(1);
                fileMetafileEntity.setFilingNum(0);
                fileMetafileEntity.setClassification(0);
                fileMetafileEntity.setRetentionPeriod(0);
                fileMetafileEntity.setTotalPageNum(0);
                fileMetafileEntity.setFilingState("\u672a\u5f52\u6863");
                fileMetafileEntity.setBorrowNum(0);
                fileMetafileEntity.setBorrowState("\u5728\u5e93");
                fileMetafileEntity.setCDate(new Date());
                this.metafileService.saveOrUpdate((Object)fileMetafileEntity);
                fileCaseDetailEntity.setMetaFileId(fileMetafileEntity.getId());
                this.detailService.saveOrUpdate((Object)fileCaseDetailEntity);
            }
        }
        FileCaseVO vo = (FileCaseVO)BeanMapper.map((Object)((Object)entityNew), FileCaseVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FileCaseVO> queryDetail(Long id) {
        FileCaseEntity entity = (FileCaseEntity)((Object)this.service.selectById(id));
        FileCaseVO vo = (FileCaseVO)BeanMapper.map((Object)((Object)entity), FileCaseVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileCaseVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FileCaseVO fileCaseVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryFilingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileCaseVO>> queryFilingList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter("eq", (Object)"\u5df2\u5f52\u6863"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileCaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileCaseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("", new Parameter("sql", (Object)" (filing_state= '\u672a\u5f52\u6863'or file_type_id in (895340334396051474,898575273094647864,898575365717463080,898575642839322678,898575810083000414))"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileCaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileCase-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFileCaseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FileCaseVO>> refFileCaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"filingState")) {
                param.getParams().put("filingState", new Parameter("eq", (Object)_con.getString("filingState")));
            }
            if (_con.containsKey((Object)"fileTypeId")) {
                param.getParams().put("fileTypeId", new Parameter("eq", (Object)_con.getString("fileTypeId")));
            }
            if (_con.containsKey((Object)"borrowState")) {
                param.getParams().put("borrowState", new Parameter("eq", (Object)_con.getString("borrowState")));
            }
            if (_con.containsKey((Object)"fileType")) {
                QueryParam param1 = new QueryParam();
                if (_con.getString("fileType").equals("1")) {
                    param1.getParams().put("lastTypeId", new Parameter("in", Arrays.asList("877940299152830497", "877940557538734178")));
                } else {
                    param1.getParams().put("lastTypeId", new Parameter("in", Arrays.asList("894547059074502668")));
                }
                param1.getParams().put("billState", new Parameter("in", Arrays.asList("1,3")));
                List fileTypeEntities = this.fileTypeService.queryList(param1);
                List collect = fileTypeEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                param.getParams().put("fileTypeId", new Parameter("in", collect));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileCaseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateFilingState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateFilingState(Long id) {
        FileCaseEntity fileCaseEntity = (FileCaseEntity)((Object)this.service.selectById(id));
        if (fileCaseEntity.getFilingState() == "\u5df2\u5f52\u6863") {
            return CommonResponse.error((String)"\u5df2\u5f52\u6863\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u5f52\u6863\uff01");
        }
        if (fileCaseEntity.getBillState() != 1 && fileCaseEntity.getBillState() != 3) {
            return CommonResponse.error((String)"\u5ba1\u6279\u901a\u8fc7\u7684\u624d\u80fd\u5f52\u6863\uff01");
        }
        fileCaseEntity.setFilingState("\u5df2\u5f52\u6863");
        this.service.saveOrUpdate((Object)fileCaseEntity);
        this.metafileService.updateFilingState(id);
        return CommonResponse.success((String)"\u4fee\u6539\u5f52\u6863\u72b6\u6001\u6210\u529f\uff01");
    }
}

