/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.filesystem.common.MinioUtils;
import com.ejianc.business.filesystem.file.bean.FileMetafileEntity;
import com.ejianc.business.filesystem.file.bean.FileRecordEntity;
import com.ejianc.business.filesystem.file.dto.FileBtnDTO;
import com.ejianc.business.filesystem.file.dto.FileResponseDTO;
import com.ejianc.business.filesystem.file.dto.HashBtnDTO;
import com.ejianc.business.filesystem.file.mapper.FileBorrowDetailMapper;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileRecordService;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileMetafileVO;
import com.ejianc.business.filesystem.utils.DetailIndexExcelReaderZzyj;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleUserRelationVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"fileMetafile"})
public class FileMetafileController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IFileMetafileService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IFileRecordService recordService;
    @Autowired
    private MinioUtils utils;
    @Value(value="${ejc.roleid}")
    private Long roleId;
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IFileCaseService caseService;
    @Autowired
    private IFileTypeService fileTypeService;
    @Autowired
    private FileBorrowDetailMapper borrowDetailMapper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FileMetafileVO> saveOrUpdate(@RequestBody FileMetafileVO saveOrUpdateVO) {
        FileMetafileEntity entity = (FileMetafileEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FileMetafileEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserId(userContextCache.getUserId());
            entity.setCreateUserName(userContextCache.getUserName());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        entity.setFilingState("\u672a\u5f52\u6863");
        this.service.saveOrUpdate((Object)entity, false);
        if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getFileIds())) {
            for (Long fileId : saveOrUpdateVO.getFileIds()) {
                FileRecordEntity fileRecordEntity = (FileRecordEntity)((Object)this.recordService.selectById(fileId));
                if (fileRecordEntity.getBillId() != -1L) continue;
                fileRecordEntity.setBillId(entity.getId());
                this.recordService.saveOrUpdate((Object)fileRecordEntity);
            }
        }
        FileMetafileVO vo = (FileMetafileVO)BeanMapper.map((Object)((Object)entity), FileMetafileVO.class);
        QueryWrapper ae = new QueryWrapper();
        ae.eq((Object)"bill_id", (Object)entity.getId());
        ae.eq((Object)"dr", (Object)0);
        List list = this.recordService.list((Wrapper)ae);
        if (!CollectionUtils.isNotEmpty((Collection)list)) return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
        ArrayList<FileBtnDTO> fileList = new ArrayList<FileBtnDTO>();
        for (FileRecordEntity fileRecordEntity : list) {
            FileBtnDTO fileBtnDTO = new FileBtnDTO();
            FileResponseDTO fileResponseDTO = new FileResponseDTO();
            String objectUrl = this.utils.getObjectUrl(fileRecordEntity.getFilePath());
            fileBtnDTO.setUid(fileRecordEntity.getId() + "");
            fileBtnDTO.setName(fileRecordEntity.getFileName());
            fileBtnDTO.setStatus("done");
            fileBtnDTO.setUrl(objectUrl);
            fileResponseDTO.setCode("0");
            fileResponseDTO.setMsg("success");
            fileResponseDTO.setName(fileRecordEntity.getFileName());
            fileResponseDTO.setFileName(fileRecordEntity.getFileName());
            fileResponseDTO.setUrl(objectUrl);
            fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
            fileResponseDTO.setFileId(fileRecordEntity.getId() + "");
            fileBtnDTO.setResponse(fileResponseDTO);
            fileList.add(fileBtnDTO);
        }
        vo.setFileList(fileList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FileMetafileVO> queryDetail(Long id) {
        FileMetafileEntity entity = (FileMetafileEntity)((Object)this.service.selectById(id));
        FileMetafileVO vo = (FileMetafileVO)BeanMapper.map((Object)((Object)entity), FileMetafileVO.class);
        boolean viewFlag = false;
        UserContext userContextCache = this.sessionManager.getUserContext();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(this.roleId);
        CommonResponse roleResp = this.roleApi.getRoleUser(roleIds, null);
        if (!roleResp.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u83b7\u53d6\u53d1\u9001\u4fe1\u606f\u89d2\u8272\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        List relationVOS = (List)roleResp.getData();
        List userIds = relationVOS.stream().map(RoleUserRelationVO::getUserId).map(Object::toString).collect(Collectors.toList());
        if (userIds.contains(userContextCache.getUserId().toString())) {
            viewFlag = true;
        }
        if (vo.getCreateUserId().equals(userContextCache.getUserId())) {
            viewFlag = true;
        }
        Integer borrowDetailByBillIdAndUserId = this.borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getId(), userContextCache.getUserId());
        Integer borrowDetailByBillIdAndUserId1 = this.borrowDetailMapper.getBorrowDetailByBillIdAndUserId(vo.getParentId(), userContextCache.getUserId());
        if (borrowDetailByBillIdAndUserId > 0 || borrowDetailByBillIdAndUserId1 > 0) {
            viewFlag = true;
        }
        QueryWrapper ae = new QueryWrapper();
        ae.eq((Object)"bill_id", (Object)entity.getId());
        ae.eq((Object)"dr", (Object)0);
        List list = this.recordService.list((Wrapper)ae);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList<FileBtnDTO> fileList = new ArrayList<FileBtnDTO>();
            for (FileRecordEntity fileRecordEntity : list) {
                FileBtnDTO fileBtnDTO = new FileBtnDTO();
                FileResponseDTO fileResponseDTO = new FileResponseDTO();
                String objectUrl = this.utils.getObjectUrl(fileRecordEntity.getFilePath());
                fileBtnDTO.setUid(fileRecordEntity.getId() + "");
                fileBtnDTO.setName(fileRecordEntity.getFileName());
                fileBtnDTO.setStatus("done");
                if (viewFlag) {
                    fileBtnDTO.setUrl(objectUrl);
                }
                fileResponseDTO.setCode("0");
                fileResponseDTO.setMsg("success");
                fileResponseDTO.setName(fileRecordEntity.getFileName());
                fileResponseDTO.setFileName(fileRecordEntity.getFileName());
                if (viewFlag) {
                    fileResponseDTO.setUrl(objectUrl);
                    fileResponseDTO.setFilePath(fileRecordEntity.getFilePath());
                }
                fileResponseDTO.setFileId(fileRecordEntity.getId() + "");
                fileBtnDTO.setResponse(fileResponseDTO);
                fileList.add(fileBtnDTO);
            }
            vo.setFileList(fileList);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileMetafileVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FileMetafileVO fileMetafileVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        param.getOrderMap().put("metafileNum", "asc");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter("eq", (Object)"\u672a\u5f52\u6863"));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileMetafileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryFilingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryFilingList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter("eq", (Object)"\u5df2\u5f52\u6863"));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileMetafileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryHashList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> queryHashList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("reference");
        fuzzyFields.add("title");
        fuzzyFields.add("keyword");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter("eq", (Object)"\u672a\u5f52\u6863"));
        param.getParams().put("parentId", new Parameter("sql", (Object)"parent_id is null"));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileMetafileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileMetafile-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFileMetafileHashData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> refFileMetafileHashData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("filingState", new Parameter("eq", (Object)"\u672a\u5f52\u6863"));
        param.getParams().put("parentId", new Parameter("sql", (Object)"parent_id is null"));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"fileTypeId")) {
            param.getParams().put("fileTypeId", new Parameter("eq", (Object)_con.getString("fileTypeId")));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileMetafileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refFileMetafileData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FileMetafileVO>> refFileMetafileData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"filingState")) {
                param.getParams().put("filingState", new Parameter("eq", (Object)_con.getString("filingState")));
            }
            if (_con.containsKey((Object)"fileTypeId")) {
                param.getParams().put("fileTypeId", new Parameter("eq", (Object)_con.getString("fileTypeId")));
            }
            if (_con.containsKey((Object)"borrowState")) {
                param.getParams().put("borrowState", new Parameter("eq", (Object)_con.getString("borrowState")));
            }
            if (_con.containsKey((Object)"metafileType")) {
                param.getParams().put("metafileType", new Parameter("in", Arrays.asList(_con.getString("metafileType"))));
            }
            if (_con.containsKey((Object)"fileType")) {
                QueryParam param1 = new QueryParam();
                if (_con.getString("fileType").equals("1")) {
                    param1.getParams().put("lastTypeId", new Parameter("in", Arrays.asList("877940299152830497", "877940557538734178")));
                } else {
                    param1.getParams().put("lastTypeId", new Parameter("in", Arrays.asList("894547059074502668")));
                }
                param1.getParams().put("billState", new Parameter("in", Arrays.asList("1,3")));
                List fileTypeEntities = this.fileTypeService.queryList(param1);
                List collect = fileTypeEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                QueryParam param2 = new QueryParam();
                param2.getParams().put("fileTypeId", new Parameter("in", collect));
                param2.getParams().put("billState", new Parameter("in", Arrays.asList("1,3")));
                List fileCaseEntities = this.caseService.queryList(param2);
                List collect1 = fileCaseEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
                param.getParams().put("parentId", new Parameter("in", collect1));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), FileMetafileVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/selectHashFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> selectHashFiles(@RequestBody HashBtnDTO param) {
        List vos = param.getVos();
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            for (FileMetafileVO vo : vos) {
                FileMetafileEntity fileMetafileEntity = (FileMetafileEntity)((Object)this.service.selectById(vo.getId()));
                fileMetafileEntity.setParentId(param.getParentId());
                fileMetafileEntity.setParentCode(param.getParentCode());
                this.service.saveOrUpdate((Object)fileMetafileEntity);
            }
        }
        return CommonResponse.success((String)"\u6dfb\u52a0\u6563\u6587\u4ef6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/delParentId"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delParentId(@RequestBody List<String> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(FileMetafileEntity::getParentId, null);
            updateWrapper.in(BaseEntity::getId, ids);
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u6dfb\u52a0\u6563\u6587\u4ef6\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/downloadInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public void downloadInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam Long parentId) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (parentId == null) {
            throw new BusinessException("parentId\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        }
        param.getParams().put("parent_id", new Parameter("eq", (Object)parentId));
        List list = this.service.queryList(param);
        for (FileMetafileEntity fileMetafileEntity : list) {
            fileMetafileEntity.setRemark(fileMetafileEntity.getId() + "");
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileMetafile-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelImportInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportInfo(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<FileMetafileVO> successList = new ArrayList<FileMetafileVO>();
        ArrayList<FileMetafileVO> errorList = new ArrayList<FileMetafileVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = DetailIndexExcelReaderZzyj.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                FileMetafileVO fileMetafileVO;
                block13: {
                    List<String> datas = result.get(i);
                    fileMetafileVO = new FileMetafileVO();
                    try {
                        String id = datas.get(0);
                        if (StringUtils.isNotBlank((CharSequence)id)) {
                            String metafileNum;
                            FileMetafileEntity fileMetafileEntity = (FileMetafileEntity)((Object)this.service.selectById((Serializable)((Object)id)));
                            try {
                                metafileNum = datas.get(1);
                                if (!StringUtils.isNotBlank((CharSequence)metafileNum)) {
                                    throw new Exception("\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                                }
                                fileMetafileVO.setMetafileNum(Integer.valueOf(Integer.parseInt(metafileNum)));
                                fileMetafileEntity.setMetafileNum(Integer.parseInt(metafileNum));
                                fileMetafileEntity.setReference(fileMetafileEntity.getParentCode() + "-" + metafileNum);
                            }
                            catch (Exception e) {
                                fileMetafileVO.setErrorMsg("\u5e8f\u53f7\u9519\u8bef\uff01");
                                errorList.add(fileMetafileVO);
                                continue;
                            }
                            try {
                                metafileNum = datas.get(3);
                                if (!StringUtils.isNotBlank((CharSequence)metafileNum)) {
                                    throw new Exception("\u9898\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                                }
                                fileMetafileVO.setTitle(metafileNum);
                                fileMetafileEntity.setTitle(metafileNum);
                            }
                            catch (Exception e) {
                                fileMetafileVO.setErrorMsg("\u9898\u540d\u9519\u8bef\uff01");
                                errorList.add(fileMetafileVO);
                                continue;
                            }
                            fileMetafileVO.setTotalPageNum(Integer.valueOf(Integer.parseInt(datas.get(4))));
                            fileMetafileEntity.setTotalPageNum(Integer.parseInt(datas.get(4)));
                            fileMetafileVO.setKeyword(datas.get(5));
                            fileMetafileEntity.setKeyword(datas.get(5));
                            this.service.saveOrUpdate((Object)fileMetafileEntity);
                            break block13;
                        }
                        throw new Exception("id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    catch (Exception e) {
                        fileMetafileVO.setErrorMsg("id\u9519\u8bef\uff01");
                        errorList.add(fileMetafileVO);
                        continue;
                    }
                }
                fileMetafileVO.setRowState("add");
                successList.add(fileMetafileVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

