/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.filesystem.file.dto.FileSearchDTO;
import com.ejianc.business.filesystem.file.mapper.FileSearchMapper;
import com.ejianc.business.filesystem.file.service.IFileCaseService;
import com.ejianc.business.filesystem.file.service.IFileMetafileService;
import com.ejianc.business.filesystem.file.service.IFileProjectService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fileSearch"})
public class FileSearchController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IFileCaseService caseService;
    @Autowired
    private IFileMetafileService metafileService;
    @Autowired
    private IFileProjectService projectService;
    @Autowired
    private FileSearchMapper mapper;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileSearchDTO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("info");
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String reference = null;
        String projectCode = null;
        String title = null;
        String keyword = null;
        String memo = null;
        String remark = null;
        if (param.getParams().containsKey("searchKey")) {
            if (param.getSearchText() != null) {
                String searchKey = ((Parameter)param.getParams().get("searchKey")).getValue().toString();
                if (searchKey.indexOf("0") > -1) {
                    reference = param.getSearchText();
                }
                if (searchKey.indexOf("1") > -1) {
                    projectCode = param.getSearchText();
                }
                if (searchKey.indexOf("2") > -1) {
                    title = param.getSearchText();
                }
                if (searchKey.indexOf("3") > -1) {
                    keyword = param.getSearchText();
                }
                if (searchKey.indexOf("4") > -1) {
                    memo = param.getSearchText();
                }
                if (searchKey.indexOf("5") > -1) {
                    remark = param.getSearchText();
                }
                param.setSearchText(null);
            }
            param.getParams().remove("searchKey");
        }
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<FileSearchDTO> list = this.mapper.queryFileList((Page<FileSearchDTO>)page, wrapper, reference, projectCode, title, keyword, memo, remark);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

