/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.filesystem.file.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.filesystem.file.bean.FileTypeEntity;
import com.ejianc.business.filesystem.file.service.IFileTypeService;
import com.ejianc.business.filesystem.file.vo.FileTypeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"fileType"})
public class FileTypeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IFileTypeService service;
    @Autowired
    private SessionManager sessionManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<FileTypeVO> saveOrUpdate(@RequestBody FileTypeVO saveOrUpdateVO) {
        FileTypeEntity entity = (FileTypeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, FileTypeEntity.class));
        UserContext userContextCache = this.sessionManager.getUserContext();
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            entity.setCreateUserName(userContextCache.getUserName());
        } else {
            entity.setUpdateUserName(userContextCache.getUserName());
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getLastTypeId() != null) {
            FileTypeEntity pEntity = (FileTypeEntity)((Object)this.service.selectById(entity.getLastTypeId()));
            String innerCode = pEntity.getInnerCode();
            String innerName = pEntity.getInnerName();
            entity.setInnerCode(innerCode + "-" + entity.getId().toString());
            entity.setInnerName(innerName + "-" + entity.getWorkTypeName());
        } else {
            entity.setInnerCode(entity.getId().toString());
            entity.setInnerName(entity.getWorkTypeName());
        }
        this.service.saveOrUpdate((Object)entity);
        FileTypeVO vo = (FileTypeVO)BeanMapper.map((Object)((Object)entity), FileTypeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<FileTypeVO> queryDetail(Long id) {
        FileTypeEntity entity = (FileTypeEntity)((Object)this.service.selectById(id));
        FileTypeVO vo = (FileTypeVO)BeanMapper.map((Object)((Object)entity), FileTypeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<FileTypeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (FileTypeVO fileTypeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<FileTypeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List fileTypeEntities = this.service.queryList(param);
        List fileTypeVOS = BeanMapper.mapList((Iterable)fileTypeEntities, FileTypeVO.class);
        List parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        for (FileTypeVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(this.getWorkTypeTree(fileTypeVO.getId(), fileTypeVOS));
        }
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)parentWorkType.size());
        pageData.setRecords(parentWorkType);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private List<FileTypeVO> getWorkTypeTree(Long parentNodeId, List<FileTypeVO> records) {
        ArrayList<FileTypeVO> resultList = new ArrayList<FileTypeVO>();
        List childrenList = records.stream().filter(s -> parentNodeId.equals(s.getLastTypeId())).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(childrenList)) {
            for (FileTypeVO child : childrenList) {
                child.setChildren(this.getWorkTypeTree(child.getId(), records));
                resultList.add(child);
            }
        }
        if (ListUtil.isNotEmpty(resultList)) {
            return resultList;
        }
        return null;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("FileType-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refFileTypeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<FileTypeVO>> refFileTypeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        List list;
        List<FileTypeVO> fileTypeVOS;
        List<FileTypeVO> parentWorkType;
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        Parameter orgIdValue = (Parameter)param.getParams().get("orgId");
        Long orgId = orgIdValue == null || orgIdValue.getValue() == null ? InvocationInfoProxy.getOrgId() : Long.valueOf(String.valueOf(orgIdValue.getValue()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).containsKey((Object)"fileTypeId")) {
            param.getParams().put("inner_code", new Parameter("like", (Object)_con.getString("fileTypeId")));
        }
        if (CollectionUtils.isEmpty(parentWorkType = (fileTypeVOS = BeanMapper.mapList((Iterable)(list = this.service.queryList(param, false)), FileTypeVO.class)).stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList()))) {
            parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId().equals(877939990976344129L)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(parentWorkType)) {
            parentWorkType = fileTypeVOS;
        }
        for (FileTypeVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(this.getWorkTypeTree(fileTypeVO.getId(), fileTypeVOS));
        }
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)parentWorkType.size());
        pageData.setRecords(parentWorkType);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryListTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<FileTypeVO>> queryListTree(@RequestParam(required=false) Long id) {
        QueryParam param = new QueryParam();
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("workTypeName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (id != null) {
            param.getParams().put("id", new Parameter("eq", (Object)id));
        }
        List fileTypeEntities = this.service.queryList(param);
        List fileTypeVOS = BeanMapper.mapList((Iterable)fileTypeEntities, FileTypeVO.class);
        List parentWorkType = fileTypeVOS.stream().filter(s -> s.getLastTypeId() == null).collect(Collectors.toList());
        for (FileTypeVO fileTypeVO : parentWorkType) {
            fileTypeVO.setChildren(this.getWorkTypeTree(fileTypeVO.getId(), fileTypeVOS));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", parentWorkType);
    }
}

