package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class PayContractVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    private Integer billState;
    private Long othContractType;


    private String othContractTypeName;
    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 备注
     */
    private String memo;

    /**
     * 付款类型：1-组织付款 2-项目付款
     */
    private Integer payType;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    private Integer payStatus;

    /**
     * 支付金额
     */
    private BigDecimal payMny;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    private Long contractType;
    private String contractTypeName;

    /**
     * 合同编码
     */
    private String contractCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同付款方式
     */
    private String content;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目类型：1-自营，2-联营
     */
    private String projectType;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 支付属性：1-预付款，2-过程款，3-其他
     */
    private Long feeType;

    /**
     * 支付类型
     */
    private Long feeKind;

    /**
     * 支付类型
     */
    private String feeKindName;

    /**
     * 付款事由
     */
    private String payReason;

    /**
     * 收款单位
     */
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    private String receiveUnitName;

    /**
     * 付款单位
     */
    @TableField("pay_unit_id")
    private Long payUnitId;

    /**
     * 付款单位名称
     */
    @TableField("pay_unit_name")
    private String payUnitName;

    /**
     * 合同金额
     */
    private BigDecimal contractMny;

    /**
     * 已结算金额
     */
    private BigDecimal sumSettleMny;

    /**
     * 累计已付
     */
    private BigDecimal sumPayMny;

    /**
     * 已结算未付款金额
     */
    private BigDecimal settledUnPayMny;

    /**
     * 已收票金额
     */
    private BigDecimal sumInvoiceMny;

    /**
     * 申请人
     */
    private Long applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 银行账号
     */
    private String accountNum;

    /**
     * 开户行
     */
    private String accountBank;

    /**
     * 发票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 撤回原因
     */
    private String backReason;

    /**
     * 撤回时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 发票子表
     */
    private List<PayInvoiceVO> invoiceVOList;

    /**
     * 结算单子表
     */
    private List<PayContractSettleVO> settleVOList;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 已支付比例
     */
    private BigDecimal bePayScale;

    /**
     * 截止本期申请比例（按结算）
     */
    private BigDecimal endthisPayScale;

    /**
     * 审批时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 采购类型 1-自采，2-集采
     */
    private String purchaseType;

    /**
     * 是否支出管理
     */
    private boolean manageFlag;

    /**
     * 属于项目:1-是，0-否
     */
    private String dependOnProject;

    /**
     * 项目类型名称
     */
    private String projectTypeName;

    /**
     * 单据状态名称
     */
    private String billStateName;

    /**
     * 支付类型名称
     */
    private String feeTypeName;

    /**
     * 合同版本号
     */
    private Integer contractVersion;

    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private Integer invoiceFlag;


    /**
     * 截止本期申请比例（按合同）
     */
    private BigDecimal endthisPayScaleByContract;

    /**
     * 对甲回款比例
     */
    private BigDecimal collectRatio;

    /**
     * 项目收款总额
     */
    private BigDecimal sumCollectMny;

    /**
     * 累计完成产值
     */
    private BigDecimal sumProductionTaxMny;


    /**
     * 截止上期已申请
     */
    private BigDecimal sumApplyMny;

    /**
     * 申请金额大写
     */
    private String applyMnyCn;
    private BigDecimal waitDeductMny;//据主表选择项目+供应商，查询这个供应商+合项目下所有已生效未被引用过的累计扣款单金额

    /**
     * 申请金额(包含本期扣款)
     */
    private BigDecimal applyHasPenaltyMny;

    public BigDecimal getApplyHasPenaltyMny() {
        return applyHasPenaltyMny;
    }

    public void setApplyHasPenaltyMny(BigDecimal applyHasPenaltyMny) {
        this.applyHasPenaltyMny = applyHasPenaltyMny;
    }

    /**
     *  是否是工人工资：0-否，1-是
     */
    private Integer salaryFlag;
    /**
     * 申请类型
     */
    private Long applyType;
    /**
     * 申请类型名称
     */
    private String applyTypeName;

    /**
     * 累计合同工资
     */
    private BigDecimal sumContractSalary;
    /**
     * 含本期已申请  不入库 有合同劳务工资申请使用
     */
    private BigDecimal endthisSumApplyMny;

    /**
     * 确认收票标识：1-未确认收票，2-已确认
     */
    private Integer receiveInvoiceFlag;

    public Integer getReceiveInvoiceFlag() {
        return receiveInvoiceFlag;
    }

    public void setReceiveInvoiceFlag(Integer receiveInvoiceFlag) {
        this.receiveInvoiceFlag = receiveInvoiceFlag;
    }


    public BigDecimal getEndthisSumApplyMny() {
        return endthisSumApplyMny;
    }

    public void setEndthisSumApplyMny(BigDecimal endthisSumApplyMny) {
        this.endthisSumApplyMny = endthisSumApplyMny;
    }

    private List<PayContractSummaryVO> contractSummaryList = new ArrayList<>();
    private List<PayContractSalaryVO> contractSalaryList = new ArrayList<>();

    /**
     * 有无合同  0-无，1-有
     */
    private String contractFlag;

    /**
     * 付款账户名
     */
    private String payAccountName;

    /**
     * 付款银行账号
     */
    private String payAccountNum;

    /**
     * 付款开户行
     */
    private String payAccountBank;

    /**
     * 关闭前的本期申请金额
     */
    private BigDecimal applyMnyBeforeClose;

    /**
     * 关闭状态
     */
    private String closeState;

    /**
     * 关闭时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date closeTime;

    /**
     * 关闭人
     */
    private String closeUser;


    /**
     * 是否关闭
     */
    private Boolean closeFlag;
    private String projectShortName; // 项目简称

    private String projectCode; // 项目编号

    private Long payWay; // 付款方式
    private String payWayName; // 付款方式名称

    private String psrmReturncode; // 数据中台状态

    private String psrmCode; // 数据中台编码

    private String psrmReturndata; // 数据中台返回数据

    public String getPsrmReturncode() {
        return psrmReturncode;
    }

    public void setPsrmReturncode(String psrmReturncode) {
        this.psrmReturncode = psrmReturncode;
    }

    public String getPsrmCode() {
        return psrmCode;
    }

    public void setPsrmCode(String psrmCode) {
        this.psrmCode = psrmCode;
    }

    public String getPsrmReturndata() {
        return psrmReturndata;
    }

    public void setPsrmReturndata(String psrmReturndata) {
        this.psrmReturndata = psrmReturndata;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayWay() {
        return payWay;
    }

    @ReferDeserialTransfer
    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }

    public String getPayWayName() {
        return payWayName;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }

    public String getProjectShortName() {
        return projectShortName;
    }

    public void setProjectShortName(String projectShortName) {
        this.projectShortName = projectShortName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeKind() {
        return feeKind;
    }
    @ReferDeserialTransfer
    public void setFeeKind(Long feeKind) {
        this.feeKind = feeKind;
    }

    public String getFeeKindName() {
        return feeKindName;
    }

    public void setFeeKindName(String feeKindName) {
        this.feeKindName = feeKindName;
    }

    public Boolean getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Boolean closeFlag) {
        this.closeFlag = closeFlag;
    }


    public BigDecimal getApplyMnyBeforeClose() {
        return applyMnyBeforeClose;
    }

    public void setApplyMnyBeforeClose(BigDecimal applyMnyBeforeClose) {
        this.applyMnyBeforeClose = applyMnyBeforeClose;
    }

    public String getCloseState() {
        return closeState;
    }

    public void setCloseState(String closeState) {
        this.closeState = closeState;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getCloseUser() {
        return closeUser;
    }

    public void setCloseUser(String closeUser) {
        this.closeUser = closeUser;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNum() {
        return payAccountNum;
    }

    public void setPayAccountNum(String payAccountNum) {
        this.payAccountNum = payAccountNum;
    }

    public String getPayAccountBank() {
        return payAccountBank;
    }

    public void setPayAccountBank(String payAccountBank) {
        this.payAccountBank = payAccountBank;
    }

    public String getContractFlag() {
        return contractFlag;
    }

    public void setContractFlag(String contractFlag) {
        this.contractFlag = contractFlag;
    }

    public Integer getSalaryFlag() {
        return salaryFlag;
    }

    public void setSalaryFlag(Integer salaryFlag) {
        this.salaryFlag = salaryFlag;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getApplyType() {
        return applyType;
    }
    @ReferDeserialTransfer
    public void setApplyType(Long applyType) {
        this.applyType = applyType;
    }

    public String getApplyTypeName() {
        return applyTypeName;
    }

    public void setApplyTypeName(String applyTypeName) {
        this.applyTypeName = applyTypeName;
    }

    public BigDecimal getSumContractSalary() {
        return sumContractSalary;
    }

    public void setSumContractSalary(BigDecimal sumContractSalary) {
        this.sumContractSalary = sumContractSalary;
    }

    public List<PayContractSummaryVO> getContractSummaryList() {
        return contractSummaryList;
    }

    public void setContractSummaryList(List<PayContractSummaryVO> contractSummaryList) {
        this.contractSummaryList = contractSummaryList;
    }

    public List<PayContractSalaryVO> getContractSalaryList() {
        return contractSalaryList;
    }

    public void setContractSalaryList(List<PayContractSalaryVO> contractSalaryList) {
        this.contractSalaryList = contractSalaryList;
    }

    private List<PayRecordVO> recordList = new ArrayList<>(); // 付款申请记录实体

    private ProjectFinanceVO projectFinanceVO = new ProjectFinanceVO();

    /**
     * 是否需要发票
     */
    private String invoiceFlagName;

    public String getInvoiceFlagName() {
        if (this.invoiceFlag == null) {
            return null;
        } else if (this.invoiceFlag == 1) {
            return "有";
        } else if (this.invoiceFlag == 2) {
            return "没有";
        } else if (this.invoiceFlag == 3) {
            return "不确定";
        }
        return null;
    }

    public void setInvoiceFlagName(String invoiceFlagName) {
        this.invoiceFlagName = invoiceFlagName;
    }

    /**
     *************start************************项目资金改造***************************start*******************************
     */

    private java.math.BigDecimal proContractMny; // 收入合同金额
    private java.math.BigDecimal proOutputMny; // 完成产值
    private java.math.BigDecimal proDateProgress; // 日期进度
    private java.math.BigDecimal proOutputProgress; // 产值进度
    private java.math.BigDecimal proContractReceiveMny; // 合同累计收款金额
    private java.math.BigDecimal proReceiveMny; // 累计收款
    private java.math.BigDecimal proPayMny; // 累计付款
    private java.math.BigDecimal proCostListSurplus; // 费用清单结余
    private java.math.BigDecimal proTransferSurplus; // 项目代转款款结余
    private java.math.BigDecimal proRiskMarginSurplus; // 风险保证金结余
    private java.math.BigDecimal proLoanBalance; // 借款结余
    private java.math.BigDecimal proLoanInterest; // 借款利息
    private java.math.BigDecimal proOtherFeeDeduct; // 其他费用扣除
    private java.math.BigDecimal proOtherFeeBack; // 其他费用退还
    private java.math.BigDecimal proSurplusMny; // 项目可用资金
    private java.math.BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    private java.math.BigDecimal proPettyCash; // 备用金结余
    private java.math.BigDecimal proManageScale; // 管理费比例
    private java.math.BigDecimal proManageFee; // 管理费
    private java.math.BigDecimal proAmerce; // 罚款
    private java.math.BigDecimal proApplyUnpayMny; // 已申请未支付金额

    private java.math.BigDecimal unpaidMny; // 未付金额
    private BigDecimal totalApplyMny;//累计已申请金额

    /**
     * 支付金额
     */
    private String payMnyCn;

    /**
     * 剩余申请金额
     */
    private BigDecimal sumSurplusApplyMny;

    public BigDecimal getSumSurplusApplyMny() {
        return sumSurplusApplyMny;
    }

    public void setSumSurplusApplyMny(BigDecimal sumSurplusApplyMny) {
        this.sumSurplusApplyMny = sumSurplusApplyMny;
    }


    public String getPayMnyCn() {
        return payMnyCn;
    }

    public void setPayMnyCn(String payMnyCn) {
        this.payMnyCn = payMnyCn;
    }

    public BigDecimal getUnpaidMny() {
        return unpaidMny;
    }

    public void setUnpaidMny(BigDecimal unpaidMny) {
        this.unpaidMny = unpaidMny;
    }

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }

    public ProjectFinanceVO getProjectFinanceVO() {
        return projectFinanceVO;
    }

    public void setProjectFinanceVO(ProjectFinanceVO projectFinanceVO) {
        this.projectFinanceVO = projectFinanceVO;
    }

    /**
     *************end************************项目资金改造***************************end*******************************
     */


    private Long contractStageId; // 合同付款阶段id
    private BigDecimal contractStageScale; // 合同付款阶段比例
    private String contractStageName; // 合同付款阶段名称
    private BigDecimal curPenaltyMoney; // 本期扣款金额合计
    private BigDecimal curSettleMoney; // 本期结算金额合计
    private BigDecimal curContractPayMoney; // 本期合同应付金额合计


    private List<PayContractDeductionVO> deductionVOList;

    /**
     * 世纪阳光字段 付款类型 1-保温，2-饰面，3-自有劳务 *****************************************
     */
    private Integer paymentType;

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    /**
     * 世纪阳光字段 付款类型 end ****************************************************************
     */

    private String incomeCode; // 施工合同编号

    /**
     * 合同类型扩展：0-劳务分包,1-专业分包,2-设备采购,3-设备租赁,4-物资采购,5-周转材租赁,6-其他支出合同
     */
    private Integer contractTypeExtend;

    //2025.8.5新增
    private String customerName; // 甲方

    public Integer getContractTypeExtend() {
        return contractTypeExtend;
    }

    public void setContractTypeExtend(Integer contractTypeExtend) {
        this.contractTypeExtend = contractTypeExtend;
    }

    public String getIncomeCode() {
        return incomeCode;
    }

    public void setIncomeCode(String incomeCode) {
        this.incomeCode = incomeCode;
    }

    public List<PayContractDeductionVO> getDeductionVOList() {
        return deductionVOList;
    }

    public void setDeductionVOList(List<PayContractDeductionVO> deductionVOList) {
        this.deductionVOList = deductionVOList;
    }

    public Long getContractStageId() {
        return contractStageId;
    }

    public void setContractStageId(Long contractStageId) {
        this.contractStageId = contractStageId;
    }

    public BigDecimal getContractStageScale() {
        return contractStageScale;
    }

    public void setContractStageScale(BigDecimal contractStageScale) {
        this.contractStageScale = contractStageScale;
    }

    public String getContractStageName() {
        return contractStageName;
    }

    public void setContractStageName(String contractStageName) {
        this.contractStageName = contractStageName;
    }

    public BigDecimal getCurPenaltyMoney() {
        return curPenaltyMoney;
    }

    public void setCurPenaltyMoney(BigDecimal curPenaltyMoney) {
        this.curPenaltyMoney = curPenaltyMoney;
    }

    public BigDecimal getCurSettleMoney() {
        return curSettleMoney;
    }

    public void setCurSettleMoney(BigDecimal curSettleMoney) {
        this.curSettleMoney = curSettleMoney;
    }

    public BigDecimal getCurContractPayMoney() {
        return curContractPayMoney;
    }

    public void setCurContractPayMoney(BigDecimal curContractPayMoney) {
        this.curContractPayMoney = curContractPayMoney;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getOthContractType() {
        return othContractType;
    }
    @ReferDeserialTransfer
    public void setOthContractType(Long othContractType) {
        this.othContractType = othContractType;
    }

    public String getOthContractTypeName() {
        return othContractTypeName;
    }

    public void setOthContractTypeName(String othContractTypeName) {
        this.othContractTypeName = othContractTypeName;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }


    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }


    public BigDecimal getEndthisPayScaleByContract() {
        return endthisPayScaleByContract;
    }

    public void setEndthisPayScaleByContract(BigDecimal endthisPayScaleByContract) {
        this.endthisPayScaleByContract = endthisPayScaleByContract;
    }

    public BigDecimal getCollectRatio() {
        return collectRatio;
    }

    public void setCollectRatio(BigDecimal collectRatio) {
        this.collectRatio = collectRatio;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }

    public List<PayRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<PayRecordVO> recordList) {
        this.recordList = recordList;
    }

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public boolean getManageFlag() {
        return manageFlag;
    }

    public void setManageFlag(boolean manageFlag) {
        this.manageFlag = manageFlag;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public BigDecimal getBePayScale() {
        return bePayScale;
    }

    public void setBePayScale(BigDecimal bePayScale) {
        this.bePayScale = bePayScale;
    }

    public BigDecimal getEndthisPayScale() {
        return endthisPayScale;
    }

    public void setEndthisPayScale(BigDecimal endthisPayScale) {
        this.endthisPayScale = endthisPayScale;
    }

    public List<PayInvoiceVO> getInvoiceVOList() {
        return invoiceVOList;
    }

    public void setInvoiceVOList(List<PayInvoiceVO> invoiceVOList) {
        this.invoiceVOList = invoiceVOList;
    }

    public List<PayContractSettleVO> getSettleVOList() {
        return settleVOList;
    }

    public void setSettleVOList(List<PayContractSettleVO> settleVOList) {
        this.settleVOList = settleVOList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public Long getContractId() {
        return contractId;
    }
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    @ReferDeserialTransfer
    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayUnitId() {
        return payUnitId;
    }

    @ReferDeserialTransfer
    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSettledUnPayMny() {
        sumSettleMny = sumSettleMny == null ? BigDecimal.ZERO : sumSettleMny;
        sumPayMny = sumPayMny == null ? BigDecimal.ZERO : sumPayMny;
        settledUnPayMny = sumSettleMny.subtract(sumPayMny).setScale(2, RoundingMode.HALF_UP);
        return settledUnPayMny;
    }

    public void setSettledUnPayMny(BigDecimal settledUnPayMny) {
        this.settledUnPayMny = settledUnPayMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public BigDecimal getWaitDeductMny() {
        return waitDeductMny;
    }

    public void setWaitDeductMny(BigDecimal waitDeductMny) {
        this.waitDeductMny = waitDeductMny;
    }
    public BigDecimal getTotalApplyMny() {
        return totalApplyMny;
    }

    public void setTotalApplyMny(BigDecimal totalApplyMny) {
        this.totalApplyMny = totalApplyMny;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    // 劳务分包付款信息
    private Long applicantId; //申请人id
    private String applicantName; // 申请人名称
    private Long projectDirector; // 项目总监Id
    private String projectDirectorName; // 项目总监名称
    private Long deputyBossId; //分管副总id
    private String deputyBossName; // 分管副总名称
    private BigDecimal paymentAdjust; // 付款比例修正
    private Long subIncomeId; // 施工合同id-劳务
    private String subIncomeCode; // 施工合同编号-劳务
    private String subIncomeName;// 施工合同名称-劳务
    private BigDecimal subContractRatio; // 合同约定付款比例-劳务
    private String isAdjusted; // 是否调整合同约定付款比例
    private BigDecimal paidAmount; //累计已付金额
    private BigDecimal subInvoicedAmount; // 已收票金额
    private String subApplyDateSpan ; // 申请请款日期区间
    private BigDecimal subToDeductAmt; // 待扣款金额-劳务
    private BigDecimal subClaimAmount; // 本次申报金额-劳务
    private BigDecimal subSettleAmount; // 结算金额-劳务
    private BigDecimal subDeductAmount; // 本次扣款金额-劳务
    private BigDecimal subProjectApprovalAmt; // 本次项目部批复金额-劳务
    private BigDecimal subVisaApprovedAmt; // 已审核签证总金额-劳务
    private BigDecimal subWorkerSalaryAmt; // 本次审批支付分包单位工人工资总金额
    private BigDecimal subBossSalaryAmt; // 本次审批支付分包/老板金额
    private BigDecimal subProgressRatio; // 本次请款该班组完成总进度比例
    private BigDecimal subProgressRatioTotal;// 本次请款该班组累计完成总进度比例
    private BigDecimal subWorkerSalaryAmtSum; // 累计已支付分包单位工人工资总金额
    private BigDecimal subBossSalaryAmtSum; // 累计已支付分包/老板金额
    private BigDecimal subRemainAmount; // 截止本次请款合同剩余金额
    private BigDecimal subActualAmount; // 实发工资金额（特安部统计成本专用）

    // 工程中心批款
    private BigDecimal subApprovedAmount;// 本次批款金额（合同额*累计完成总进度比例-前期累计已批金额）
    private BigDecimal subApprovedAmountAdjust;// 批款金额修正
    private BigDecimal subHoldAmount; // 本次暂压金额
    private String subHoldReason; // 本次暂压原因备注

    // 工程中心排款
    private String subUseSalaryAccount; // 本次是否使用工资户支付
    private String subWageAccount; // 选择本次支付的工资户
    private BigDecimal subWageAccountAmount; // 本次工资户支付金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subWagePayTime; // 工资支付排期
    private BigDecimal subJointAcctAmount; //本次支付共管户金额
    private String subPayWay; // 支付方式
    private BigDecimal subBasicAcctAmount; // 本次支付基本户金额
    private String subBasicAcctPayWay; // 支付方式
    private Integer subWagePersonCount; // 本次支付工资人数
    private String subWageDateSpan ; // 本次支付工资日期区间
    private BigDecimal subPayBwhrAmount; // 本次支付班王/宏瑞金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subBasicAcctPayTime; // 基本户支付排期

    // 收款账号信息（小C）-分包
    private String subAccountName; // 账户名
    private String subAccountNum;//基本户银行卡号
    private String subAccountBank; // 开户行
    private String subIdCard; // 身份证号
    private String subPhone; // 电话号码

    // 新增补充字段
    private String jointAccountName; // 共管账户名称
    private String jointAccountNum; // 共管账户银行账号
    private String jointAccountBank; // 共管账户开户行
    private String basicAccountName; // 基本账户名称
    private String basicAccountNum; // 基本账户银行账号
    private String basicAccountBank; // 基本账户开户行
    private BigDecimal subPayBwhrWageAmount; // 本次班王/宏瑞支付工资金额
    private BigDecimal subPayBwhrBossAmount; // 本次班王/宏瑞支付老板金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date subPayBossPayTime;  // 支付小C老板金额排期
    private BigDecimal totalApprovedAmount; // 本次累计批款金额

    // 关联项目责任分工表数据
    private Long projectManagerId; // 项目经理id
    private String projectManagerName; // 项目经理name
    private Long laborSupervisorId; // 劳务区域主管id
    private String laborSupervisorName; // 劳务区域主管name

    // 基本信息
    private String subReceiveUnitName; // 收款单位名称-分包

    // 收料入库信息
    private BigDecimal totalCount; // 入库数量
    private BigDecimal totalAmount; // 入库金额含税

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplicantId() {
        return applicantId;
    }
    @ReferDeserialTransfer
    public void setApplicantId(Long applicantId) {
        this.applicantId = applicantId;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectDirector() {
        return projectDirector;
    }
    @ReferDeserialTransfer
    public void setProjectDirector(Long projectDirector) {
        this.projectDirector = projectDirector;
    }

    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDeputyBossId() {
        return deputyBossId;
    }
    @ReferDeserialTransfer
    public void setDeputyBossId(Long deputyBossId) {
        this.deputyBossId = deputyBossId;
    }

    public String getDeputyBossName() {
        return deputyBossName;
    }

    public void setDeputyBossName(String deputyBossName) {
        this.deputyBossName = deputyBossName;
    }

    public BigDecimal getPaymentAdjust() {
        return paymentAdjust;
    }

    public void setPaymentAdjust(BigDecimal paymentAdjust) {
        this.paymentAdjust = paymentAdjust;
    }

    public Long getSubIncomeId() {
        return subIncomeId;
    }

    public void setSubIncomeId(Long subIncomeId) {
        this.subIncomeId = subIncomeId;
    }

    public String getSubIncomeCode() {
        return subIncomeCode;
    }

    public void setSubIncomeCode(String subIncomeCode) {
        this.subIncomeCode = subIncomeCode;
    }

    public String getSubIncomeName() {
        return subIncomeName;
    }

    public void setSubIncomeName(String subIncomeName) {
        this.subIncomeName = subIncomeName;
    }

    public BigDecimal getSubContractRatio() {
        return subContractRatio;
    }

    public void setSubContractRatio(BigDecimal subContractRatio) {
        this.subContractRatio = subContractRatio;
    }

    public BigDecimal getSubInvoicedAmount() {
        return subInvoicedAmount;
    }

    public void setSubInvoicedAmount(BigDecimal subInvoicedAmount) {
        this.subInvoicedAmount = subInvoicedAmount;
    }

    public BigDecimal getSubToDeductAmt() {
        return subToDeductAmt;
    }

    public void setSubToDeductAmt(BigDecimal subToDeductAmt) {
        this.subToDeductAmt = subToDeductAmt;
    }

    public BigDecimal getSubClaimAmount() {
        return subClaimAmount;
    }

    public void setSubClaimAmount(BigDecimal subClaimAmount) {
        this.subClaimAmount = subClaimAmount;
    }

    public BigDecimal getSubSettleAmount() {
        return subSettleAmount;
    }

    public void setSubSettleAmount(BigDecimal subSettleAmount) {
        this.subSettleAmount = subSettleAmount;
    }

    public BigDecimal getSubDeductAmount() {
        return subDeductAmount;
    }

    public void setSubDeductAmount(BigDecimal subDeductAmount) {
        this.subDeductAmount = subDeductAmount;
    }

    public BigDecimal getSubProjectApprovalAmt() {
        return subProjectApprovalAmt;
    }

    public void setSubProjectApprovalAmt(BigDecimal subProjectApprovalAmt) {
        this.subProjectApprovalAmt = subProjectApprovalAmt;
    }

    public BigDecimal getSubVisaApprovedAmt() {
        return subVisaApprovedAmt;
    }

    public void setSubVisaApprovedAmt(BigDecimal subVisaApprovedAmt) {
        this.subVisaApprovedAmt = subVisaApprovedAmt;
    }

    public BigDecimal getSubWorkerSalaryAmt() {
        return subWorkerSalaryAmt;
    }

    public void setSubWorkerSalaryAmt(BigDecimal subWorkerSalaryAmt) {
        this.subWorkerSalaryAmt = subWorkerSalaryAmt;
    }

    public BigDecimal getSubBossSalaryAmt() {
        return subBossSalaryAmt;
    }

    public void setSubBossSalaryAmt(BigDecimal subBossSalaryAmt) {
        this.subBossSalaryAmt = subBossSalaryAmt;
    }

    public BigDecimal getSubProgressRatio() {
        return subProgressRatio;
    }

    public void setSubProgressRatio(BigDecimal subProgressRatio) {
        this.subProgressRatio = subProgressRatio;
    }

    public BigDecimal getSubProgressRatioTotal() {
        return subProgressRatioTotal;
    }

    public void setSubProgressRatioTotal(BigDecimal subProgressRatioTotal) {
        this.subProgressRatioTotal = subProgressRatioTotal;
    }

    public BigDecimal getSubApprovedAmount() {
        return subApprovedAmount;
    }

    public void setSubApprovedAmount(BigDecimal subApprovedAmount) {
        this.subApprovedAmount = subApprovedAmount;
    }

    public BigDecimal getSubApprovedAmountAdjust() {
        return subApprovedAmountAdjust;
    }

    public void setSubApprovedAmountAdjust(BigDecimal subApprovedAmountAdjust) {
        this.subApprovedAmountAdjust = subApprovedAmountAdjust;
    }

    public BigDecimal getSubHoldAmount() {
        return subHoldAmount;
    }

    public void setSubHoldAmount(BigDecimal subHoldAmount) {
        this.subHoldAmount = subHoldAmount;
    }

    public String getSubHoldReason() {
        return subHoldReason;
    }

    public void setSubHoldReason(String subHoldReason) {
        this.subHoldReason = subHoldReason;
    }

    public String getSubUseSalaryAccount() {
        return subUseSalaryAccount;
    }

    public void setSubUseSalaryAccount(String subUseSalaryAccount) {
        this.subUseSalaryAccount = subUseSalaryAccount;
    }

    public String getSubWageAccount() {
        return subWageAccount;
    }

    public void setSubWageAccount(String subWageAccount) {
        this.subWageAccount = subWageAccount;
    }

    public BigDecimal getSubWageAccountAmount() {
        return subWageAccountAmount;
    }

    public void setSubWageAccountAmount(BigDecimal subWageAccountAmount) {
        this.subWageAccountAmount = subWageAccountAmount;
    }

    public Date getSubWagePayTime() {
        return subWagePayTime;
    }

    public void setSubWagePayTime(Date subWagePayTime) {
        this.subWagePayTime = subWagePayTime;
    }

    public BigDecimal getSubJointAcctAmount() {
        return subJointAcctAmount;
    }

    public void setSubJointAcctAmount(BigDecimal subJointAcctAmount) {
        this.subJointAcctAmount = subJointAcctAmount;
    }

    public String getSubPayWay() {
        return subPayWay;
    }

    public void setSubPayWay(String subPayWay) {
        this.subPayWay = subPayWay;
    }

    public BigDecimal getSubBasicAcctAmount() {
        return subBasicAcctAmount;
    }

    public void setSubBasicAcctAmount(BigDecimal subBasicAcctAmount) {
        this.subBasicAcctAmount = subBasicAcctAmount;
    }

    public String getSubBasicAcctPayWay() {
        return subBasicAcctPayWay;
    }

    public void setSubBasicAcctPayWay(String subBasicAcctPayWay) {
        this.subBasicAcctPayWay = subBasicAcctPayWay;
    }

    public Integer getSubWagePersonCount() {
        return subWagePersonCount;
    }

    public void setSubWagePersonCount(Integer subWagePersonCount) {
        this.subWagePersonCount = subWagePersonCount;
    }

    public BigDecimal getSubPayBwhrAmount() {
        return subPayBwhrAmount;
    }

    public void setSubPayBwhrAmount(BigDecimal subPayBwhrAmount) {
        this.subPayBwhrAmount = subPayBwhrAmount;
    }

    public Date getSubBasicAcctPayTime() {
        return subBasicAcctPayTime;
    }

    public void setSubBasicAcctPayTime(Date subBasicAcctPayTime) {
        this.subBasicAcctPayTime = subBasicAcctPayTime;
    }

    public String getSubAccountName() {
        return subAccountName;
    }

    public void setSubAccountName(String subAccountName) {
        this.subAccountName = subAccountName;
    }

    public String getSubAccountNum() {
        return subAccountNum;
    }

    public void setSubAccountNum(String subAccountNum) {
        this.subAccountNum = subAccountNum;
    }

    public String getSubAccountBank() {
        return subAccountBank;
    }

    public void setSubAccountBank(String subAccountBank) {
        this.subAccountBank = subAccountBank;
    }

    public String getSubIdCard() {
        return subIdCard;
    }

    public void setSubIdCard(String subIdCard) {
        this.subIdCard = subIdCard;
    }

    public String getSubPhone() {
        return subPhone;
    }

    public void setSubPhone(String subPhone) {
        this.subPhone = subPhone;
    }

    public String getSubApplyDateSpan() {
        return subApplyDateSpan;
    }

    public void setSubApplyDateSpan(String subApplyDateSpan) {
        this.subApplyDateSpan = subApplyDateSpan;
    }

    public String getSubWageDateSpan() {
        return subWageDateSpan;
    }

    public void setSubWageDateSpan(String subWageDateSpan) {
        this.subWageDateSpan = subWageDateSpan;
    }

    public String getJointAccountName() {
        return jointAccountName;
    }

    public void setJointAccountName(String jointAccountName) {
        this.jointAccountName = jointAccountName;
    }

    public String getJointAccountNum() {
        return jointAccountNum;
    }

    public void setJointAccountNum(String jointAccountNum) {
        this.jointAccountNum = jointAccountNum;
    }

    public String getJointAccountBank() {
        return jointAccountBank;
    }

    public void setJointAccountBank(String jointAccountBank) {
        this.jointAccountBank = jointAccountBank;
    }

    public String getBasicAccountName() {
        return basicAccountName;
    }

    public void setBasicAccountName(String basicAccountName) {
        this.basicAccountName = basicAccountName;
    }

    public String getBasicAccountNum() {
        return basicAccountNum;
    }

    public void setBasicAccountNum(String basicAccountNum) {
        this.basicAccountNum = basicAccountNum;
    }

    public String getBasicAccountBank() {
        return basicAccountBank;
    }

    public void setBasicAccountBank(String basicAccountBank) {
        this.basicAccountBank = basicAccountBank;
    }

    public BigDecimal getSubPayBwhrWageAmount() {
        return subPayBwhrWageAmount;
    }

    public void setSubPayBwhrWageAmount(BigDecimal subPayBwhrWageAmount) {
        this.subPayBwhrWageAmount = subPayBwhrWageAmount;
    }

    public BigDecimal getSubPayBwhrBossAmount() {
        return subPayBwhrBossAmount;
    }

    public void setSubPayBwhrBossAmount(BigDecimal subPayBwhrBossAmount) {
        this.subPayBwhrBossAmount = subPayBwhrBossAmount;
    }

    public Date getSubPayBossPayTime() {
        return subPayBossPayTime;
    }

    public void setSubPayBossPayTime(Date subPayBossPayTime) {
        this.subPayBossPayTime = subPayBossPayTime;
    }

    public BigDecimal getTotalApprovedAmount() {
        return totalApprovedAmount;
    }

    public void setTotalApprovedAmount(BigDecimal totalApprovedAmount) {
        this.totalApprovedAmount = totalApprovedAmount;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectManagerId() {
        return projectManagerId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getLaborSupervisorId() {
        return laborSupervisorId;
    }

    @ReferDeserialTransfer
    public void setLaborSupervisorId(Long laborSupervisorId) {
        this.laborSupervisorId = laborSupervisorId;
    }

    public String getLaborSupervisorName() {
        return laborSupervisorName;
    }

    public void setLaborSupervisorName(String laborSupervisorName) {
        this.laborSupervisorName = laborSupervisorName;
    }

    public String getIsAdjusted() {
        return isAdjusted;
    }

    public void setIsAdjusted(String isAdjusted) {
        this.isAdjusted = isAdjusted;
    }

    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public BigDecimal getSubWorkerSalaryAmtSum() {
        return subWorkerSalaryAmtSum;
    }

    public void setSubWorkerSalaryAmtSum(BigDecimal subWorkerSalaryAmtSum) {
        this.subWorkerSalaryAmtSum = subWorkerSalaryAmtSum;
    }

    public BigDecimal getSubBossSalaryAmtSum() {
        return subBossSalaryAmtSum;
    }

    public void setSubBossSalaryAmtSum(BigDecimal subBossSalaryAmtSum) {
        this.subBossSalaryAmtSum = subBossSalaryAmtSum;
    }

    public BigDecimal getSubRemainAmount() {
        return subRemainAmount;
    }

    public void setSubRemainAmount(BigDecimal subRemainAmount) {
        this.subRemainAmount = subRemainAmount;
    }

    public String getSubReceiveUnitName() {
        return subReceiveUnitName;
    }

    public void setSubReceiveUnitName(String subReceiveUnitName) {
        this.subReceiveUnitName = subReceiveUnitName;
    }

    public BigDecimal getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(BigDecimal totalCount) {
        this.totalCount = totalCount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getSubActualAmount() {
        return subActualAmount;
    }

    public void setSubActualAmount(BigDecimal subActualAmount) {
        this.subActualAmount = subActualAmount;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
}
