package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 投标保证金统计
 * </p>
 */
public class BidBondReportVO extends BaseVO {
    /**
     * 申请金额
     */
    private BigDecimal upApplyMny = BigDecimal.ZERO;

    /**
     * 已支付金额
     */
    private BigDecimal upPayMny = BigDecimal.ZERO;

    /**
     * 已退还金额
     */
    private BigDecimal upBackMny = BigDecimal.ZERO;

    /**
     * 到期未还
     */
    private BigDecimal upUnPayMny = BigDecimal.ZERO;

    /**
     * 期限结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BigDecimal getUpApplyMny() {
        return upApplyMny;
    }

    public void setUpApplyMny(BigDecimal upApplyMny) {
        this.upApplyMny = upApplyMny;
    }

    public BigDecimal getUpPayMny() {
        return upPayMny;
    }

    public void setUpPayMny(BigDecimal upPayMny) {
        this.upPayMny = upPayMny;
    }

    public BigDecimal getUpBackMny() {
        return upBackMny;
    }

    public void setUpBackMny(BigDecimal upBackMny) {
        this.upBackMny = upBackMny;
    }

    public BigDecimal getUpUnPayMny() {
        return upUnPayMny;
    }

    public void setUpUnPayMny(BigDecimal upUnPayMny) {
        this.upUnPayMny = upUnPayMny;
    }

}
