package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 管理费明细
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class ManageDetailVO {

    private static final long serialVersionUID = 1L;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 已收金额
     */
    private BigDecimal sumReceiveMny;

    /**
     * 已收金额(收入类型：工程合同收款)
     */
    private BigDecimal sumContractReceiveMny;

    /**
     * 管理费比例
     */
    private BigDecimal manageFeeRate;

    /**
     * 管理费
     */
    private BigDecimal manageFee;

    /**
     * 已支付金额
     */
    private BigDecimal sumPayMny;

    /**
     * 剩余可支付金额
     */
    private BigDecimal surplusPayMny;

    public BigDecimal getSumContractReceiveMny() {
        return sumContractReceiveMny;
    }

    public void setSumContractReceiveMny(BigDecimal sumContractReceiveMny) {
        this.sumContractReceiveMny = sumContractReceiveMny;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public BigDecimal getSumReceiveMny() {
        return sumReceiveMny;
    }

    public void setSumReceiveMny(BigDecimal sumReceiveMny) {
        this.sumReceiveMny = sumReceiveMny;
    }

    public BigDecimal getManageFeeRate() {
        return manageFeeRate;
    }

    public void setManageFeeRate(BigDecimal manageFeeRate) {
        this.manageFeeRate = manageFeeRate;
    }

    public BigDecimal getManageFee() {
        return manageFee;
    }

    public void setManageFee(BigDecimal manageFee) {
        this.manageFee = manageFee;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSurplusPayMny() {
        return surplusPayMny;
    }

    public void setSurplusPayMny(BigDecimal surplusPayMny) {
        this.surplusPayMny = surplusPayMny;
    }
}
