package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * 借款申请
 *
 * @author generator
 *
 */
public class LoadApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.Long projectId; // 项目
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 组织
    private java.lang.String orgName; // 组织名称
    private java.lang.String billCode; // 申请编号
    private java.lang.String memo; // 申请事由
    private java.math.BigDecimal applyMny; // 申请金额
    private java.math.BigDecimal unpaidMny; // 未付金额
    private java.math.BigDecimal surplusMny; // 剩余借款
    private java.lang.Long applyEmployeeId; // 申请人
    private java.lang.String applyEmployeeName; // 申请人名称
    private java.lang.Long deptId; // 费用承担部门
    private java.lang.String deptName; // 费用承担部门
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date applyTime; // 申请时间
    private java.lang.String accountName; // 账户名
    private java.lang.String bankAccount; // 银行账号
    private java.lang.String bankName; // 开户行
    private java.lang.Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date useTime; // 用款时间
    private java.lang.Integer payType; // 付款类型：1-组织付款 2-项目付款
    private java.lang.Integer payStatus; // 支付状态：1-未支付 2-已支付
    private java.math.BigDecimal payMny; // 支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date approveTime; // 审批时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date confirmTime; // 支付时间
    private List<PayRecordVO> recordList = new ArrayList<>(); // 付款申请记录实体
    /**
     * 是否属于项目
     */
    private String dependOnProject;

    private String billStateName;

    private java.math.BigDecimal reimburseMny; // 报销金额

    private java.math.BigDecimal backMny; // 退还金额

    private java.math.BigDecimal sumPenaltyMoney; // 扣款单金额
    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private String invoiceFlag;


    private Long receiveWay;//收款方式
    private String receiveWayName;//收款方式名称

    private Long feeType;
    private String feeTypeName;

    /**
     * 是否需要发票
     */
    private String invoiceFlagName;


    private String orgCode; // 组织编码

    /**
     *************start************************项目资金改造***************************start*******************************
     */

    private ProjectFinanceVO projectFinanceVO = new ProjectFinanceVO();

    private BigDecimal proContractMny; // 收入合同金额
    private BigDecimal proOutputMny; // 完成产值
    private BigDecimal proDateProgress; // 日期进度
    private BigDecimal proOutputProgress; // 产值进度
    private BigDecimal proContractReceiveMny; // 合同累计收款金额
    private BigDecimal proReceiveMny; // 累计收款
    private BigDecimal proPayMny; // 累计付款
    private BigDecimal proCostListSurplus; // 费用清单结余
    private BigDecimal proTransferSurplus; // 项目代转款款结余
    private BigDecimal proRiskMarginSurplus; // 风险保证金结余
    private BigDecimal proLoanBalance; // 借款结余
    private BigDecimal proLoanInterest; // 借款利息
    private BigDecimal proOtherFeeDeduct; // 其他费用扣除
    private BigDecimal proOtherFeeBack; // 其他费用退还
    private BigDecimal proSurplusMny; // 项目可用资金
    private BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    private BigDecimal proPettyCash; // 备用金结余
    private BigDecimal proManageScale; // 管理费比例
    private BigDecimal proManageFee; // 管理费
    private BigDecimal proAmerce; // 罚款
    private BigDecimal proApplyUnpayMny; // 已申请未支付金额

    /**
     * 确认收票标识：1-未确认收票，2-已确认
     */
    private Integer receiveInvoiceFlag;

    public Integer getReceiveInvoiceFlag() {
        return receiveInvoiceFlag;
    }

    public void setReceiveInvoiceFlag(Integer receiveInvoiceFlag) {
        this.receiveInvoiceFlag = receiveInvoiceFlag;
    }

    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public ProjectFinanceVO getProjectFinanceVO() {
        return projectFinanceVO;
    }

    public void setProjectFinanceVO(ProjectFinanceVO projectFinanceVO) {
        this.projectFinanceVO = projectFinanceVO;
    }

    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getUnpaidMny() {
        return unpaidMny;
    }

    public void setUnpaidMny(BigDecimal unpaidMny) {
        this.unpaidMny = unpaidMny;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public List<PayRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<PayRecordVO> recordList) {
        this.recordList = recordList;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public String getInvoiceFlagName() {
        if (this.invoiceFlag == null) {
            return null;
        } else if ("1".equals(this.invoiceFlag)) {
            return "有";
        } else if ("2".equals(this.invoiceFlag)) {
            return "没有";
        } else if ("3".equals(this.invoiceFlag)) {
            return "不确定";
        }
        return null;
    }

    public void setInvoiceFlagName(String invoiceFlagName) {
        this.invoiceFlagName = invoiceFlagName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    public Date getUseTime() {
        return useTime;
    }

    public void setUseTime(Date useTime) {
        this.useTime = useTime;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getProjectName() {
        return projectName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getReceiveWay() {
        return receiveWay;
    }
    @ReferDeserialTransfer
    public void setReceiveWay(Long receiveWay) {
        this.receiveWay = receiveWay;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getFeeType() {
        return feeType;
    }
    @ReferDeserialTransfer
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public String getReceiveWayName() {
        return receiveWayName;
    }

    public void setReceiveWayName(String receiveWayName) {
        this.receiveWayName = receiveWayName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }
    @ReferDeserialTransfer
    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }

    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getReimburseMny() {
        return reimburseMny;
    }

    public void setReimburseMny(BigDecimal reimburseMny) {
        this.reimburseMny = reimburseMny;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getSumPenaltyMoney() {
        return sumPenaltyMoney;
    }

    public void setSumPenaltyMoney(BigDecimal sumPenaltyMoney) {
        this.sumPenaltyMoney = sumPenaltyMoney;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }
}
