package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 劳务结算资料接收单主表
 * 
 * @author generator
 * 
 */
public class LaborSettlementPmReviewVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织id
    private String parentOrgName; // 上级组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办部门
    private String departmentName; // 经办部门名称
    private String memo; // 备注
    private Integer billState; // 单据状态
    private String hasScopeChange; // 是否存在施工范围的变化
    private String hasPendingItems; // 是否有施工甩尾项
    private String isMaterialSupplyAsPerContract; // 材料供应情况是否与合同一致、工人保险、罚款缴纳及质量整改情况
    private String finalQualityRectificationRate; // 该项目最终质量整改率多少（项目部填写，质安部确认）
    private String hasRectificationRatePenaltyClause; // 该班组在合同中是否承诺：未达到约定整改率则结算下浮（项目经理确认，商务部、成本中心复核）
    private BigDecimal laborDeductionAndInsuranceAmount; // 班组扣款及保险代买金额（工程安全劳务专业组填写）
    private String laborDeductionReason; // 扣款事由（工程安全劳务专业组填写）
    private Long supplierId; // 分包单位id
    private String supplierName; // 分包单位名称
    private BigDecimal qaDeductionAmount; // 质量安全部披露质量安全扣款（质量安全部填写）
    private String qaDeductionReason; // 扣款事由（质量安全部填写）
    private BigDecimal overissueDeductionAmount; // 超领料扣款金额（物料组填写）
    private String overissueDeductionReason; // 扣款事由(物料组填写)
    private BigDecimal procurementDeductionAmount; // 材料代付或其它材料扣款金额（采购部填写）
    private String procurementDeductionReason; // 扣款事由（采购部填写）
    private BigDecimal financeDeductionAmount; // 财务部复核扣款（财务部填写）
    private String financeDeductionReason; // 扣款事由（财务部填写）
    private String jslx; // 结算类型
    private String lwjszl01; // 劳务结算资料接收单内容
    private Integer lwjszl02; // 劳务结算资料接收单份数
    private String lwjszl03; // 劳务结算资料接收单资料形式
    private String lwjszl04; // 劳务结算资料接收单要求
    private BigDecimal lwjszl05; // 劳务结算资料接收单报送金额
    private String lwjszl06; // 劳务结算资料接收单备注
    private String jssfm01; // 结算书封面内容
    private Integer jssfm02; // 结算书封面份数
    private String jssfm03; // 结算书封面资料形式
    private String jssfm04; // 结算书封面要求
    private BigDecimal jssfm05; // 结算书封面报送金额
    private String jssfm06; // 结算书封面备注
    private String jscns01; // 结算承诺书内容
    private Integer jscns02; // 结算承诺书份数
    private String jscns03; // 结算承诺书资料形式
    private String jscns04; // 结算承诺书要求
    private BigDecimal jscns05; // 结算承诺书报送金额
    private String jscns06; // 结算承诺书备注
    private String jshzb01; // 结算汇总表内容
    private Integer jshzb02; // 结算汇总表份数
    private String jshzb03; // 结算汇总表资料形式
    private String jshzb04; // 结算汇总表要求
    private BigDecimal jshzb05; // 结算汇总表报送金额
    private String jshzb06; // 结算汇总表备注
    private String zht01; // 主合同内容
    private Integer zht02; // 主合同份数
    private String zht03; // 主合同资料形式
    private String zht04; // 主合同要求
    private BigDecimal zht05; // 主合同报送金额
    private String zht06; // 主合同备注
    private String zhtqd01; // 主合同清单内容
    private Integer zhtqd02; // 主合同清单份数
    private String zhtqd03; // 主合同清单资料形式
    private String zhtqd04; // 主合同清单要求
    private BigDecimal zhtqd05; // 主合同清单报送金额
    private String zhtqd06; // 主合同清单备注
    private String bcxy01; // 补充协议内容
    private Integer bcxy02; // 补充协议份数
    private String bcxy03; // 补充协议资料形式
    private String bcxy04; // 补充协议要求
    private BigDecimal bcxy05; // 补充协议报送金额
    private String bcxy06; // 补充协议备注
    private String bcxyqd01; // 补充协议清单内容
    private Integer bcxyqd02; // 补充协议清单份数
    private String bcxyqd03; // 补充协议清单资料形式
    private String bcxyqd04; // 补充协议清单要求
    private BigDecimal bcxyqd05; // 补充协议清单报送金额
    private String bcxyqd06; // 补充协议清单备注
    private String jgt01; // 竣工图内容
    private Integer jgt02; // 竣工图份数
    private String jgt03; // 竣工图资料形式
    private String jgt04; // 竣工图要求
    private BigDecimal jgt05; // 竣工图报送金额
    private String jgt06; // 竣工图备注
    private String ygjgtzb01; // 乙供价格调整表内容
    private Integer ygjgtzb02; // 乙供价格调整表份数
    private String ygjgtzb03; // 乙供价格调整表资料形式
    private String ygjgtzb04; // 乙供价格调整表要求
    private BigDecimal ygjgtzb05; // 乙供价格调整表报送金额
    private String ygjgtzb06; // 乙供价格调整表备注
    private String qzd01; // 签证单内容
    private Integer qzd02; // 签证单份数
    private String qzd03; // 签证单资料形式
    private String qzd04; // 签证单要求
    private BigDecimal qzd05; // 签证单报送金额
    private String qzd06; // 签证单备注
    private String lhjgys01; // 联合竣工验收单内容
    private Integer lhjgys02; // 联合竣工验收单份数
    private String lhjgys03; // 联合竣工验收单资料形式
    private String lhjgys04; // 联合竣工验收单要求
    private BigDecimal lhjgys05; // 联合竣工验收单报送金额
    private String lhjgys06; // 联合竣工验收单备注
    private String qtxg01; // 其他相关资料内容
    private Integer qtxg02; // 其他相关资料份数
    private String qtxg03; // 其他相关资料资料形式
    private String qtxg04; // 其他相关资料要求
    private BigDecimal qtxg05; // 其他相关资料报送金额
    private String qtxg06; // 其他相关资料备注
    private Long contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private String projectCode; // 项目编码
    private Long safetyLaborSupId; // 安全劳务区域主管ID
    private String safetyLaborSupName; // 安全劳务区域主管Name
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getHasScopeChange() {
        return hasScopeChange;
    }

    public void setHasScopeChange(String hasScopeChange) {
        this.hasScopeChange = hasScopeChange;
    }
    public String getHasPendingItems() {
        return hasPendingItems;
    }

    public void setHasPendingItems(String hasPendingItems) {
        this.hasPendingItems = hasPendingItems;
    }
    public String getIsMaterialSupplyAsPerContract() {
        return isMaterialSupplyAsPerContract;
    }

    public void setIsMaterialSupplyAsPerContract(String isMaterialSupplyAsPerContract) {
        this.isMaterialSupplyAsPerContract = isMaterialSupplyAsPerContract;
    }
    public String getFinalQualityRectificationRate() {
        return finalQualityRectificationRate;
    }

    public void setFinalQualityRectificationRate(String finalQualityRectificationRate) {
        this.finalQualityRectificationRate = finalQualityRectificationRate;
    }
    public String getHasRectificationRatePenaltyClause() {
        return hasRectificationRatePenaltyClause;
    }

    public void setHasRectificationRatePenaltyClause(String hasRectificationRatePenaltyClause) {
        this.hasRectificationRatePenaltyClause = hasRectificationRatePenaltyClause;
    }
    public BigDecimal getLaborDeductionAndInsuranceAmount() {
        return laborDeductionAndInsuranceAmount;
    }

    public void setLaborDeductionAndInsuranceAmount(BigDecimal laborDeductionAndInsuranceAmount) {
        this.laborDeductionAndInsuranceAmount = laborDeductionAndInsuranceAmount;
    }
    public String getLaborDeductionReason() {
        return laborDeductionReason;
    }

    public void setLaborDeductionReason(String laborDeductionReason) {
        this.laborDeductionReason = laborDeductionReason;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getQaDeductionAmount() {
        return qaDeductionAmount;
    }

    public void setQaDeductionAmount(BigDecimal qaDeductionAmount) {
        this.qaDeductionAmount = qaDeductionAmount;
    }
    public String getQaDeductionReason() {
        return qaDeductionReason;
    }

    public void setQaDeductionReason(String qaDeductionReason) {
        this.qaDeductionReason = qaDeductionReason;
    }
    public BigDecimal getOverissueDeductionAmount() {
        return overissueDeductionAmount;
    }

    public void setOverissueDeductionAmount(BigDecimal overissueDeductionAmount) {
        this.overissueDeductionAmount = overissueDeductionAmount;
    }
    public String getOverissueDeductionReason() {
        return overissueDeductionReason;
    }

    public void setOverissueDeductionReason(String overissueDeductionReason) {
        this.overissueDeductionReason = overissueDeductionReason;
    }
    public BigDecimal getProcurementDeductionAmount() {
        return procurementDeductionAmount;
    }

    public void setProcurementDeductionAmount(BigDecimal procurementDeductionAmount) {
        this.procurementDeductionAmount = procurementDeductionAmount;
    }
    public String getProcurementDeductionReason() {
        return procurementDeductionReason;
    }

    public void setProcurementDeductionReason(String procurementDeductionReason) {
        this.procurementDeductionReason = procurementDeductionReason;
    }
    public BigDecimal getFinanceDeductionAmount() {
        return financeDeductionAmount;
    }

    public void setFinanceDeductionAmount(BigDecimal financeDeductionAmount) {
        this.financeDeductionAmount = financeDeductionAmount;
    }
    public String getFinanceDeductionReason() {
        return financeDeductionReason;
    }

    public void setFinanceDeductionReason(String financeDeductionReason) {
        this.financeDeductionReason = financeDeductionReason;
    }
    public String getJslx() {
        return jslx;
    }

    public void setJslx(String jslx) {
        this.jslx = jslx;
    }
    public String getLwjszl01() {
        return lwjszl01;
    }

    public void setLwjszl01(String lwjszl01) {
        this.lwjszl01 = lwjszl01;
    }
    public Integer getLwjszl02() {
        return lwjszl02;
    }

    public void setLwjszl02(Integer lwjszl02) {
        this.lwjszl02 = lwjszl02;
    }
    public String getLwjszl03() {
        return lwjszl03;
    }

    public void setLwjszl03(String lwjszl03) {
        this.lwjszl03 = lwjszl03;
    }
    public String getLwjszl04() {
        return lwjszl04;
    }

    public void setLwjszl04(String lwjszl04) {
        this.lwjszl04 = lwjszl04;
    }
    public BigDecimal getLwjszl05() {
        return lwjszl05;
    }

    public void setLwjszl05(BigDecimal lwjszl05) {
        this.lwjszl05 = lwjszl05;
    }
    public String getLwjszl06() {
        return lwjszl06;
    }

    public void setLwjszl06(String lwjszl06) {
        this.lwjszl06 = lwjszl06;
    }
    public String getJssfm01() {
        return jssfm01;
    }

    public void setJssfm01(String jssfm01) {
        this.jssfm01 = jssfm01;
    }
    public Integer getJssfm02() {
        return jssfm02;
    }

    public void setJssfm02(Integer jssfm02) {
        this.jssfm02 = jssfm02;
    }
    public String getJssfm03() {
        return jssfm03;
    }

    public void setJssfm03(String jssfm03) {
        this.jssfm03 = jssfm03;
    }
    public String getJssfm04() {
        return jssfm04;
    }

    public void setJssfm04(String jssfm04) {
        this.jssfm04 = jssfm04;
    }
    public BigDecimal getJssfm05() {
        return jssfm05;
    }

    public void setJssfm05(BigDecimal jssfm05) {
        this.jssfm05 = jssfm05;
    }
    public String getJssfm06() {
        return jssfm06;
    }

    public void setJssfm06(String jssfm06) {
        this.jssfm06 = jssfm06;
    }
    public String getJscns01() {
        return jscns01;
    }

    public void setJscns01(String jscns01) {
        this.jscns01 = jscns01;
    }
    public Integer getJscns02() {
        return jscns02;
    }

    public void setJscns02(Integer jscns02) {
        this.jscns02 = jscns02;
    }
    public String getJscns03() {
        return jscns03;
    }

    public void setJscns03(String jscns03) {
        this.jscns03 = jscns03;
    }
    public String getJscns04() {
        return jscns04;
    }

    public void setJscns04(String jscns04) {
        this.jscns04 = jscns04;
    }
    public BigDecimal getJscns05() {
        return jscns05;
    }

    public void setJscns05(BigDecimal jscns05) {
        this.jscns05 = jscns05;
    }
    public String getJscns06() {
        return jscns06;
    }

    public void setJscns06(String jscns06) {
        this.jscns06 = jscns06;
    }
    public String getJshzb01() {
        return jshzb01;
    }

    public void setJshzb01(String jshzb01) {
        this.jshzb01 = jshzb01;
    }
    public Integer getJshzb02() {
        return jshzb02;
    }

    public void setJshzb02(Integer jshzb02) {
        this.jshzb02 = jshzb02;
    }
    public String getJshzb03() {
        return jshzb03;
    }

    public void setJshzb03(String jshzb03) {
        this.jshzb03 = jshzb03;
    }
    public String getJshzb04() {
        return jshzb04;
    }

    public void setJshzb04(String jshzb04) {
        this.jshzb04 = jshzb04;
    }
    public BigDecimal getJshzb05() {
        return jshzb05;
    }

    public void setJshzb05(BigDecimal jshzb05) {
        this.jshzb05 = jshzb05;
    }
    public String getJshzb06() {
        return jshzb06;
    }

    public void setJshzb06(String jshzb06) {
        this.jshzb06 = jshzb06;
    }
    public String getZht01() {
        return zht01;
    }

    public void setZht01(String zht01) {
        this.zht01 = zht01;
    }
    public Integer getZht02() {
        return zht02;
    }

    public void setZht02(Integer zht02) {
        this.zht02 = zht02;
    }
    public String getZht03() {
        return zht03;
    }

    public void setZht03(String zht03) {
        this.zht03 = zht03;
    }
    public String getZht04() {
        return zht04;
    }

    public void setZht04(String zht04) {
        this.zht04 = zht04;
    }
    public BigDecimal getZht05() {
        return zht05;
    }

    public void setZht05(BigDecimal zht05) {
        this.zht05 = zht05;
    }
    public String getZht06() {
        return zht06;
    }

    public void setZht06(String zht06) {
        this.zht06 = zht06;
    }
    public String getZhtqd01() {
        return zhtqd01;
    }

    public void setZhtqd01(String zhtqd01) {
        this.zhtqd01 = zhtqd01;
    }
    public Integer getZhtqd02() {
        return zhtqd02;
    }

    public void setZhtqd02(Integer zhtqd02) {
        this.zhtqd02 = zhtqd02;
    }
    public String getZhtqd03() {
        return zhtqd03;
    }

    public void setZhtqd03(String zhtqd03) {
        this.zhtqd03 = zhtqd03;
    }
    public String getZhtqd04() {
        return zhtqd04;
    }

    public void setZhtqd04(String zhtqd04) {
        this.zhtqd04 = zhtqd04;
    }
    public BigDecimal getZhtqd05() {
        return zhtqd05;
    }

    public void setZhtqd05(BigDecimal zhtqd05) {
        this.zhtqd05 = zhtqd05;
    }
    public String getZhtqd06() {
        return zhtqd06;
    }

    public void setZhtqd06(String zhtqd06) {
        this.zhtqd06 = zhtqd06;
    }
    public String getBcxy01() {
        return bcxy01;
    }

    public void setBcxy01(String bcxy01) {
        this.bcxy01 = bcxy01;
    }
    public Integer getBcxy02() {
        return bcxy02;
    }

    public void setBcxy02(Integer bcxy02) {
        this.bcxy02 = bcxy02;
    }
    public String getBcxy03() {
        return bcxy03;
    }

    public void setBcxy03(String bcxy03) {
        this.bcxy03 = bcxy03;
    }
    public String getBcxy04() {
        return bcxy04;
    }

    public void setBcxy04(String bcxy04) {
        this.bcxy04 = bcxy04;
    }
    public BigDecimal getBcxy05() {
        return bcxy05;
    }

    public void setBcxy05(BigDecimal bcxy05) {
        this.bcxy05 = bcxy05;
    }
    public String getBcxy06() {
        return bcxy06;
    }

    public void setBcxy06(String bcxy06) {
        this.bcxy06 = bcxy06;
    }
    public String getBcxyqd01() {
        return bcxyqd01;
    }

    public void setBcxyqd01(String bcxyqd01) {
        this.bcxyqd01 = bcxyqd01;
    }
    public Integer getBcxyqd02() {
        return bcxyqd02;
    }

    public void setBcxyqd02(Integer bcxyqd02) {
        this.bcxyqd02 = bcxyqd02;
    }
    public String getBcxyqd03() {
        return bcxyqd03;
    }

    public void setBcxyqd03(String bcxyqd03) {
        this.bcxyqd03 = bcxyqd03;
    }
    public String getBcxyqd04() {
        return bcxyqd04;
    }

    public void setBcxyqd04(String bcxyqd04) {
        this.bcxyqd04 = bcxyqd04;
    }
    public BigDecimal getBcxyqd05() {
        return bcxyqd05;
    }

    public void setBcxyqd05(BigDecimal bcxyqd05) {
        this.bcxyqd05 = bcxyqd05;
    }
    public String getBcxyqd06() {
        return bcxyqd06;
    }

    public void setBcxyqd06(String bcxyqd06) {
        this.bcxyqd06 = bcxyqd06;
    }
    public String getJgt01() {
        return jgt01;
    }

    public void setJgt01(String jgt01) {
        this.jgt01 = jgt01;
    }
    public Integer getJgt02() {
        return jgt02;
    }

    public void setJgt02(Integer jgt02) {
        this.jgt02 = jgt02;
    }
    public String getJgt03() {
        return jgt03;
    }

    public void setJgt03(String jgt03) {
        this.jgt03 = jgt03;
    }
    public String getJgt04() {
        return jgt04;
    }

    public void setJgt04(String jgt04) {
        this.jgt04 = jgt04;
    }
    public BigDecimal getJgt05() {
        return jgt05;
    }

    public void setJgt05(BigDecimal jgt05) {
        this.jgt05 = jgt05;
    }
    public String getJgt06() {
        return jgt06;
    }

    public void setJgt06(String jgt06) {
        this.jgt06 = jgt06;
    }
    public String getYgjgtzb01() {
        return ygjgtzb01;
    }

    public void setYgjgtzb01(String ygjgtzb01) {
        this.ygjgtzb01 = ygjgtzb01;
    }
    public Integer getYgjgtzb02() {
        return ygjgtzb02;
    }

    public void setYgjgtzb02(Integer ygjgtzb02) {
        this.ygjgtzb02 = ygjgtzb02;
    }
    public String getYgjgtzb03() {
        return ygjgtzb03;
    }

    public void setYgjgtzb03(String ygjgtzb03) {
        this.ygjgtzb03 = ygjgtzb03;
    }
    public String getYgjgtzb04() {
        return ygjgtzb04;
    }

    public void setYgjgtzb04(String ygjgtzb04) {
        this.ygjgtzb04 = ygjgtzb04;
    }
    public BigDecimal getYgjgtzb05() {
        return ygjgtzb05;
    }

    public void setYgjgtzb05(BigDecimal ygjgtzb05) {
        this.ygjgtzb05 = ygjgtzb05;
    }
    public String getYgjgtzb06() {
        return ygjgtzb06;
    }

    public void setYgjgtzb06(String ygjgtzb06) {
        this.ygjgtzb06 = ygjgtzb06;
    }
    public String getQzd01() {
        return qzd01;
    }

    public void setQzd01(String qzd01) {
        this.qzd01 = qzd01;
    }
    public Integer getQzd02() {
        return qzd02;
    }

    public void setQzd02(Integer qzd02) {
        this.qzd02 = qzd02;
    }
    public String getQzd03() {
        return qzd03;
    }

    public void setQzd03(String qzd03) {
        this.qzd03 = qzd03;
    }
    public String getQzd04() {
        return qzd04;
    }

    public void setQzd04(String qzd04) {
        this.qzd04 = qzd04;
    }
    public BigDecimal getQzd05() {
        return qzd05;
    }

    public void setQzd05(BigDecimal qzd05) {
        this.qzd05 = qzd05;
    }
    public String getQzd06() {
        return qzd06;
    }

    public void setQzd06(String qzd06) {
        this.qzd06 = qzd06;
    }
    public String getLhjgys01() {
        return lhjgys01;
    }

    public void setLhjgys01(String lhjgys01) {
        this.lhjgys01 = lhjgys01;
    }
    public Integer getLhjgys02() {
        return lhjgys02;
    }

    public void setLhjgys02(Integer lhjgys02) {
        this.lhjgys02 = lhjgys02;
    }
    public String getLhjgys03() {
        return lhjgys03;
    }

    public void setLhjgys03(String lhjgys03) {
        this.lhjgys03 = lhjgys03;
    }
    public String getLhjgys04() {
        return lhjgys04;
    }

    public void setLhjgys04(String lhjgys04) {
        this.lhjgys04 = lhjgys04;
    }
    public BigDecimal getLhjgys05() {
        return lhjgys05;
    }

    public void setLhjgys05(BigDecimal lhjgys05) {
        this.lhjgys05 = lhjgys05;
    }
    public String getLhjgys06() {
        return lhjgys06;
    }

    public void setLhjgys06(String lhjgys06) {
        this.lhjgys06 = lhjgys06;
    }
    public String getQtxg01() {
        return qtxg01;
    }

    public void setQtxg01(String qtxg01) {
        this.qtxg01 = qtxg01;
    }
    public Integer getQtxg02() {
        return qtxg02;
    }

    public void setQtxg02(Integer qtxg02) {
        this.qtxg02 = qtxg02;
    }
    public String getQtxg03() {
        return qtxg03;
    }

    public void setQtxg03(String qtxg03) {
        this.qtxg03 = qtxg03;
    }
    public String getQtxg04() {
        return qtxg04;
    }

    public void setQtxg04(String qtxg04) {
        this.qtxg04 = qtxg04;
    }
    public BigDecimal getQtxg05() {
        return qtxg05;
    }

    public void setQtxg05(BigDecimal qtxg05) {
        this.qtxg05 = qtxg05;
    }
    public String getQtxg06() {
        return qtxg06;
    }

    public void setQtxg06(String qtxg06) {
        this.qtxg06 = qtxg06;
    }

    @ReferSerialTransfer(referCode="sub-contract-register")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @ReferSerialTransfer(referCode = "ref-ding-talk-employee")
    public Long getSafetyLaborSupId() {
        return safetyLaborSupId;
    }
    @ReferDeserialTransfer
    public void setSafetyLaborSupId(Long safetyLaborSupId) {
        this.safetyLaborSupId = safetyLaborSupId;
    }

    public String getSafetyLaborSupName() {
        return safetyLaborSupName;
    }

    public void setSafetyLaborSupName(String safetyLaborSupName) {
        this.safetyLaborSupName = safetyLaborSupName;
    }
    
}
