package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * @author zengke
 * @version 1.0
 * @see RequestPaymentReportVO
 * @since 2025/12/01 9:25
 */
public class RequestPaymentReportVO extends BaseVO {

    /**
     * 付款申请主键id
     */
    private String cashOutPaymentId;

    /**
     * 付款单顺序号
     */
    private String cashOutPaymentCode;

    /**
     * 项目id
     */
    private String cashOutProjectId;

    /**
     * 项目名称
     */
    private String cashOutProjectName;

    /**
     * 项目代码
     */
    private String cashOutProjectCode;

    /**
     * 供应商id
     */
    private String cashOutSupplierId;

    /**
     * 供应商
     */
    private String cashOutSupplierName;

    /**
     * 供应商代码
     */
    private String cashOutSupplierCode;

    /**
     * 合同id
     */
    private String cashOutContractId;

    /**
     * 合同编号
     */
    private String cashOutContractCode;

    /**
     * 合同名称
     */
    private String cashOutContractName;

    /**
     * 合同总金额
     */
    private String cashOutContractAmount;

    /**
     * 产品/劳务名称
     */
    private String cashOutLaborServiceName;

    /**
     * 审批通过时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date cashOutApproveTime;

    /**
     * 申请付款金额
     */
    private String cashOutApplyPaymentAmount;

    /**
     * 支付类型
     */
    private String cashOutFeeKind;

    /**
     * 支付类型名称
     */
    private String cashOutFeeKindName;

    /**
     * 租户id
     */
    private String cashOutTenantId;

    /**
     * 组织id
     */
    private String cashOutOrgId;

    /**
     * 组织名称
     */
    private String cashOutOrgName;

    /**
     * 报备付款时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date cashOutReportPaymentTime;

    /**
     * 加急原因
     */
    private String cashOutUrgentReason;

    /**
     * 报备付款人id
     */
    private Long cashOutPayerId;

    /**
     * 报备付款人
     */
    private String cashOutPayerName;

    public String getCashOutPaymentId() {
        return cashOutPaymentId;
    }

    public void setCashOutPaymentId(String cashOutPaymentId) {
        this.cashOutPaymentId = cashOutPaymentId;
    }

    public String getCashOutPaymentCode() {
        return cashOutPaymentCode;
    }

    public void setCashOutPaymentCode(String cashOutPaymentCode) {
        this.cashOutPaymentCode = cashOutPaymentCode;
    }

    public String getCashOutProjectId() {
        return cashOutProjectId;
    }

    public void setCashOutProjectId(String cashOutProjectId) {
        this.cashOutProjectId = cashOutProjectId;
    }

    public String getCashOutProjectName() {
        return cashOutProjectName;
    }

    public void setCashOutProjectName(String cashOutProjectName) {
        this.cashOutProjectName = cashOutProjectName;
    }

    public String getCashOutProjectCode() {
        return cashOutProjectCode;
    }

    public void setCashOutProjectCode(String cashOutProjectCode) {
        this.cashOutProjectCode = cashOutProjectCode;
    }

    public String getCashOutSupplierId() {
        return cashOutSupplierId;
    }

    public void setCashOutSupplierId(String cashOutSupplierId) {
        this.cashOutSupplierId = cashOutSupplierId;
    }

    public String getCashOutSupplierName() {
        return cashOutSupplierName;
    }

    public void setCashOutSupplierName(String cashOutSupplierName) {
        this.cashOutSupplierName = cashOutSupplierName;
    }

    public String getCashOutSupplierCode() {
        return cashOutSupplierCode;
    }

    public void setCashOutSupplierCode(String cashOutSupplierCode) {
        this.cashOutSupplierCode = cashOutSupplierCode;
    }

    public String getCashOutContractId() {
        return cashOutContractId;
    }

    public void setCashOutContractId(String cashOutContractId) {
        this.cashOutContractId = cashOutContractId;
    }

    public String getCashOutContractCode() {
        return cashOutContractCode;
    }

    public void setCashOutContractCode(String cashOutContractCode) {
        this.cashOutContractCode = cashOutContractCode;
    }

    public String getCashOutContractName() {
        return cashOutContractName;
    }

    public void setCashOutContractName(String cashOutContractName) {
        this.cashOutContractName = cashOutContractName;
    }

    public String getCashOutContractAmount() {
        return cashOutContractAmount;
    }

    public void setCashOutContractAmount(String cashOutContractAmount) {
        this.cashOutContractAmount = cashOutContractAmount;
    }

    public String getCashOutLaborServiceName() {
        return cashOutLaborServiceName;
    }

    public void setCashOutLaborServiceName(String cashOutLaborServiceName) {
        this.cashOutLaborServiceName = cashOutLaborServiceName;
    }

    public Date getCashOutApproveTime() {
        return cashOutApproveTime;
    }

    public void setCashOutApproveTime(Date cashOutApprovePassTime) {
        this.cashOutApproveTime = cashOutApprovePassTime;
    }

    public String getCashOutApplyPaymentAmount() {
        return cashOutApplyPaymentAmount;
    }

    public void setCashOutApplyPaymentAmount(String cashOutApplyPaymentAmount) {
        this.cashOutApplyPaymentAmount = cashOutApplyPaymentAmount;
    }

    public String getCashOutFeeKind() {
        return cashOutFeeKind;
    }

    public void setCashOutFeeKind(String cashOutFeeKind) {
        this.cashOutFeeKind = cashOutFeeKind;
    }

    public String getCashOutFeeKindName() {
        return cashOutFeeKindName;
    }

    public void setCashOutFeeKindName(String cashOutFeeKindName) {
        this.cashOutFeeKindName = cashOutFeeKindName;
    }

    public String getCashOutTenantId() {
        return cashOutTenantId;
    }

    public void setCashOutTenantId(String cashOutTenantId) {
        this.cashOutTenantId = cashOutTenantId;
    }

    public String getCashOutOrgId() {
        return cashOutOrgId;
    }

    public void setCashOutOrgId(String cashOutOrgId) {
        this.cashOutOrgId = cashOutOrgId;
    }

    public String getCashOutOrgName() {
        return cashOutOrgName;
    }

    public void setCashOutOrgName(String cashOutOrgName) {
        this.cashOutOrgName = cashOutOrgName;
    }

    public Date getCashOutReportPaymentTime() {
        return cashOutReportPaymentTime;
    }

    public void setCashOutReportPaymentTime(Date cashOutReportPaymentTime) {
        this.cashOutReportPaymentTime = cashOutReportPaymentTime;
    }

    public String getCashOutUrgentReason() {
        return cashOutUrgentReason;
    }

    public void setCashOutUrgentReason(String cashOutUrgentReason) {
        this.cashOutUrgentReason = cashOutUrgentReason;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getCashOutPayerId() {
        return cashOutPayerId;
    }

    @ReferDeserialTransfer
    public void setCashOutPayerId(Long cashOutPayerId) {
        this.cashOutPayerId = cashOutPayerId;
    }

    public String getCashOutPayerName() {
        return cashOutPayerName;
    }

    public void setCashOutPayerName(String cashOutPayerName) {
        this.cashOutPayerName = cashOutPayerName;
    }
}
