/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class CountCallable
implements Callable<JSONObject> {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private RequestAttributes context;
    private String authority;
    private String url;
    private QueryParam queryParam;
    private IBaseService service;

    public CountCallable(RequestAttributes context, String authority, String url, QueryParam queryParam, IBaseService service) {
        this.context = context;
        this.authority = authority;
        this.url = url;
        this.queryParam = queryParam;
        this.service = service;
    }

    @Override
    public JSONObject call() throws Exception {
        JSONObject back = new JSONObject();
        if (this.service == null) {
            this.context.setAttribute("authority", (Object)this.authority, 0);
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.context);
            String resp = HttpTookit.postByJson((String)this.url, (String)JSONObject.toJSONString((Object)this.queryParam));
            JSONObject json = JSONObject.parseObject((String)resp);
            if (json.getInteger("code") != 0) {
                this.logger.error("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff1a{}", (Object)json.getString("msg"));
                return new JSONObject();
            }
            JSONObject data = json.getJSONObject("data");
            if (data == null) {
                return new JSONObject();
            }
            back.put("records", (Object)data.getJSONArray("records"));
        } else {
            List list = this.service.queryList(this.queryParam, false);
            String json = JSON.toJSONString((Object)list);
            JSONArray records = JSONArray.parseArray((String)json);
            back.put("records", (Object)records);
        }
        return back;
    }
}

