/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class ValidateUtil {
    private static final Logger logger = LoggerFactory.getLogger(ValidateUtil.class);
    @Autowired
    private JedisPool jedisPool2;
    @Autowired
    private ICommenQueryFieldsService queryFieldsService2;
    private static JedisPool jedisPool;
    private static ICommenQueryFieldsService queryFieldsService;
    private static final String REQUEST_ID = "saveOrUpdate";
    private static ValidateUtil util;

    @PostConstruct
    public void init() {
        util = this;
        jedisPool = this.jedisPool2;
        queryFieldsService = this.queryFieldsService2;
    }

    public static Boolean validateUpstreamVersion(String billId, String billTypeCode, Integer version) {
        Boolean flag = true;
        if (version != null && version != 0) {
            Jedis jedis = jedisPool.getResource();
            boolean locked = false;
            try {
                locked = RedisTool.tryLock((Jedis)jedis, (String)billId, (String)REQUEST_ID, (int)1000);
                logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                if (locked) {
                    Object obj;
                    JSONObject json = queryFieldsService.queryBillDetail(billId, billTypeCode);
                    if (BillTypeCodeEnum.\u5206\u5305\u8fc7\u7a0b\u7ed3\u7b97.getBillTypeCode().equals(billTypeCode) && json.getJSONObject("data") == null) {
                        json = queryFieldsService.queryBillDetail(billId, BillTypeCodeEnum.\u5206\u5305\u5b8c\u5de5\u7ed3\u7b97.getBillTypeCode());
                    }
                    String str = (obj = json.getJSONObject("data").get((Object)"version")) != null ? obj.toString() : "0";
                    str = str.indexOf(".") > 0 ? str.substring(0, str.indexOf(".")) : str;
                    Integer dataVersion = Integer.parseInt(str);
                    if (version.intValue() != dataVersion.intValue()) {
                        flag = false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)billId, (String)REQUEST_ID);
                }
                jedis.close();
            }
        }
        return flag;
    }
}

