package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金退还表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_down_back")
public class BondDownBackVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金主键
     */
    private Long bondId;

    /**
     * 退还编号
     */
    private String billCode;

    /**
     * 退还金额
     */
    private BigDecimal backMny;

    /**
     * 备注
     */
    private String memo;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 经办人
     */
    private String employeeName;

    /**
     * 付款方式
     */
    private Long paymentWay;

    /**
     * 付款组织id
     */
    private Long paymentOrgId;

    /**
     * 付款组织名称
     */
    private String paymentOrgName;

    /**
     * 实际付款组织id
     */
    private Long actualOrgId;

    /**
     * 实际付款组织名称
     */
    private String actualOrgName;
    
    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getPaymentWay() {
        return paymentWay;
    }

    public void setPaymentWay(Long paymentWay) {
        this.paymentWay = paymentWay;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getPaymentOrgId() {
        return paymentOrgId;
    }

    @ReferDeserialTransfer
    public void setPaymentOrgId(Long paymentOrgId) {
        this.paymentOrgId = paymentOrgId;
    }

    public String getPaymentOrgName() {
        return paymentOrgName;
    }

    public void setPaymentOrgName(String paymentOrgName) {
        this.paymentOrgName = paymentOrgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getActualOrgId() {
        return actualOrgId;
    }

    @ReferDeserialTransfer
    public void setActualOrgId(Long actualOrgId) {
        this.actualOrgId = actualOrgId;
    }
 
    public String getActualOrgName() {
        return actualOrgName;
    }

    public void setActualOrgName(String actualOrgName) {
        this.actualOrgName = actualOrgName;
    }
}
