package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 保证金对下申请表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_down")
public class BondDownVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 申请编码
     */
    private String billCode;

    /**
     * 保证金类型
     */
    private Long bondType;

    /**
     * 保证金状态:0-待处理，1-有效
     */
    private String bondStatus;

    /**
     * 保函格式
     */
    private Long bondFormat;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 期限开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;

    /**
     * 期限结束日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 申请说明
     */
    private String memo;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 合同编号
     */
    private String contractCode;

    /**
     * 申请人
     */
    private Long applyEmployeeId;

    /**
     * 申请人名称
     */
    private String applyEmployeeName;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 供应商
     */
    private Long supplierId;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 合同金额
     */
    private BigDecimal contractTaxMny;

    /**
     * 保证金比例
     */
    private BigDecimal bondScale;

    /**
     * 已支付金额
     */
    private BigDecimal payMny;

    /**
     * 已退还金额
     */
    private BigDecimal backMny;

    /**
     * 单据状态（审批必须字段）
     */
    private Integer billState;

    private String billStateName;

    /**
     * 合同类型(1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁)
     */
    private String contractType;

    /**
     * 办理时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dealTime;

    private String dealStatus;

    private Integer contractVersion;

    /**
     * 收款方式
     */
    private Long paymentWay;

    /**
     * 收款组织id
     */
    private Long paymentOrgId;

    /**
     * 收款组织名称
     */
    private String paymentOrgName;

    /**
     * 实际收款组织id
     */
    private Long actualOrgId;

    /**
     * 实际收款组织名称
     */
    private String actualOrgName;
    
    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getBondScale() {
        return bondScale;
    }

    public void setBondScale(BigDecimal bondScale) {
        this.bondScale = bondScale;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }
    @ReferDeserialTransfer
    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBondType() {
        return bondType;
    }
    @ReferDeserialTransfer
    public void setBondType(Long bondType) {
        this.bondType = bondType;
    }
    public String getBondStatus() {
        return bondStatus;
    }

    public void setBondStatus(String bondStatus) {
        this.bondStatus = bondStatus;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBondFormat() {
        return bondFormat;
    }
    @ReferDeserialTransfer
    public void setBondFormat(Long bondFormat) {
        this.bondFormat = bondFormat;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getPaymentWay() {
        return paymentWay;
    }

    public void setPaymentWay(Long paymentWay) {
        this.paymentWay = paymentWay;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getPaymentOrgId() {
        return paymentOrgId;
    }

    @ReferDeserialTransfer
    public void setPaymentOrgId(Long paymentOrgId) {
        this.paymentOrgId = paymentOrgId;
    }

    public String getPaymentOrgName() {
        return paymentOrgName;
    }

    public void setPaymentOrgName(String paymentOrgName) {
        this.paymentOrgName = paymentOrgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getActualOrgId() {
        return actualOrgId;
    }

    @ReferDeserialTransfer
    public void setActualOrgId(Long actualOrgId) {
        this.actualOrgId = actualOrgId;
    }

    public String getActualOrgName() {
        return actualOrgName;
    }

    public void setActualOrgName(String actualOrgName) {
        this.actualOrgName = actualOrgName;
    }
}
