package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class PayContractVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    private Integer billState;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 备注
     */
    private String memo;

    /**
     * 付款类型：1-组织付款 2-项目付款
     */
    private Integer payType;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    private Integer payStatus;

    /**
     * 支付金额
     */
    private BigDecimal payMny;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    private Long contractType;

    /**
     * 合同编码
     */
    private String contractCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目类型：1-自营，2-联营
     */
    private String projectType;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 支付类型：1-预付款，2-过程款，3-其他
     */
    private Long feeType;

    /**
     * 付款事由
     */
    private String payReason;

    /**
     * 收款单位
     */
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    private String receiveUnitName;

    /**
     * 合同金额
     */
    private BigDecimal contractMny;

    /**
     * 已结算金额
     */
    private BigDecimal sumSettleMny;

    /**
     * 已支付金額
     */
    private BigDecimal sumPayMny;

    /**
     * 已收票金额
     */
    private BigDecimal sumInvoiceMny;

    /**
     * 申请人
     */
    private Long applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 银行账号
     */
    private String accountNum;

    /**
     * 开户行
     */
    private String accountBank;

    /**
     * 发票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 撤回原因
     */
    private String backReason;

    /**
     * 撤回时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 发票子表
     */
    private List<PayInvoiceVO> invoiceVOList;

    /**
     * 结算单子表
     */
    private List<PayContractSettleVO> settleVOList;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 已支付比例
     */
    private BigDecimal bePayScale;

    /**
     * 截止本期支付比例
     */
    private BigDecimal endthisPayScale;

    /**
     * 审批时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 采购类型 1-自采，2-集采
     */
    private String purchaseType;

    /**
     * 是否支出管理
     */
    private boolean manageFlag;

    /**
     * 属于项目:1-是，0-否
     */
    private String dependOnProject;

    /**
     * 项目类型名称
     */
    private String projectTypeName;

    /**
     * 单据状态名称
     */
    private String billStateName;

    /**
     * 支付类型名称
     */
    private String feeTypeName;

    /**
     * 合同版本号
     */
    private Integer contractVersion;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private Integer invoiceFlag;

    private Long contractStageId; // 合同付款阶段id
    private java.math.BigDecimal contractStageScale; // 合同付款阶段比例
    private String contractStageName; // 合同付款阶段名称
    private java.math.BigDecimal prepayMny; // 预付款金额
    private java.math.BigDecimal offsetMny; // 本次冲抵金额
    private java.math.BigDecimal lastOffsetMny; // 剩余可冲抵预付款

    private Long applyOrgId; //申请付款组织id
    private String applyOrgName; //申请付款组织名称
    private Long actualOrgId;  //实际付款组织id
    private String actualOrgName; //实际付款组织名称
    private Long paymentMethod; //收付款方式
    private String paymentMethodName; //收付款方式名称

    /**
     * 现金流量
     */
    private Long cashItemId;

    /**
     * 现金流量名称
     */
    private String cashItemName;

    /**
     * 来源ID
     */
    private String sourceId;

    /**
     * 项目资金余额
     */
    private BigDecimal projectBalanceTaxMny;
    
    /**
     * 应付账款余额
     */
    private BigDecimal accountsBalanceTaxMny;

    /**
     * 实际付款账户名
     */
    private String actualBankAccount;

    /**
     * 实际付款账号
     */
    private String actualBankCode;

    /**
     * 实际付款开户银行
     */
    private String actualBankName;
    
    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public boolean getManageFlag() {
        return manageFlag;
    }

    public void setManageFlag(boolean manageFlag) {
        this.manageFlag = manageFlag;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public BigDecimal getBePayScale() {
        return bePayScale;
    }

    public void setBePayScale(BigDecimal bePayScale) {
        this.bePayScale = bePayScale;
    }

    public BigDecimal getEndthisPayScale() {
        return endthisPayScale;
    }

    public void setEndthisPayScale(BigDecimal endthisPayScale) {
        this.endthisPayScale = endthisPayScale;
    }

    public List<PayInvoiceVO> getInvoiceVOList() {
        return invoiceVOList;
    }

    public void setInvoiceVOList(List<PayInvoiceVO> invoiceVOList) {
        this.invoiceVOList = invoiceVOList;
    }

    public List<PayContractSettleVO> getSettleVOList() {
        return settleVOList;
    }

    public void setSettleVOList(List<PayContractSettleVO> settleVOList) {
        this.settleVOList = settleVOList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    @ReferDeserialTransfer
    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public Integer getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(Integer invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public boolean isManageFlag() {
        return manageFlag;
    }

    public Long getContractStageId() {
        return contractStageId;
    }

    public void setContractStageId(Long contractStageId) {
        this.contractStageId = contractStageId;
    }

    public BigDecimal getContractStageScale() {
        return contractStageScale;
    }

    public void setContractStageScale(BigDecimal contractStageScale) {
        this.contractStageScale = contractStageScale;
    }

    public String getContractStageName() {
        return contractStageName;
    }

    public void setContractStageName(String contractStageName) {
        this.contractStageName = contractStageName;
    }

    public BigDecimal getPrepayMny() {
        return prepayMny;
    }

    public void setPrepayMny(BigDecimal prepayMny) {
        this.prepayMny = prepayMny;
    }

    public BigDecimal getOffsetMny() {
        return offsetMny;
    }

    public void setOffsetMny(BigDecimal offsetMny) {
        this.offsetMny = offsetMny;
    }

    public BigDecimal getLastOffsetMny() {
        return lastOffsetMny;
    }

    public void setLastOffsetMny(BigDecimal lastOffsetMny) {
        this.lastOffsetMny = lastOffsetMny;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getApplyOrgId() {
        return applyOrgId;
    }
    @ReferDeserialTransfer
    public void setApplyOrgId(Long applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getActualOrgId() {
        return actualOrgId;
    }
    @ReferDeserialTransfer
    public void setActualOrgId(Long actualOrgId) {
        this.actualOrgId = actualOrgId;
    }

    public String getActualOrgName() {
        return actualOrgName;
    }

    public void setActualOrgName(String actualOrgName) {
        this.actualOrgName = actualOrgName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPaymentMethod() {
        return paymentMethod;
    }
    @ReferDeserialTransfer
    public void setPaymentMethod(Long paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public String getPaymentMethodName() {
        return paymentMethodName;
    }

    public void setPaymentMethodName(String paymentMethodName) {
        this.paymentMethodName = paymentMethodName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCashItemId() {
        return cashItemId;
    }

    @ReferDeserialTransfer
    public void setCashItemId(Long cashItemId) {
        this.cashItemId = cashItemId;
    }

    public String getCashItemName() {
        return cashItemName;
    }

    public void setCashItemName(String cashItemName) {
        this.cashItemName = cashItemName;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
    
    public BigDecimal getProjectBalanceTaxMny() {
        return projectBalanceTaxMny;
    }

    public void setProjectBalanceTaxMny(BigDecimal projectBalanceTaxMny) {
        this.projectBalanceTaxMny = projectBalanceTaxMny;
    }
    
    public BigDecimal getAccountsBalanceTaxMny() {
        return accountsBalanceTaxMny;
    }

    public void setAccountsBalanceTaxMny(BigDecimal accountsBalanceTaxMny) {
        this.accountsBalanceTaxMny = accountsBalanceTaxMny;
    }

    public String getActualBankAccount() {
        return actualBankAccount;
    }

    public void setActualBankAccount(String actualBankAccount) {
        this.actualBankAccount = actualBankAccount;
    }

    public String getActualBankCode() {
        return actualBankCode;
    }

    public void setActualBankCode(String actualBankCode) {
        this.actualBankCode = actualBankCode;
    }

    public String getActualBankName() {
        return actualBankName;
    }

    public void setActualBankName(String actualBankName) {
        this.actualBankName = actualBankName;
    }
}
