package com.ejianc.business.finance.api;

import com.ejianc.business.finance.hystrix.FinanceBlocKanBanHystrix;
import com.ejianc.business.finance.vo.BlocKanBanVo;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @ClassName: BlocKanBanApi
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/9/7 9:32
 */
@FeignClient(name= "ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", fallback = FinanceBlocKanBanHystrix.class)
public interface IFinanceBlocKanBanApi {

    @GetMapping(value = "/api/blocKanBan/querySupplierPayMny")
    CommonResponse<List<BlocKanBanVo>> querySupplierPayMny(@RequestParam(value = "orgId") Long orgId
            , @RequestParam(value = "mnyFlag") Integer mnyFlag, @RequestParam(value = "yearFlag") Integer yearFlag);




}
