package com.ejianc.business.finance.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.hystrix.ProjectBoardHystrix;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 项目看板接口
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", fallback = ProjectBoardHystrix.class)
public interface IProjectBoardApi {

	/**
	 * 根据项目id，查询项目收付款以及合同金额
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "/api/project/queryPayAndReceiveByProjectId")
	public CommonResponse<JSONObject> queryPayAndReceiveByProjectId(@RequestParam(value = "projectId") Long projectId);

	/**
	 * 根据项目id，查询项目资金数据
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "/api/project/queryReceiveInfoByProjectId")
	public CommonResponse<JSONObject> queryReceiveInfoByProjectId(@RequestParam(value = "projectId") Long projectId);

	/**
	 * 根据项目id，查询项目成本数据
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "/api/project/queryCostByProjectId")
	public CommonResponse<JSONObject> queryCostByProjectId(@RequestParam(value = "projectId") Long projectId);

	/**
	 * 根据项目id，查询项目收支统计
	 * @param projectId
	 * @return
	 */
	@GetMapping(value = "/api/project/queryIncoemAndExpendByProjectId")
	public CommonResponse<JSONObject> queryIncoemAndExpendByProjectId(@RequestParam(value = "projectId") Long projectId);

}
