package com.ejianc.business.finance.vo;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;

/**
 * <p>
 * 保证金办理表
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@TableName("ejc_finance_bond_down_deal")
public class BondDownDealVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 保证金主键
     */
    private Long bondId;

    /**
     * 保证函编号
     */
    private String billCode;

    /**
     * 保证金类型 0-投标保证金，1-履约保证金，2-质量保证金 
     */
    private Long bondType;

    /**
     * 保证金金额
     */
    private BigDecimal bondMny;

    /**
     * 开具银行
     */
    private String bankNames;

    /**
     * 开立时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate;

    /**
     * 有效期至
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 备注
     */
    private String memo;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date dealDate;

    /**
     * 办理状态:1-生效，2-已作废
     */
    private String dealStatus;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 办理时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date dealTime;

    /**
     * 经办人
     */
    private String employeeName;

    /*
     * 来源id
     * */
    private String sourceId;

    public Long getBondId() {
        return bondId;
    }

    public void setBondId(Long bondId) {
        this.bondId = bondId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBondType() {
        return bondType;
    }
    @ReferDeserialTransfer
    public void setBondType(Long bondType) {
        this.bondType = bondType;
    }

    public BigDecimal getBondMny() {
        return bondMny;
    }

    public void setBondMny(BigDecimal bondMny) {
        this.bondMny = bondMny;
    }
    public String getBankNames() {
        return bankNames;
    }

    public void setBankNames(String bankNames) {
        this.bankNames = bankNames;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getDealDate() {
        return dealDate;
    }

    public void setDealDate(Date dealDate) {
        this.dealDate = dealDate;
    }
    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }
}
