package com.ejianc.business.finance.vo;

import java.math.BigDecimal;
import java.util.List;

/**
 * @ClassName: ProjectLedgerVO
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/5/26 15:50
 */
public class ProjectLedgerVO {

    private static final long serialVersionUID = 1L;

    /**
     * 项目主键
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 累计收款
     */
    private BigDecimal sumReceiveMny;

    /**
     * 累计支出
     */
    private BigDecimal sumPayMny;
    
    /**
     * 借款余额
     */
    private BigDecimal sumApplyMny;

    /**
     * 账面资金
     */
    private BigDecimal bookFunds;

    /**
     * 支出明细
     */
    private List<ExpenditureVO> expenditureList;

    /**
     * 收入明细
     */
    private List<IncomeVO> incomeList;
    
    /**
     * 借款明细
     */
    private List<LoadApplyVO> loadApplyList;
    
    /**
     * 还款明细
     */
    private List<LoadBackVO> loadBackList;


    public BigDecimal getSumApplyMny() {
		return sumApplyMny;
	}

	public void setSumApplyMny(BigDecimal sumApplyMny) {
		this.sumApplyMny = sumApplyMny;
	}

	public List<LoadApplyVO> getLoadApplyList() {
		return loadApplyList;
	}

	public void setLoadApplyList(List<LoadApplyVO> loadApplyList) {
		this.loadApplyList = loadApplyList;
	}

	public List<LoadBackVO> getLoadBackList() {
		return loadBackList;
	}

	public void setLoadBackList(List<LoadBackVO> loadBackList) {
		this.loadBackList = loadBackList;
	}

	public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public BigDecimal getSumReceiveMny() {
        return sumReceiveMny;
    }

    public void setSumReceiveMny(BigDecimal sumReceiveMny) {
        this.sumReceiveMny = sumReceiveMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getBookFunds() {
        return bookFunds;
    }

    public void setBookFunds(BigDecimal bookFunds) {
        this.bookFunds = bookFunds;
    }

    public List<ExpenditureVO> getExpenditureList() {
        return expenditureList;
    }

    public void setExpenditureList(List<ExpenditureVO> expenditureList) {
        this.expenditureList = expenditureList;
    }

    public List<IncomeVO> getIncomeList() {
        return incomeList;
    }

    public void setIncomeList(List<IncomeVO> incomeList) {
        this.incomeList = incomeList;
    }
}
