package com.ejianc.business.finance.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 收款方式信息
 * 
 * @author generator
 * 
 */
public class ReceiveReceiptVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long receiveId; // 付款申请单主键
    private Long balatypeId; // 收款方式id
    private String balatypeName; // 收款方式
    private java.math.BigDecimal localMny; // 金额(不含税)
    private java.math.BigDecimal localMnyTax; // 金额(含税)
    private Long bankAccount; // 银行账户id
    private String bankCode; // 银行账户code
    private String cashitem; // 现金流量项目
    private Long cashitemId; // 现金流量id
    private String createUserName; // 创建者名称
    private String rowState;
    

    /**
     * 付款申请单主键
     */
    public Long getReceiveId() {
        return receiveId;
    }

    /**
     * 付款申请单主键
     */
    public void setReceiveId(Long receiveId) {
        this.receiveId = receiveId;
    }
    /**
     * 收款方式id
     */
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getBalatypeId() {
        return balatypeId;
    }

    /**
     * 收款方式id
     */
    @ReferDeserialTransfer
    public void setBalatypeId(Long balatypeId) {
        this.balatypeId = balatypeId;
    }

    public String getBalatypeName() {
        return balatypeName;
    }

    public void setBalatypeName(String balatypeName) {
        this.balatypeName = balatypeName;
    }

    /**
     * 金额(不含税)
     */
    public java.math.BigDecimal getLocalMny() {
        return localMny;
    }

    /**
     * 金额(不含税)
     */
    public void setLocalMny(java.math.BigDecimal localMny) {
        this.localMny = localMny;
    }
    /**
     * 金额(含税)
     */
    public java.math.BigDecimal getLocalMnyTax() {
        return localMnyTax;
    }

    /**
     * 金额(含税)
     */
    public void setLocalMnyTax(java.math.BigDecimal localMnyTax) {
        this.localMnyTax = localMnyTax;
    }
    /**
     * 银行账户id
     */
    public Long getBankAccount() {
        return bankAccount;
    }

    /**
     * 银行账户id
     */
    public void setBankAccount(Long bankAccount) {
        this.bankAccount = bankAccount;
    }
    /**
     * 银行账户code
     */
    public String getBankCode() {
        return bankCode;
    }

    /**
     * 银行账户code
     */
    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }
    /**
     * 现金流量项目
     */
    public String getCashitem() {
        return cashitem;
    }

    /**
     * 现金流量项目
     */
    public void setCashitem(String cashitem) {
        this.cashitem = cashitem;
    }
    /**
     * 现金流量id
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCashitemId() {
        return cashitemId;
    }

    /**
     * 现金流量id
     */
    @ReferDeserialTransfer
    public void setCashitemId(Long cashitemId) {
        this.cashitemId = cashitemId;
    }
    /**
     * 创建者名称
     */
    public String getCreateUserName() {
        return createUserName;
    }

    /**
     * 创建者名称
     */
    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @Override
    public String getRowState() {
        return rowState;
    }

    @Override
    public void setRowState(String rowState) {
        this.rowState = rowState;
    }
}
