package com.ejianc.business.finance.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.finance.vo.OtherDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 其他费用
 * 
 * @author generator
 * 
 */
public class OtherVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private java.lang.String memo; // 备注
    private java.lang.String projectCode; // 项目编码
    private java.lang.Long projectId; // 项目
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 组织
    private java.lang.String orgName; // 组织名称
    private java.lang.Long employeeId; // 经办人
    private java.lang.String employeeName; // 经办人名称
    private java.math.BigDecimal costMny; // 费用金额(无税)
    private java.math.BigDecimal costTaxMny; // 费用金额
    private java.math.BigDecimal taxRate; // 税率
    private java.math.BigDecimal costTax; // 税额
    private java.lang.Long deptId; // 部门主键
    private java.lang.String deptName; // 部门名称
    private java.lang.Long costTypeId; // 费用类型
    private java.lang.String costTypeName; // 费用类型名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date happenDate; // 发生日期
    private java.lang.Long projectDepartmentId; // 项目部id
    private String billStateName; //单据状态名称
    /**
     * 关联状态(1:是，0：否)
     */
    private String relationFlag;
    
    private List<OtherDetailVO> otherDetailList = new ArrayList<>(); // 其他费用明细

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 备注
     */
    public java.lang.String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(java.lang.String memo) {
        this.memo = memo;
    }
    /**
     * 项目编码
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="market-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-employee")
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 费用金额(无税)
     */
    public java.math.BigDecimal getCostMny() {
        return costMny;
    }

    /**
     * 费用金额(无税)
     */
    public void setCostMny(java.math.BigDecimal costMny) {
        this.costMny = costMny;
    }
    /**
     * 费用金额
     */
    public java.math.BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    /**
     * 费用金额
     */
    public void setCostTaxMny(java.math.BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    /**
     * 税率
     */
    public java.math.BigDecimal getTaxRate() {
        return taxRate;
    }

    /**
     * 税率
     */
    public void setTaxRate(java.math.BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    /**
     * 税额
     */
    public java.math.BigDecimal getCostTax() {
        return costTax;
    }

    /**
     * 税额
     */
    public void setCostTax(java.math.BigDecimal costTax) {
        this.costTax = costTax;
    }
    /**
     * 部门主键
     */
    @ReferSerialTransfer(referCode="idm-dept")
    public java.lang.Long getDeptId() {
        return deptId;
    }

    /**
     * 部门主键
     */
    @ReferDeserialTransfer
    public void setDeptId(java.lang.Long deptId) {
        this.deptId = deptId;
    }
    /**
     * 部门名称
     */
    public java.lang.String getDeptName() {
        return deptName;
    }

    /**
     * 部门名称
     */
    public void setDeptName(java.lang.String deptName) {
        this.deptName = deptName;
    }
    /**
     * 费用类型
     */
    @ReferSerialTransfer(referCode = "support-defdoc")
    public java.lang.Long getCostTypeId() {
        return costTypeId;
    }

    /**
     * 费用类型
     */
    @ReferDeserialTransfer
    public void setCostTypeId(java.lang.Long costTypeId) {
        this.costTypeId = costTypeId;
    }
    /**
     * 费用类型名称
     */
    public java.lang.String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 费用类型名称
     */
    public void setCostTypeName(java.lang.String costTypeName) {
        this.costTypeName = costTypeName;
    }
    /**
     * 发生日期
     */
    public java.util.Date getHappenDate() {
        return happenDate;
    }

    /**
     * 发生日期
     */
    public void setHappenDate(java.util.Date happenDate) {
        this.happenDate = happenDate;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public List<OtherDetailVO> getOtherDetailList() {
        return otherDetailList;
    }

    public void setOtherDetailList(List<OtherDetailVO> otherDetailList) {
        this.otherDetailList = otherDetailList;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }
}
