package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class PayForegiftVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    private Integer billState;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 备注
     */
    private String memo;

    /**
     * 付款类型：1-组织付款 2-项目付款
     */
    private Integer payType;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    private Integer payStatus;

    /**
     * 支付金额
     */
    private BigDecimal payMny;

    /**
     * 是否逾期：1-已逾期 0-未逾期
     */
    private Integer overdueFlag;

    /**
     * 返还金额
     */
    private BigDecimal returnMny;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    private Long contractType;

    /**
     * 合同编码
     */
    private String contractCode;

    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 合同金额
     */
    private BigDecimal contractMny;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 付款事由
     */
    private String payReason;

    /**
     * 收款单位
     */
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    private String receiveUnitName;

    /**
     * 申请人
     */
    private Long applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请时间
     */
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 账户名称
     */
    private String accountName;

    /**
     * 银行账号
     */
    private String accountNum;

    /**
     * 开户行
     */
    private String accountBank;

    /**
     * 撤回原因
     */
    private String backReason;

    /**
     * 撤回时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 预计退还日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date planTime;

    /**
     * 预计退还计划子表
     */
    private List<PayForegiftPlanVO> planVOList;

    /**
     * 退还记录子表
     */
    private List<PayForegiftRecordVO> recordVOList;


    /**
     * 审批时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 押金比例
     */
    private BigDecimal foregiftScale;

    /**
     * 剩余返还金额
     */
    private BigDecimal surplusReturnMny;

    /**
     * 是否支出管理
     */
    private boolean manageFlag;

    /**
     * 属于项目:1-是，0-否
     */
    private String dependOnProject;

    /**
     * 采购类型 1-自采，2-集采
     */
    private String purchaseType;

    /**
     * 单据状态名称
     */
    private String billStateName;

    /**
     * 合同版本号
     */
    private Integer contractVersion;
    
    /**
     * 项目资金余额
     */
    private BigDecimal projectBalanceTaxMny;
    
    /**
     * 应付账款余额
     */
    private BigDecimal accountsBalanceTaxMny;
    
    /**
     * 开户行主键
     */
    private Long accountBankId;
    
    /**
     * 开户行编码
     */
    private String accountBankCode;
    
    /**
     * 收款对象类型 qy企业 gr个人
     */
    private String collectionType;
    
    /**
	 * 申请付款组织id
	 */
	private Long applyOrgId;

	/**
	 * 申请付款组织名称
	 */
	private String applyOrgName;

	/**
	 * 实际付款组织id
	 */
	private Long actualOrgId;

	/**
	 * 实际付款组织名称
	 */
	private String actualOrgName;

	/**
	 * 现金流量
	 */
	private Long cashItemId;

	/**
	 * 现金流量名称
	 */
	private String cashItemName;

	/**
	 * 实际付款账户名
	 */
	private String actualBankAccount;

	/**
	 * 实际付款账号
	 */
	private String actualBankCode;

	/**
	 * 实际付款开户银行
	 */
	private String actualBankName;

    private Long paymentMethod; //收付款方式
    private String paymentMethodName; //收付款方式名称
    
    /**
     * 来源ID
     */
    private String sourceId;
    
    
    public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}

	@ReferSerialTransfer(referCode = "idm-org")
	public Long getApplyOrgId() {
		return applyOrgId;
	}

	@ReferDeserialTransfer
	public void setApplyOrgId(Long applyOrgId) {
		this.applyOrgId = applyOrgId;
	}

	public String getApplyOrgName() {
		return applyOrgName;
	}

	public void setApplyOrgName(String applyOrgName) {
		this.applyOrgName = applyOrgName;
	}

	@ReferSerialTransfer(referCode = "idm-org")
	public Long getActualOrgId() {
		return actualOrgId;
	}

	@ReferDeserialTransfer
	public void setActualOrgId(Long actualOrgId) {
		this.actualOrgId = actualOrgId;
	}

	public String getActualOrgName() {
		return actualOrgName;
	}

	public void setActualOrgName(String actualOrgName) {
		this.actualOrgName = actualOrgName;
	}

	@ReferSerialTransfer(referCode = "support-defdoc")
	public Long getCashItemId() {
		return cashItemId;
	}

	@ReferDeserialTransfer
	public void setCashItemId(Long cashItemId) {
		this.cashItemId = cashItemId;
	}

	public String getCashItemName() {
		return cashItemName;
	}

	public void setCashItemName(String cashItemName) {
		this.cashItemName = cashItemName;
	}

	public String getActualBankAccount() {
		return actualBankAccount;
	}

	public void setActualBankAccount(String actualBankAccount) {
		this.actualBankAccount = actualBankAccount;
	}

	public String getActualBankCode() {
		return actualBankCode;
	}

	public void setActualBankCode(String actualBankCode) {
		this.actualBankCode = actualBankCode;
	}

	public String getActualBankName() {
		return actualBankName;
	}

	public void setActualBankName(String actualBankName) {
		this.actualBankName = actualBankName;
	}

	@ReferSerialTransfer(referCode = "support-defdoc")
	public Long getPaymentMethod() {
		return paymentMethod;
	}

	@ReferDeserialTransfer
	public void setPaymentMethod(Long paymentMethod) {
		this.paymentMethod = paymentMethod;
	}

	public String getPaymentMethodName() {
		return paymentMethodName;
	}

	public void setPaymentMethodName(String paymentMethodName) {
		this.paymentMethodName = paymentMethodName;
	}

	public String getCollectionType() {
		return collectionType;
	}

	public void setCollectionType(String collectionType) {
		this.collectionType = collectionType;
	}
    
    @ReferSerialTransfer(referCode = "support-bank")
    public Long getAccountBankId() {
		return accountBankId;
	}
    
    @ReferDeserialTransfer
	public void setAccountBankId(Long accountBankId) {
		this.accountBankId = accountBankId;
	}

	public String getAccountBankCode() {
		return accountBankCode;
	}

	public void setAccountBankCode(String accountBankCode) {
		this.accountBankCode = accountBankCode;
	}
    
    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public boolean getManageFlag() {
        return manageFlag;
    }

    public void setManageFlag(boolean manageFlag) {
        this.manageFlag = manageFlag;
    }

    public BigDecimal getSurplusReturnMny() {
        return surplusReturnMny;
    }

    public void setSurplusReturnMny(BigDecimal surplusReturnMny) {
        this.surplusReturnMny = surplusReturnMny;
    }

    public BigDecimal getForegiftScale() {
        return foregiftScale;
    }

    public void setForegiftScale(BigDecimal foregiftScale) {
        this.foregiftScale = foregiftScale;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public List<PayForegiftPlanVO> getPlanVOList() {
        return planVOList;
    }

    public void setPlanVOList(List<PayForegiftPlanVO> planVOList) {
        this.planVOList = planVOList;
    }

    public List<PayForegiftRecordVO> getRecordVOList() {
        return recordVOList;
    }

    public void setRecordVOList(List<PayForegiftRecordVO> recordVOList) {
        this.recordVOList = recordVOList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Integer getOverdueFlag() {
        return overdueFlag;
    }

    public void setOverdueFlag(Integer overdueFlag) {
        this.overdueFlag = overdueFlag;
    }

    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    @ReferDeserialTransfer
    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public Date getPlanTime() {
        return planTime;
    }

    public void setPlanTime(Date planTime) {
        this.planTime = planTime;
    }
    
    public BigDecimal getProjectBalanceTaxMny() {
        return projectBalanceTaxMny;
    }

    public void setProjectBalanceTaxMny(BigDecimal projectBalanceTaxMny) {
        this.projectBalanceTaxMny = projectBalanceTaxMny;
    }
    
    public BigDecimal getAccountsBalanceTaxMny() {
        return accountsBalanceTaxMny;
    }

    public void setAccountsBalanceTaxMny(BigDecimal accountsBalanceTaxMny) {
        this.accountsBalanceTaxMny = accountsBalanceTaxMny;
    }
}
