package com.ejianc.business.finance.vo;

import java.math.BigDecimal;

/**
 * @ClassName: BlocKanBanVo
 * @Description:
 * @Author: 曹鹏辉
 * @Date: 2021/9/5 16:24
 */
public class BlocKanBanVo {

    private static final long serialVersionUID = 1L;

    /**
     * 收款单位(供应商)
     */
    private Long receiveUnitId;

    /**
     * 收款单位名称(供应商)
     */
    private String receiveUnitName;

    /**
     * 合同总金额
     */
    private BigDecimal totalContractTaxMny;

    /**
     * 支付金额
     */
    private BigDecimal totalPayMny;

    /**
     * 欠付金额
     */
    private BigDecimal owedMny;

    /**
     * 分包金额所占比例
     */
    private BigDecimal supplierRate;

    private BigDecimal settleTaxMny; // 分包(物资材料)结算金额
    private BigDecimal finishSettleTaxMny; // 分包完工结算金额

    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public BigDecimal getTotalContractTaxMny() {
        return totalContractTaxMny;
    }

    public void setTotalContractTaxMny(BigDecimal totalContractTaxMny) {
        this.totalContractTaxMny = totalContractTaxMny;
    }

    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }

    public BigDecimal getOwedMny() {
        return owedMny;
    }

    public void setOwedMny(BigDecimal owedMny) {
        this.owedMny = owedMny;
    }

    public BigDecimal getSupplierRate() {
        return supplierRate;
    }

    public void setSupplierRate(BigDecimal supplierRate) {
        this.supplierRate = supplierRate;
    }

    public BigDecimal getSettleTaxMny() {
        return settleTaxMny;
    }

    public void setSettleTaxMny(BigDecimal settleTaxMny) {
        this.settleTaxMny = settleTaxMny;
    }

    public BigDecimal getFinishSettleTaxMny() {
        return finishSettleTaxMny;
    }

    public void setFinishSettleTaxMny(BigDecimal finishSettleTaxMny) {
        this.finishSettleTaxMny = finishSettleTaxMny;
    }
}
