package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class PayContractSettleVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 付款申请单主键
     */
    private Long payapplyId;

    /**
     * 来源结算单主键
     */
    private Long settleId;

    /**
     * 结算单编号
     */
    private String settleCode;

    /**
     * 本期结算金额
     */
    private BigDecimal settleMny;

    /**
     * 本期申请金额
     */
    private BigDecimal bodyApplyMny;

    /**
     * 已申请金额
     */
    private BigDecimal sumApplyMny;

    /**
     * 合同支付比例
     */
    private BigDecimal payScale;

    /**
     * 创建者名称
     */
    private String createUserName;

    /**
     * 剩余可申请金额
     */
    private BigDecimal surplusApplyMny;

    /**
     * 约定支付金额
     */
    private BigDecimal contractPayMny;

    /**
     * 结算单版本号
     */
    private Integer settleVersion;

    /**
     * 结算单类型：1-过程结算，2-完工结算
     */
    private Integer settleType;

    private BigDecimal curOffsetMny; // 本期冲抵预付款

    private Long bodyProjectId; // 项目
    private String bodyProjectName; // 项目名称

    private Long settlePaymentMethod; //收付款方式
    private String settlePaymentMethodName; //收付款方式名称
    private BigDecimal paymnyScale;
    
    

    public BigDecimal getPaymnyScale() {
		return paymnyScale;
	}

	public void setPaymnyScale(BigDecimal paymnyScale) {
		this.paymnyScale = paymnyScale;
	}

	public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }

    public Integer getSettleVersion() {
        return settleVersion;
    }

    public void setSettleVersion(Integer settleVersion) {
        this.settleVersion = settleVersion;
    }

    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }

    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }

    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }

    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }

    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }

    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }

    public BigDecimal getBodyApplyMny() {
        return bodyApplyMny;
    }

    public void setBodyApplyMny(BigDecimal bodyApplyMny) {
        this.bodyApplyMny = bodyApplyMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public BigDecimal getCurOffsetMny() {
        return curOffsetMny;
    }

    public void setCurOffsetMny(BigDecimal curOffsetMny) {
        this.curOffsetMny = curOffsetMny;
    }

    public Long getBodyProjectId() {
        return bodyProjectId;
    }

    public void setBodyProjectId(Long bodyProjectId) {
        this.bodyProjectId = bodyProjectId;
    }

    public String getBodyProjectName() {
        return bodyProjectName;
    }

    public void setBodyProjectName(String bodyProjectName) {
        this.bodyProjectName = bodyProjectName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSettlePaymentMethod() {
        return settlePaymentMethod;
    }
    @ReferDeserialTransfer
    public void setSettlePaymentMethod(Long settlePaymentMethod) {
        this.settlePaymentMethod = settlePaymentMethod;
    }

    public String getSettlePaymentMethodName() {
        return settlePaymentMethodName;
    }

    public void setSettlePaymentMethodName(String settlePaymentMethodName) {
        this.settlePaymentMethodName = settlePaymentMethodName;
    }
}
